/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.filter.AbstractFilter;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;
import org.geotools.filter.SQLEncoderException;

public class SQLEncoder
implements FilterVisitor {
    private static final String IO_ERROR = "io problem writing filter";
    private static FilterCapabilities capabilities = null;
    private static Logger log = Logger.getLogger("org.geotools.filter");
    private static Map comparisions = new HashMap();
    private static Map spatial = new HashMap();
    private static Map logical = new HashMap();
    private static Map expressions = new HashMap();
    protected Writer out;

    public SQLEncoder() {
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities capabilities = new FilterCapabilities();
        capabilities.addType((short)1);
        capabilities.addType((short)2);
        capabilities.addType((short)3);
        capabilities.addType((short)14);
        capabilities.addType((short)23);
        capabilities.addType((short)15);
        capabilities.addType((short)16);
        capabilities.addType((short)17);
        capabilities.addType((short)18);
        capabilities.addType((short)21);
        capabilities.addType((short)19);
        capabilities.addType((short)12345);
        capabilities.addType((short)-12345);
        return capabilities;
    }

    public SQLEncoder(Writer out, Filter filter) throws SQLEncoderException {
        if (this.getCapabilities().fullySupports(filter)) {
            this.out = out;
            try {
                out.write("WHERE ");
                filter.accept((FilterVisitor)this);
            }
            catch (IOException ioe) {
                log.warning("Unable to export filter: " + ioe);
                throw new SQLEncoderException("Problem writing filter: ", ioe);
            }
        } else {
            throw new SQLEncoderException("Filter type not supported");
        }
    }

    public void encode(Writer out, Filter filter) throws SQLEncoderException {
        if (this.getCapabilities().fullySupports(filter)) {
            this.out = out;
            try {
                out.write("WHERE ");
                filter.accept((FilterVisitor)this);
            }
            catch (IOException ioe) {
                log.warning("Unable to export filter" + ioe);
                throw new SQLEncoderException("Problem writing filter: ", ioe);
            }
        } else {
            throw new SQLEncoderException("Filter type not supported");
        }
    }

    public String encode(Filter filter) throws SQLEncoderException {
        StringWriter output = new StringWriter();
        this.encode(output, filter);
        return output.getBuffer().toString();
    }

    public synchronized FilterCapabilities getCapabilities() {
        if (capabilities == null) {
            capabilities = this.createFilterCapabilities();
        }
        return capabilities;
    }

    public void visit(Filter filter) {
        try {
            if (filter.getFilterType() == 12345) {
                this.out.write("TRUE");
            } else if (filter.getFilterType() == -12345) {
                this.out.write("FALSE");
            }
            log.warning("exporting unknown filter type");
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
    }

    public void visit(BetweenFilter filter) throws RuntimeException {
        log.finer("exporting BetweenFilter");
        DefaultExpression left = (DefaultExpression)filter.getLeftValue();
        DefaultExpression right = (DefaultExpression)filter.getRightValue();
        DefaultExpression mid = (DefaultExpression)filter.getMiddleValue();
        log.finer("Filter type id is " + filter.getFilterType());
        log.finer("Filter type text is " + comparisions.get(new Integer(filter.getFilterType())));
        try {
            mid.accept((FilterVisitor)this);
            this.out.write(" BETWEEN ");
            left.accept((FilterVisitor)this);
            this.out.write(" AND ");
            right.accept((FilterVisitor)this);
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
    }

    public void visit(LikeFilter filter) throws UnsupportedOperationException {
        String message = "Like Filter support not yet added.";
        throw new UnsupportedOperationException(message);
    }

    public void visit(LogicFilter filter) throws RuntimeException {
        log.finer("exporting LogicFilter");
        filter.getFilterType();
        String type = (String)logical.get(new Integer(filter.getFilterType()));
        try {
            Iterator list = filter.getFilterIterator();
            if (filter.getFilterType() == 3) {
                this.out.write(" NOT (");
                ((AbstractFilter)list.next()).accept((FilterVisitor)this);
                this.out.write(")");
            } else {
                this.out.write("(");
                while (list.hasNext()) {
                    ((AbstractFilter)list.next()).accept((FilterVisitor)this);
                    if (!list.hasNext()) continue;
                    this.out.write(" " + type + " ");
                }
                this.out.write(")");
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
    }

    public void visit(CompareFilter filter) throws RuntimeException {
        log.finer("exporting SQL ComparisonFilter");
        DefaultExpression left = (DefaultExpression)filter.getLeftValue();
        DefaultExpression right = (DefaultExpression)filter.getRightValue();
        log.finer("Filter type id is " + filter.getFilterType());
        log.finer("Filter type text is " + comparisions.get(new Integer(filter.getFilterType())));
        String type = (String)comparisions.get(new Integer(filter.getFilterType()));
        try {
            left.accept((FilterVisitor)this);
            this.out.write(" " + type + " ");
            right.accept((FilterVisitor)this);
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
    }

    public void visit(GeometryFilter filter) {
    }

    public void visit(NullFilter filter) throws RuntimeException {
        log.finer("exporting NullFilter");
        DefaultExpression expr = (DefaultExpression)filter.getNullCheckValue();
        try {
            expr.accept((FilterVisitor)this);
            this.out.write(" IS NULL ");
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
    }

    public void visit(FidFilter filter) {
    }

    public void visit(AttributeExpression expression) throws RuntimeException {
        log.finer("exporting ExpressionAttribute");
        try {
            this.out.write("\"" + expression.getAttributePath() + "\"");
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO problems writing attribute exp", ioe);
        }
    }

    public void visit(Expression expression) {
        log.warning("exporting unknown (default) expression");
    }

    public void visit(LiteralExpression expression) throws RuntimeException {
        log.finer("exporting LiteralExpression");
        try {
            Object literal = expression.getLiteral();
            short type = expression.getType();
            switch (type) {
                case 101: 
                case 102: {
                    this.out.write(literal.toString());
                    break;
                }
                case 103: {
                    this.out.write("'" + literal + "'");
                    break;
                }
                default: {
                    throw new RuntimeException("type: " + type + "not supported");
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO problems writing literal", ioe);
        }
    }

    public void visit(MathExpression expression) throws RuntimeException {
        log.finer("exporting Expression Math");
        String type = (String)expressions.get(new Integer(expression.getType()));
        try {
            ((DefaultExpression)expression.getLeftValue()).accept((FilterVisitor)this);
            this.out.write(" " + type + " ");
            ((DefaultExpression)expression.getRightValue()).accept((FilterVisitor)this);
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO problems writing expression", ioe);
        }
    }

    public void visit(FunctionExpression expression) throws UnsupportedOperationException {
        String message = "Function expression support not yet added.";
        throw new UnsupportedOperationException(message);
    }

    static {
        comparisions.put(new Integer(14), "=");
        comparisions.put(new Integer(23), "!=");
        comparisions.put(new Integer(16), ">");
        comparisions.put(new Integer(18), ">=");
        comparisions.put(new Integer(15), "<");
        comparisions.put(new Integer(17), "<=");
        comparisions.put(new Integer(20), "LIKE");
        comparisions.put(new Integer(21), "IS NULL");
        comparisions.put(new Integer(19), "BETWEEN");
        expressions.put(new Integer(105), "+");
        expressions.put(new Integer(108), "/");
        expressions.put(new Integer(107), "*");
        expressions.put(new Integer(106), "-");
        spatial.put(new Integer(5), "Equals");
        spatial.put(new Integer(6), "Disjoint");
        spatial.put(new Integer(7), "Intersects");
        spatial.put(new Integer(8), "Touches");
        spatial.put(new Integer(9), "Crosses");
        spatial.put(new Integer(10), "Within");
        spatial.put(new Integer(11), "Contains");
        spatial.put(new Integer(12), "Overlaps");
        spatial.put(new Integer(13), "Beyond");
        spatial.put(new Integer(4), "BBOX");
        logical.put(new Integer(2), "AND");
        logical.put(new Integer(1), "OR");
        logical.put(new Integer(3), "NOT");
    }
}

