/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.ResultSetAttributeIO;
import org.geotools.feature.AttributeType;

public class WKTAttributeIO
extends ResultSetAttributeIO {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.jdbc");
    private static GeometryFactory geometryFactory = new GeometryFactory();
    private static WKTReader geometryReader = new WKTReader(geometryFactory);
    private static WKTWriter geometryWriter = new WKTWriter();
    private int columnIndex;

    public WKTAttributeIO(QueryData queryData, AttributeType metadata, int columnIndex) {
        super(new AttributeType[]{metadata}, queryData, columnIndex, columnIndex + 1);
        AttributeType[] attTypes = new AttributeType[]{metadata};
        if (!metadata.isGeometry()) {
            String mesg = "AttributeTypes of a WKTAttributeIO must be geometries, " + metadata + " is not";
            throw new IllegalArgumentException(mesg);
        }
        this.queryData = queryData;
        this.columnIndex = columnIndex;
    }

    public Object read(int i) throws IOException, ArrayIndexOutOfBoundsException {
        if (this.isClosed()) {
            throw new IOException("Close has already been called on this AttributeReader.");
        }
        if (i != 0) {
            throw new ArrayIndexOutOfBoundsException("This Reader only reads one attribute so i should always be 0");
        }
        Geometry retObject = null;
        try {
            QueryData.RowData rd = this.queryData.getRowData(this);
            Object wkt = rd.read(this.columnIndex);
            retObject = wkt == null ? null : geometryReader.read(wkt.toString());
            return retObject;
        }
        catch (SQLException sqle) {
            this.queryData.close(sqle, this);
            throw new DataSourceException("Problem with sql", (Throwable)sqle);
        }
        catch (ParseException pe) {
            throw new DataSourceException("could not parse wkt" + (Object)((Object)pe));
        }
    }

    public void write(int position, Object attribute) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Close has already been called on this AttributeReader.");
        }
        if (position != 0) {
            throw new ArrayIndexOutOfBoundsException("This Reader only reads one attribute so i should always be 0");
        }
        Statement statement = null;
        try {
            Connection conn = this.queryData.getConnection();
            statement = conn.createStatement();
            JDBCDataStore.FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
            StringBuffer sql = new StringBuffer("UPDATE ");
            sql.append(this.formatFieldName(ftInfo.getFeatureTypeName()) + " SET ");
            AttributeType type = this.metaData[0];
            String name = type.getName();
            String newValue = null;
            if (attribute instanceof Geometry) {
                int srid = ftInfo.getSRID(name);
                String geoText = geometryWriter.write((Geometry)attribute);
                newValue = "GeometryFromText('" + geoText + "', " + srid + ")";
            } else {
                newValue = this.formatValue(attribute);
            }
            sql.append(this.formatFieldName(name) + " = " + newValue);
            String fidColName = ftInfo.getFidColumnName();
            QueryData.RowData rd = this.queryData.getRowData(this);
            Object fid = rd.read(1);
            sql.append("WHERE " + fidColName + "=" + fid);
            LOGGER.fine("this sql statement = " + sql);
            statement.executeUpdate(sql.toString());
        }
        catch (SQLException sqle) {
            try {
                String msg = "SQL Exception writing geometry column";
                LOGGER.log(Level.SEVERE, msg, sqle);
                this.queryData.close(sqle, this);
                throw new DataSourceException(msg, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(statement);
                throw throwable;
            }
        }
        JDBCUtils.close(statement);
    }

    protected String formatValue(Object value) {
        String retString = value != null ? "'" + value.toString() + "'" : "null";
        return retString;
    }

    protected String formatFieldName(String fieldName) {
        return "\"" + fieldName + "\"";
    }
}

