/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.FIDReader;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.QueryDataObserver;

public class ResultSetFIDReader
implements FIDReader,
QueryDataObserver {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.jdbc");
    private QueryData queryData;
    private int column;
    private String typeName;
    private boolean isClosed = false;

    public ResultSetFIDReader(QueryData queryData, String typename, int column) {
        this.typeName = typename;
        this.column = column;
        this.queryData = queryData;
        queryData.attachObserver(this);
    }

    public boolean hasNext() throws IOException {
        if (this.isClosed) {
            throw new IOException("This FIDReader has already been closed");
        }
        try {
            boolean hasNext = this.queryData.hasNext(this);
            this.queryData.next(this);
            return hasNext;
        }
        catch (SQLException sqlException) {
            this.queryData.close(sqlException, this);
            String msg = "Error checking for more content";
            LOGGER.log(Level.SEVERE, msg, sqlException);
            throw new DataSourceException(msg, (Throwable)sqlException);
        }
    }

    public String next() throws IOException {
        if (this.isClosed) {
            throw new IOException("This FIDReader has already been closed");
        }
        if (!this.hasNext()) {
            throw new IOException("No more fids, check hasNext() before calling next()");
        }
        try {
            QueryData.RowData rd = this.queryData.getRowData(this);
            String id = rd.read(1).toString();
            return this.typeName + "." + id;
        }
        catch (SQLException sqlException) {
            this.queryData.close(sqlException, this);
            String msg = "Error obtaining more content";
            LOGGER.log(Level.SEVERE, msg, sqlException);
            throw new DataSourceException(msg, (Throwable)sqlException);
        }
    }

    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.queryData != null) {
                this.queryData.close(null, this);
                this.queryData.removeObserver(this);
            }
        }
    }
}

