/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.AbstractAttributeIO;
import org.geotools.data.DataSourceException;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.feature.AttributeType;

public class ResultSetAttributeReader
extends AbstractAttributeIO {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.postgis");
    protected Object[] atts;
    protected ResultSet results;
    protected int startColumn;
    protected int index = 0;
    protected Transaction transaction;
    protected Connection connection;

    protected ResultSetAttributeReader(ResultSet results, AttributeType[] attTypes, int startColumn, Transaction transaction, Connection connection) {
        super(attTypes);
        this.results = results;
        this.atts = new Object[this.metaData.length];
        this.startColumn = startColumn;
        this.transaction = transaction;
        this.connection = connection;
        LOGGER.fine("made new result set reader");
    }

    public boolean hasNext() throws IOException {
        try {
            LOGGER.fine("hasNext called, going to return " + !this.results.isLast());
            return !this.results.isLast();
        }
        catch (SQLException sqlException) {
            JDBCUtils.close(this.connection, this.transaction, sqlException);
            String msg = "Error checking for more content";
            LOGGER.log(Level.SEVERE, msg, sqlException);
            throw new DataSourceException(msg, (Throwable)sqlException);
        }
    }

    public void next() throws IOException {
        LOGGER.fine("next called");
        ++this.index;
    }

    protected Object readColumn(int column) throws IOException {
        try {
            return this.results.getObject(column);
        }
        catch (SQLException sqlException) {
            JDBCUtils.close(this.connection, this.transaction, sqlException);
            String msg = "Problem with SQL";
            LOGGER.log(Level.SEVERE, msg, sqlException);
            throw new DataSourceException(msg, (Throwable)sqlException);
        }
    }

    public Object read(int position) throws IOException {
        if (this.getAttributeCount() <= position) {
            String message = "requested array position " + position + " but " + "there are only " + this.getAttributeCount() + " attributes.";
            throw new ArrayIndexOutOfBoundsException(message);
        }
        int off = position + this.startColumn;
        try {
            Object retObject = null;
            LOGGER.finest("reading position " + position + " getting column " + off + ", atttype is " + this.metaData[position]);
            this.results.absolute(this.index);
            retObject = this.readColumn(off);
            LOGGER.finest(" returning " + retObject);
            return retObject;
        }
        catch (SQLException sqlException) {
            JDBCUtils.close(this.connection, this.transaction, sqlException);
            String msg = "Error reading at " + off;
            LOGGER.log(Level.SEVERE, msg, sqlException);
            throw new DataSourceException(msg, (Throwable)sqlException);
        }
    }

    public void close() throws IOException {
        try {
            this.results.close();
        }
        catch (SQLException sqlException) {
            JDBCUtils.close(this.connection, this.transaction, sqlException);
            String msg = "Error closing results";
            LOGGER.log(Level.SEVERE, msg, sqlException);
            throw new DataSourceException(msg, (Throwable)sqlException);
        }
    }

    public static ResultSetAttributeReader getReader(ResultSet results, AttributeType[] attributes, int startCol, Transaction transaction) throws DataSourceException {
        Connection conn;
        try {
            conn = results.getStatement().getConnection();
        }
        catch (SQLException e) {
            throw new DataSourceException("Could not determine connection", (Throwable)e);
        }
        return new ResultSetAttributeReader(results, attributes, startCol, transaction, conn);
    }

    public static ResultSetAttributeReader getReader(ResultSet results, AttributeType attribute, int startCol, Transaction transaction) throws DataSourceException {
        AttributeType[] atts = new AttributeType[]{attribute};
        return ResultSetAttributeReader.getReader(results, atts, startCol, transaction);
    }
}

