/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.AbstractAttributeIO;
import org.geotools.data.AttributeReader;
import org.geotools.data.AttributeWriter;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.QueryDataObserver;
import org.geotools.feature.AttributeType;

public class ResultSetAttributeIO
extends AbstractAttributeIO
implements QueryDataObserver,
AttributeWriter,
AttributeReader {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.jdbc");
    private boolean isClosed = false;
    private boolean isInsertRow = false;
    protected QueryData queryData;
    private int startColumn;
    private int endColumn;

    public ResultSetAttributeIO(AttributeType[] metadata, QueryData querydata, int startColumn, int endColumn) {
        super(metadata);
        LOGGER.finer("Creating Ranged AttributeReader: " + Arrays.asList(this.metaData) + " range: " + startColumn + "-" + endColumn);
        this.queryData = querydata;
        this.queryData.attachObserver(this);
        this.startColumn = startColumn;
        this.endColumn = endColumn;
    }

    public void close() throws IOException {
        if (!this.isClosed()) {
            this.isClosed = true;
            this.queryData.close(null, this);
            this.queryData.removeObserver(this);
        }
    }

    public boolean hasNext() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Close has already been called on this AttributeReader.");
        }
        try {
            return this.queryData.hasNext(this);
        }
        catch (SQLException sqlException) {
            this.queryData.close(sqlException, this);
            String msg = "SQL Error calling isLast on result set";
            LOGGER.log(Level.SEVERE, msg, sqlException);
            throw new DataSourceException(msg + ":" + sqlException.getMessage(), (Throwable)sqlException);
        }
    }

    public void next() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Close has already been called on this AttributeReader.");
        }
        this.queryData.next(this);
    }

    public Object read(int i) throws IOException, ArrayIndexOutOfBoundsException {
        if (this.isClosed()) {
            throw new IOException("Close has already been called on this AttributeReader.");
        }
        int rsPosition = this.convertIndex(i);
        try {
            QueryData.RowData rd = this.queryData.getRowData(this);
            return rd.read(rsPosition);
        }
        catch (SQLException sqlException) {
            this.queryData.close(sqlException, this);
            String msg = "Error getting value from column position " + rsPosition;
            LOGGER.log(Level.SEVERE, msg, sqlException);
            throw new DataSourceException(msg, (Throwable)sqlException);
        }
    }

    protected int convertIndex(int i) {
        if (i > this.getAttributeCount()) {
            throw new ArrayIndexOutOfBoundsException("read called with " + i + " but there are only " + this.getAttributeCount() + " attributes in the schema.");
        }
        int rsPosition = this.startColumn + i;
        if (rsPosition < this.startColumn || rsPosition >= this.endColumn) {
            throw new ArrayIndexOutOfBoundsException("i must be less than " + (this.endColumn - i - 1));
        }
        return rsPosition;
    }

    public void write(int position, Object attribute) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Close has already been called on this AttributeReader.");
        }
        int rsPosition = this.convertIndex(position);
        try {
            LOGGER.info("Setting " + rsPosition + " to " + attribute);
            QueryData.RowData rd = this.queryData.getRowData(this);
            rd.write(attribute, rsPosition);
        }
        catch (SQLException sqlException) {
            this.queryData.close(sqlException, this);
            String msg = "Error updating object at " + position + "/" + rsPosition + " with " + attribute;
            LOGGER.log(Level.SEVERE, msg, sqlException);
            throw new DataSourceException(msg, (Throwable)sqlException);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

