/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.QueryDataObserver;
import org.geotools.data.jdbc.QueryDataObserverHolder;

public final class QueryData {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.jdbc");
    private Connection conn;
    private JDBCDataStore.FeatureTypeInfo featureTypeInfo;
    private boolean lastNextValue = false;
    private boolean waitForNextCalls = false;
    private List observers = new ArrayList();
    private ResultSet resultSet;
    private Statement statement;
    private Transaction transaction;

    public QueryData(JDBCDataStore.FeatureTypeInfo featureTypeInfo, Connection conn, Statement statement, ResultSet resultSet, Transaction transaction) {
        this.featureTypeInfo = featureTypeInfo;
        this.conn = conn;
        this.resultSet = resultSet;
        this.statement = statement;
        this.transaction = transaction;
    }

    public void attachObserver(QueryDataObserver o) {
        QueryDataObserverHolder holder = new QueryDataObserverHolder(o);
        if (this.observers.contains(holder)) {
            throw new IllegalStateException("A QueryDataObserver can only observe a QueryData once.");
        }
        this.observers.add(holder);
    }

    public IOException cast(String message, SQLException sqlException) {
        if (this.transaction != Transaction.AUTO_COMMIT) {
            try {
                this.transaction.rollback();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new DataSourceException(message + "(transaction rolled back)", (Throwable)sqlException);
        }
        return new DataSourceException(message, (Throwable)sqlException);
    }

    public void close(SQLException sqlException, QueryDataObserver obs) {
        if (obs == null) {
            throw new NullPointerException("Cannot pass null Observer to close");
        }
        QueryDataObserverHolder holder = this.getHolder(obs);
        if (holder == null) {
            throw new IllegalArgumentException("Can not close query data unless you are an attached observer.");
        }
        this.observers.remove(holder);
        if (this.observers.isEmpty()) {
            JDBCUtils.close(this.resultSet);
            JDBCUtils.close(this.statement);
            JDBCUtils.close(this.conn, this.transaction, sqlException);
            this.resultSet = null;
            this.statement = null;
            this.conn = null;
        }
    }

    public void deleteCurrentRow() throws SQLException {
        this.resultSet.deleteRow();
    }

    public Connection getConnection() {
        return this.conn;
    }

    public JDBCDataStore.FeatureTypeInfo getFeatureTypeInfo() {
        return this.featureTypeInfo;
    }

    private QueryDataObserverHolder getHolder(QueryDataObserver o) {
        Iterator iter = this.observers.iterator();
        while (iter.hasNext()) {
            QueryDataObserverHolder holder = (QueryDataObserverHolder)iter.next();
            if (holder.observer != o) continue;
            return holder;
        }
        return null;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    private boolean hasOneObserverCalledNext() {
        Iterator iter = this.observers.iterator();
        while (iter.hasNext()) {
            QueryDataObserverHolder holder = (QueryDataObserverHolder)iter.next();
            if (!holder.nextCalled) continue;
            return true;
        }
        return false;
    }

    private boolean haveAllObserversCalledNext() {
        Iterator iter = this.observers.iterator();
        while (iter.hasNext()) {
            QueryDataObserverHolder holder = (QueryDataObserverHolder)iter.next();
            if (holder.nextCalled) continue;
            return false;
        }
        return true;
    }

    public void next(QueryDataObserver obs) {
        if (obs == null) {
            throw new NullPointerException("Can not pass null Observer to next()");
        }
        QueryDataObserverHolder holder = this.getHolder(obs);
        if (holder == null) {
            throw new IllegalArgumentException("An Observer cannot call next if it is not attached to the QueryData");
        }
        if (!this.waitForNextCalls) {
            throw new IllegalStateException("Can not call next before calling hasNext()");
        }
        if (holder.nextCalled) {
            throw new IllegalStateException("Can not call next again until all other Observers have called next");
        }
        holder.nextCalled = true;
        if (this.haveAllObserversCalledNext()) {
            this.resetObservers();
            this.waitForNextCalls = false;
        }
    }

    public boolean hasNext(QueryDataObserver obs) throws SQLException {
        if (obs == null) {
            throw new NullPointerException("Can not pass null Observer to next()");
        }
        QueryDataObserverHolder holder = this.getHolder(obs);
        if (holder == null) {
            throw new IllegalArgumentException("An Observer cannot call hasNext if it is not attached to the QueryData");
        }
        if (!this.waitForNextCalls) {
            LOGGER.info("Advancing to next row");
            this.lastNextValue = this.resultSet.next();
            this.waitForNextCalls = true;
        }
        return this.lastNextValue;
    }

    public RowData getRowData(QueryDataObserver obs) {
        if (obs == null) {
            throw new NullPointerException("Can not pass null Observer to read()");
        }
        QueryDataObserverHolder holder = this.getHolder(obs);
        if (holder == null) {
            throw new IllegalArgumentException("An Observer cannot call read if it is not attached to the QueryData");
        }
        if (this.hasOneObserverCalledNext()) {
            throw new IllegalStateException("Can not call read while in row index transition state.");
        }
        return new RowData(this.resultSet);
    }

    public void removeObserver(QueryDataObserver o) {
        this.observers.remove(o);
    }

    private void resetObservers() {
        Iterator iter = this.observers.iterator();
        while (iter.hasNext()) {
            QueryDataObserverHolder holder = (QueryDataObserverHolder)iter.next();
            holder.nextCalled = false;
        }
    }

    public void updateRow() throws SQLException {
        this.resultSet.updateRow();
    }

    public void startInsert() throws SQLException {
        this.resultSet.moveToInsertRow();
    }

    public void doInsert() throws SQLException {
        this.resultSet.insertRow();
    }

    public void endInsert() throws SQLException {
        this.resultSet.moveToCurrentRow();
    }

    public static class RowData {
        private ResultSet rs;

        public RowData(ResultSet rs) {
            this.rs = rs;
        }

        public Object read(int position) throws SQLException {
            return this.rs.getObject(position);
        }

        public void write(Object o, int position) throws SQLException {
            if (o == null) {
                this.rs.updateNull(position);
            } else {
                this.rs.updateObject(position, o);
            }
        }

        public void refreshRow() throws SQLException {
            this.rs.refreshRow();
        }
    }
}

