/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.FIDGenerationStrategy;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.QueryData;
import org.geotools.feature.Feature;

public final class MaxIncFIDGenerationStrategy
implements FIDGenerationStrategy {
    private final QueryData queryData;

    public MaxIncFIDGenerationStrategy(QueryData queryData) {
        this.queryData = queryData;
    }

    public Object generateFidFor(Feature f) throws DataSourceException {
        JDBCDataStore.FeatureTypeInfo info = this.queryData.getFeatureTypeInfo();
        try {
            Integer newFid = null;
            Connection conn = this.queryData.getConnection();
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("Select MAX(" + info.getFidColumnName() + ") from " + info.getFeatureTypeName());
            if (rs.next()) {
                try {
                    int maxFid = rs.getInt(1);
                    newFid = new Integer(maxFid + 1);
                }
                catch (SQLException e) {
                    throw new DataSourceException("Error getting max FID from result set.It is likely that the fid column is not");
                }
            } else {
                throw new DataSourceException("Could not get MAX for " + info.getFeatureTypeName() + "." + info.getFidColumnName() + ": No result returned from query");
            }
            return newFid;
        }
        catch (SQLException e) {
            throw new DataSourceException("Error executing MAX query in FID Generation", (Throwable)e);
        }
    }
}

