/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.geotools.data.DataSourceException;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.ConnectionPool;

public class JDBCTransactionState
implements Transaction.State {
    private Connection connection;

    public JDBCTransactionState(ConnectionPool pool) throws IOException {
        try {
            this.connection = pool.getConnection();
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            this.connection = null;
            throw new DataSourceException("Transaction not aquire connection", (Throwable)e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setTransaction(Transaction transaction) {
        if (transaction == null && this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    public void addAuthorization(String AuthID) throws IOException {
    }

    public void commit() throws IOException {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new DataSourceException("Transaction commit", (Throwable)e);
        }
    }

    public void rollback() throws IOException {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new DataSourceException("Transaction rollback", (Throwable)e);
        }
    }
}

