/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;

public class JDBCDataStoreConfig {
    public static final String FID_GEN_INSERT_NULL = "INSERT_NULL";
    public static final String FID_GEN_MANUAL_INC = "MANUAL_INC";
    public static final String DEFAULT_FID_GEN_KEY = "DEFAULT_GEN";
    public static final String DEFAULT_FID_GEN = "INSERT_NULL";
    private final String namespace;
    private final String databaseSchemaName;
    protected final Properties fidColumnOverrideMap = new Properties();
    protected final Properties fidGenerationMap = new Properties();

    public JDBCDataStoreConfig() {
        this(null, null, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    }

    public JDBCDataStoreConfig(String namespace, String databaseSchemaName, Map fidColumnOverrideMap, Map fidGenerationMap) {
        this.namespace = namespace;
        this.databaseSchemaName = databaseSchemaName;
        this.fidColumnOverrideMap.putAll((Map<?, ?>)fidColumnOverrideMap);
        this.fidGenerationMap.putAll((Map<?, ?>)fidGenerationMap);
    }

    public static JDBCDataStoreConfig createWithNameSpaceAndSchemaName(String namespace, String schemaName) {
        return new JDBCDataStoreConfig(namespace, schemaName, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    }

    public static JDBCDataStoreConfig createWithSchemaNameAndFIDGenMap(String schemaName, Map fidGenerationMap) {
        return new JDBCDataStoreConfig(null, schemaName, Collections.EMPTY_MAP, fidGenerationMap);
    }

    public String getDatabaseSchemaName() {
        return this.databaseSchemaName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getFidOverrideColumnFor(String typeName) {
        return (String)this.fidColumnOverrideMap.get(typeName);
    }

    public String getFidGenerationIdFor(String typeName) {
        String strategy = this.fidGenerationMap.getProperty(typeName);
        if (strategy == null && (strategy = this.fidGenerationMap.getProperty(DEFAULT_FID_GEN_KEY)) == null) {
            strategy = "INSERT_NULL";
        }
        return strategy;
    }
}

