/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.AttributeReader;
import org.geotools.data.AttributeWriter;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FIDFeatureReader;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.JoiningAttributeReader;
import org.geotools.data.JoiningAttributeWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.SchemaNotFoundException;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.DefaultSQLBuilder;
import org.geotools.data.jdbc.FIDGenerationStrategy;
import org.geotools.data.jdbc.InsertNullFIDGenerationStrategy;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.JDBCFeatureLocking;
import org.geotools.data.jdbc.JDBCFeatureStore;
import org.geotools.data.jdbc.JDBCTransactionState;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.MaxIncFIDGenerationStrategy;
import org.geotools.data.jdbc.MutableFIDFeature;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.QueryDataObserver;
import org.geotools.data.jdbc.ResultSetAttributeIO;
import org.geotools.data.jdbc.ResultSetFIDReader;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.factory.FactoryConfigurationError;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;
import org.geotools.filter.SQLEncoderException;

public abstract class JDBCDataStore
implements DataStore {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.jdbc");
    protected static final Map TYPE_MAPPINGS = new HashMap();
    public FeatureListenerManager listenerManager = new FeatureListenerManager();
    private LockingManager lockingManager = this.createLockingManager();
    private Map featureTypeMap = null;
    private ConnectionPool connectionPool;
    protected final JDBCDataStoreConfig config;

    public JDBCDataStore(ConnectionPool connectionPool) throws IOException {
        this(connectionPool, null, new HashMap(), "");
    }

    public JDBCDataStore(ConnectionPool connectionPool, String databaseSchemaName) throws IOException {
        this(connectionPool, databaseSchemaName, new HashMap(), databaseSchemaName);
    }

    public JDBCDataStore(ConnectionPool connectionPool, String databaseSchemaName, Map fidGenerationTypes) throws IOException {
        this(connectionPool, databaseSchemaName, fidGenerationTypes, databaseSchemaName);
    }

    public JDBCDataStore(ConnectionPool connectionPool, String databaseSchemaName, Map fidGenerationTypes, String namespace) throws IOException {
        this(connectionPool, new JDBCDataStoreConfig(namespace, databaseSchemaName, new HashMap(), fidGenerationTypes));
    }

    public JDBCDataStore(ConnectionPool connectionPool, JDBCDataStoreConfig config) throws IOException {
        this.connectionPool = connectionPool;
        this.config = config;
        this.featureTypeMap = this.createFeatureTypeMap();
    }

    protected LockingManager createLockingManager() {
        return new InProcessLockingManager();
    }

    public String[] getTypeNames() {
        return this.featureTypeMap.keySet().toArray(new String[this.featureTypeMap.keySet().size()]);
    }

    public FeatureType getSchema(String typeName) throws IOException {
        if (this.featureTypeMap.containsKey(typeName)) {
            FeatureTypeInfo info = this.getFeatureTypeInfo(typeName);
            FeatureTypeInfo holder = (FeatureTypeInfo)this.featureTypeMap.get(typeName);
            return holder.schema;
        }
        throw new SchemaNotFoundException(typeName);
    }

    public void createSchema(FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Table creation not implemented");
    }

    public void updateSchema(String typeName, FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Table modification not supported");
    }

    public FeatureSource getView(Query query) throws IOException, SchemaException {
        String typeName = query.getTypeName();
        FeatureType origionalType = this.getSchema(typeName);
        final FeatureType featureType = DataUtilities.createSubType(origionalType, query.getPropertyNames());
        return new AbstractFeatureSource(){

            public DataStore getDataStore() {
                return JDBCDataStore.this;
            }

            public void addFeatureListener(FeatureListener listener) {
                JDBCDataStore.this.listenerManager.addFeatureListener(this, listener);
            }

            public void removeFeatureListener(FeatureListener listener) {
                JDBCDataStore.this.listenerManager.removeFeatureListener(this, listener);
            }

            public FeatureType getSchema() {
                return featureType;
            }
        };
    }

    public FeatureSource getFeatureSource(String typeName) throws IOException {
        if (this.getLockingManager() != null) {
            return new JDBCFeatureLocking(this, this.getSchema(typeName));
        }
        return new JDBCFeatureStore(this, this.getSchema(typeName));
    }

    /*
     * WARNING - void declaration
     */
    public FeatureReader getFeatureReader(FeatureType requestType, Filter filter, Transaction transaction) throws IOException {
        void var7_7;
        DefaultQuery query;
        String typeName = requestType.getTypeName();
        FeatureType schemaType = this.getSchema(typeName);
        int compare = DataUtilities.compare(requestType, schemaType);
        if (compare == 0) {
            query = new DefaultQuery(typeName, filter);
        } else if (compare == 1) {
            String[] names = this.attributeNames(requestType, filter);
            query = new DefaultQuery(typeName, filter, 100000000, names, "getFeatureReader");
        } else {
            throw new IOException("Type " + typeName + " does match request");
        }
        if (filter == Filter.ALL || filter.equals(Filter.ALL)) {
            return new EmptyFeatureReader(requestType);
        }
        FeatureReader reader = this.getFeatureReader((Query)var7_7, transaction);
        if (compare == 1) {
            reader = new ReTypeFeatureReader(reader, requestType);
        }
        return reader;
    }

    protected String[] attributeNames(FeatureType featureType, Filter filter) throws IOException {
        String typeName = featureType.getTypeName();
        FeatureType origional = this.getSchema(typeName);
        SQLBuilder sqlBuilder = this.getSqlBuilder(typeName);
        if (featureType.getAttributeCount() == origional.getAttributeCount()) {
            return DataUtilities.attributeNames(featureType);
        }
        String[] typeAttributes = DataUtilities.attributeNames(featureType);
        String[] filterAttributes = DataUtilities.attributeNames(sqlBuilder.getPostQueryFilter(filter));
        if (filterAttributes == null || filterAttributes.length == 0) {
            return typeAttributes;
        }
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(typeAttributes));
        set.addAll(Arrays.asList(filterAttributes));
        if (set.size() == typeAttributes.length) {
            return typeAttributes;
        }
        return set.toArray(new String[set.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public FeatureReader getFeatureReader(Query query, Transaction trans) throws IOException {
        FeatureType schema;
        void var9_9;
        String[] propertyNames;
        String typeName = query.getTypeName();
        FeatureType featureType = this.getSchema(typeName);
        SQLBuilder sqlBuilder = this.getSqlBuilder(typeName);
        Filter preFilter = sqlBuilder.getPreQueryFilter(query.getFilter());
        Filter postFilter = sqlBuilder.getPostQueryFilter(query.getFilter());
        String[] requestedNames = this.propertyNames(query);
        if (requestedNames.length == featureType.getAttributeCount()) {
            propertyNames = requestedNames;
        } else if (requestedNames.length < featureType.getAttributeCount()) {
            String[] filterNames = DataUtilities.attributeNames(postFilter);
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(requestedNames));
            set.addAll(Arrays.asList(filterNames));
            propertyNames = set.size() == requestedNames.length ? requestedNames : set.toArray(new String[set.size()]);
        } else {
            throw new DataSourceException(typeName + " does not contain requested proeprties:" + query);
        }
        AttributeType[] attrTypes = null;
        try {
            attrTypes = this.getAttributeTypes(typeName, (String[])var9_9);
        }
        catch (SchemaException schemaException) {
            throw new DataSourceException("Some Attribute Names were specified that do not exist in the FeatureType " + typeName + ". " + "Requested names: " + Arrays.asList(var9_9) + ", " + "FeatureType: " + featureType, (Throwable)schemaException);
        }
        String sqlQuery = this.constructQuery(query, attrTypes);
        QueryData queryData = this.executeQuery(typeName, sqlQuery, trans, 1003, 1007);
        try {
            schema = FeatureTypeFactory.newFeatureType((AttributeType[])attrTypes, (String)typeName, (String)this.getNameSpace());
        }
        catch (FactoryConfigurationError e) {
            throw new DataSourceException("Schema Factory Error when creating schema for FeatureReader", (Throwable)e);
        }
        catch (SchemaException e) {
            throw new DataSourceException("Schema Error when creating schema for FeatureReader", (Throwable)e);
        }
        FeatureReader reader = this.createFeatureReader(schema, postFilter, queryData);
        if (requestedNames.length < ((void)var9_9).length) {
            try {
                FeatureType requestType = DataUtilities.createSubType(schema, requestedNames);
                reader = new ReTypeFeatureReader(reader, requestType);
            }
            catch (SchemaException schemaException) {
                throw new DataSourceException("Could not handle query", (Throwable)schemaException);
            }
        }
        return reader;
    }

    private String constructQuery(Query query, AttributeType[] attrTypes) throws IOException, DataSourceException {
        String sqlQuery;
        String typeName = query.getTypeName();
        SQLBuilder sqlBuilder = this.getSqlBuilder(query.getTypeName());
        Filter preFilter = sqlBuilder.getPreQueryFilter(query.getFilter());
        Filter postFilter = sqlBuilder.getPostQueryFilter(query.getFilter());
        FeatureTypeInfo info = this.getFeatureTypeInfo(typeName);
        boolean useMax = postFilter == null;
        try {
            LOGGER.fine("calling sql builder with filter " + preFilter);
            if (query.getFilter() == Filter.ALL) {
                StringBuffer buf = new StringBuffer("SELECT ");
                sqlBuilder.sqlColumns(buf, info.fidColumnName, attrTypes);
                sqlBuilder.sqlFrom(buf, typeName);
                buf.append(" WHERE '1' = '0'");
                sqlQuery = buf.toString();
            } else {
                sqlQuery = sqlBuilder.buildSQLQuery(typeName, info.fidColumnName, attrTypes, preFilter);
            }
            LOGGER.info("sql is " + sqlQuery);
        }
        catch (SQLEncoderException e) {
            throw new DataSourceException("Error building SQL Query", (Throwable)e);
        }
        return sqlQuery;
    }

    protected FeatureReader createFeatureReader(FeatureType schema, Filter postFilter, QueryData queryData) throws IOException {
        Object fReader;
        AttributeReader[] attrReaders = this.buildAttributeReaders(schema.getAttributeTypes(), queryData);
        JoiningAttributeReader aReader = new JoiningAttributeReader(attrReaders);
        try {
            ResultSetFIDReader fidReader = new ResultSetFIDReader(queryData, schema.getTypeName(), 1);
            fReader = new FIDFeatureReader(aReader, fidReader, schema);
        }
        catch (SchemaException e) {
            throw new DataSourceException("Error creating schema", (Throwable)e);
        }
        if (postFilter != null && postFilter != Filter.ALL) {
            fReader = new FilteringFeatureReader((FeatureReader)fReader, postFilter);
        }
        return fReader;
    }

    protected final AttributeReader[] buildAttributeReaders(AttributeType[] attrTypes, QueryData queryData) throws IOException {
        ArrayList<AttributeReader> attrReaders = new ArrayList<AttributeReader>();
        ArrayList<AttributeType> basicAttrTypes = new ArrayList<AttributeType>();
        for (int i = 0; i < attrTypes.length; ++i) {
            if (attrTypes[i].isGeometry()) {
                if (basicAttrTypes.size() > 0) {
                    AttributeType[] basicTypes = basicAttrTypes.toArray(new AttributeType[basicAttrTypes.size()]);
                    int startIndex = i - basicAttrTypes.size() + 2;
                    attrReaders.add(this.createResultSetReader(basicTypes, queryData, startIndex, i + 2));
                    basicAttrTypes.clear();
                }
                attrReaders.add(this.createGeometryReader(attrTypes[i], queryData, i + 2));
                continue;
            }
            basicAttrTypes.add(attrTypes[i]);
        }
        if (basicAttrTypes.size() > 0) {
            AttributeType[] basicTypes = basicAttrTypes.toArray(new AttributeType[basicAttrTypes.size()]);
            int startIndex = attrTypes.length - basicAttrTypes.size() + 2;
            attrReaders.add(this.createResultSetReader(basicTypes, queryData, startIndex, attrTypes.length + 2));
        }
        return attrReaders.toArray(new AttributeReader[attrReaders.size()]);
    }

    protected final QueryData executeQuery(String tableName, String sqlQuery, Transaction transaction, int resultSetType, int concurrency) throws IOException {
        LOGGER.info("About to execure query: " + sqlQuery);
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(transaction);
            statement = conn.createStatement(resultSetType, concurrency);
            rs = statement.executeQuery(sqlQuery);
            FeatureTypeInfo info = this.getFeatureTypeInfo(tableName);
            QueryData queryData = new QueryData(info, conn, statement, rs, transaction);
            return queryData;
        }
        catch (SQLException e) {
            String msg = "Error Performing SQL query";
            LOGGER.log(Level.SEVERE, msg, e);
            JDBCUtils.close(rs);
            JDBCUtils.close(statement);
            JDBCUtils.close(conn, transaction, e);
            throw new DataSourceException(msg, (Throwable)e);
        }
    }

    public SQLBuilder getSqlBuilder(String typeName) throws IOException {
        return new DefaultSQLBuilder();
    }

    protected AttributeReader createResultSetReader(AttributeType[] attrType, QueryData queryData, int startIndex, int endIndex) {
        return new ResultSetAttributeIO(attrType, queryData, startIndex, endIndex);
    }

    protected AttributeWriter createResultSetWriter(AttributeType[] attrType, QueryData queryData, int startIndex, int endIndex) {
        return new ResultSetAttributeIO(attrType, queryData, startIndex, endIndex);
    }

    protected abstract AttributeReader createGeometryReader(AttributeType var1, QueryData var2, int var3) throws IOException;

    protected abstract AttributeWriter createGeometryWriter(AttributeType var1, QueryData var2, int var3) throws IOException;

    private final Map createFeatureTypeMap() throws IOException {
        HashMap<String, Object> hashMap;
        int TABLE_NAME_COL = 3;
        Connection conn = null;
        try {
            HashMap<String, Object> featureTypeMap = new HashMap<String, Object>();
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            DatabaseMetaData meta = conn.getMetaData();
            String[] tableType = new String[]{"TABLE"};
            ResultSet tables = meta.getTables(null, this.config.getDatabaseSchemaName(), "%", tableType);
            while (tables.next()) {
                String tableName = tables.getString(3);
                if (!this.allowTable(tableName)) continue;
                featureTypeMap.put(tableName, null);
            }
            hashMap = featureTypeMap;
        }
        catch (SQLException sqlException) {
            try {
                JDBCUtils.close(conn, Transaction.AUTO_COMMIT, sqlException);
                conn = null;
                String message = "Error querying database for list of tables:" + sqlException.getMessage();
                throw new DataSourceException(message, (Throwable)sqlException);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
                throw throwable;
            }
        }
        JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
        return hashMap;
    }

    protected final Connection getConnection(Transaction transaction) throws IOException {
        if (transaction != Transaction.AUTO_COMMIT) {
            JDBCTransactionState state = (JDBCTransactionState)transaction.getState((Object)this.connectionPool);
            if (state == null) {
                state = new JDBCTransactionState(this.connectionPool);
                transaction.putState((Object)this.connectionPool, (Transaction.State)state);
            }
            return state.getConnection();
        }
        try {
            return this.connectionPool.getConnection();
        }
        catch (SQLException sqle) {
            throw new DataSourceException("Could not get connection", (Throwable)sqle);
        }
    }

    protected boolean allowTable(String tablename) {
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FeatureType buildSchema(String typeName, String fidColumn) throws IOException {
        FeatureType featureType;
        int NAME_COLUMN = 4;
        int TYPE_NAME = 6;
        Connection conn = null;
        ResultSet tableInfo = null;
        try {
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            DatabaseMetaData dbMetaData = conn.getMetaData();
            tableInfo = dbMetaData.getColumns(null, null, typeName, "%");
            ArrayList<AttributeType> attributeTypes = new ArrayList<AttributeType>();
            while (tableInfo.next()) {
                try {
                    if (fidColumn != null && fidColumn.equals(tableInfo.getString(4))) continue;
                    AttributeType attributeType = this.buildAttributeType(tableInfo);
                    if (attributeType != null) {
                        attributeTypes.add(attributeType);
                        continue;
                    }
                    LOGGER.finest("Unknown SQL Type: " + tableInfo.getString(6));
                }
                catch (DataSourceException dse) {
                    String msg = "Error building attribute type. The column will be ignored";
                    LOGGER.log(Level.WARNING, msg, dse);
                }
            }
            AttributeType[] types = attributeTypes.toArray(new AttributeType[0]);
            featureType = FeatureTypeFactory.newFeatureType((AttributeType[])types, (String)typeName, (String)this.getNameSpace());
        }
        catch (SQLException sqlException) {
            try {
                JDBCUtils.close(conn, Transaction.AUTO_COMMIT, sqlException);
                conn = null;
                throw new DataSourceException("SQL Error building FeatureType for " + typeName, (Throwable)sqlException);
                catch (FactoryConfigurationError e) {
                    throw new DataSourceException("Error creating FeatureType " + typeName, (Throwable)e);
                }
                catch (SchemaException e) {
                    throw new DataSourceException("Error creating FeatureType for " + typeName, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.close(tableInfo);
                JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
                throw throwable;
            }
        }
        JDBCUtils.close(tableInfo);
        JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
        return featureType;
    }

    protected AttributeType buildAttributeType(ResultSet rs) throws SQLException, DataSourceException {
        int COLUMN_NAME = 4;
        int DATA_TYPE = 5;
        String columnName = rs.getString(4);
        int dataType = rs.getInt(5);
        Class type = (Class)TYPE_MAPPINGS.get(new Integer(dataType));
        if (type == null) {
            return null;
        }
        return AttributeTypeFactory.newAttributeType((String)columnName, (Class)type);
    }

    protected int determineSRID(String tableName, String geometryColumnName) throws IOException {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String determineFidColumnName(String typeName) throws IOException {
        Connection conn;
        ResultSet rs;
        String fidColumnName;
        block4: {
            int NAME_COLUMN = 4;
            fidColumnName = null;
            rs = null;
            conn = null;
            try {
                conn = this.getConnection(Transaction.AUTO_COMMIT);
                DatabaseMetaData dbMetadata = conn.getMetaData();
                rs = dbMetadata.getPrimaryKeys(null, null, typeName);
                if (!rs.next()) break block4;
                fidColumnName = rs.getString(4);
            }
            catch (SQLException sqlException) {
                try {
                    JDBCUtils.close(conn, Transaction.AUTO_COMMIT, sqlException);
                    conn = null;
                    LOGGER.warning("Could not find the primary key - using the default");
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(rs);
                    JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
                    throw throwable;
                }
                JDBCUtils.close(rs);
                JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
            }
        }
        JDBCUtils.close(rs);
        JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
        return fidColumnName;
    }

    public String getNameSpace() {
        return this.config.getNamespace();
    }

    protected final FeatureTypeInfo getFeatureTypeInfo(String featureTypeName) throws IOException {
        FeatureTypeInfo info = (FeatureTypeInfo)this.featureTypeMap.get(featureTypeName);
        if (info == null) {
            String fidColumnName = this.determineFidColumnName(featureTypeName);
            FeatureType schema = this.buildSchema(featureTypeName, fidColumnName);
            info = new FeatureTypeInfo(featureTypeName, fidColumnName, schema);
            AttributeType[] types = schema.getAttributeTypes();
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].isGeometry()) continue;
                int srid = this.determineSRID(featureTypeName, types[i].getName());
                info.putSRID(types[i].getName(), srid);
            }
            this.featureTypeMap.put(featureTypeName, info);
        }
        return info;
    }

    public FeatureWriter getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return this.getFeatureWriter(typeName, Filter.NONE, transaction);
    }

    public FeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        FeatureWriter writer = this.getFeatureWriter(typeName, Filter.ALL, transaction);
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }

    public FeatureWriter getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        String sqlQuery;
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.NONE?");
        }
        if (transaction == null) {
            throw new NullPointerException("getFeatureReader requires Transaction: did you mean Transaction.AUTO_COMMIT");
        }
        FeatureType featureType = this.getSchema(typeName);
        FeatureTypeInfo info = this.getFeatureTypeInfo(typeName);
        LOGGER.fine("getting feature writer for " + typeName + ": " + info);
        SQLBuilder sqlBuilder = this.getSqlBuilder(typeName);
        Filter preFilter = sqlBuilder.getPreQueryFilter(filter);
        Filter postFilter = sqlBuilder.getPostQueryFilter(filter);
        DefaultQuery query = new DefaultQuery(typeName, filter);
        try {
            sqlQuery = this.constructQuery((Query)query, this.getAttributeTypes(typeName, this.propertyNames((Query)query)));
        }
        catch (SchemaException e) {
            throw new DataSourceException("Some Attribute Names were specified that do not exist in the FeatureType " + typeName + ". " + "Requested names: " + Arrays.asList(query.getPropertyNames()) + ", " + "FeatureType: " + featureType, (Throwable)e);
        }
        QueryData queryData = this.executeQuery(typeName, sqlQuery, transaction, 1005, 1008);
        FeatureReader reader = this.createFeatureReader(info.getSchema(), postFilter, queryData);
        AttributeWriter[] writers = this.buildAttributeWriters(info.getSchema().getAttributeTypes(), queryData);
        JoiningAttributeWriter joinedW = new JoiningAttributeWriter(writers);
        FeatureWriter writer = this.createFeatureWriter(reader, joinedW, queryData);
        if (this.getLockingManager() != null && this.getLockingManager() instanceof InProcessLockingManager) {
            InProcessLockingManager inProcess = (InProcessLockingManager)this.getLockingManager();
            writer = inProcess.checkedWriter(writer, transaction);
        }
        if (postFilter != null && postFilter != Filter.NONE) {
            writer = new FilteringFeatureWriter(writer, postFilter);
        }
        return writer;
    }

    protected JDBCFeatureWriter createFeatureWriter(FeatureReader fReader, AttributeWriter writer, QueryData queryData) throws IOException {
        LOGGER.fine("returning jdbc feature writer");
        return new JDBCFeatureWriter(fReader, writer, queryData);
    }

    protected final AttributeWriter[] buildAttributeWriters(AttributeType[] attrTypes, QueryData queryData) throws IOException {
        ArrayList<AttributeWriter> attrWriters = new ArrayList<AttributeWriter>();
        ArrayList<AttributeType> basicAttrTypes = new ArrayList<AttributeType>();
        for (int i = 0; i < attrTypes.length; ++i) {
            if (attrTypes[i].isGeometry()) {
                if (basicAttrTypes.size() > 0) {
                    AttributeType[] basicTypes = basicAttrTypes.toArray(new AttributeType[basicAttrTypes.size()]);
                    int startIndex = i - basicAttrTypes.size() + 2;
                    attrWriters.add(this.createResultSetWriter(basicTypes, queryData, startIndex, i + 2));
                    basicAttrTypes.clear();
                }
                attrWriters.add(this.createGeometryWriter(attrTypes[i], queryData, i + 2));
                continue;
            }
            basicAttrTypes.add(attrTypes[i]);
        }
        if (basicAttrTypes.size() > 0) {
            AttributeType[] basicTypes = basicAttrTypes.toArray(new AttributeType[basicAttrTypes.size()]);
            int startIndex = attrTypes.length - basicAttrTypes.size() + 2;
            attrWriters.add(this.createResultSetWriter(basicTypes, queryData, startIndex, attrTypes.length + 2));
        }
        return attrWriters.toArray(new AttributeWriter[attrWriters.size()]);
    }

    private String[] propertyNames(Query query) throws IOException {
        String[] names = query.getPropertyNames();
        if (names == null || query.retrieveAllProperties()) {
            String typeName = query.getTypeName();
            FeatureType schema = this.getSchema(typeName);
            names = new String[schema.getAttributeCount()];
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                names[i] = schema.getAttributeType(i).getName();
            }
        }
        return names;
    }

    protected final AttributeType[] getAttributeTypes(String typeName, String[] propertyNames) throws IOException, SchemaException {
        FeatureType schema = this.getSchema(typeName);
        AttributeType[] types = new AttributeType[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            types[i] = schema.getAttributeType(propertyNames[i]);
            if (types[i] != null) continue;
            throw new SchemaException(typeName + " does not contain requested " + propertyNames[i] + " attribute");
        }
        return types;
    }

    public LockingManager getLockingManager() {
        return this.lockingManager;
    }

    protected FIDGenerationStrategy getFIDGenerationStrategyFor(QueryData queryData) throws DataSourceException {
        FeatureTypeInfo info = queryData.getFeatureTypeInfo();
        String strategy = this.config.getFidGenerationIdFor(info.featureTypeName);
        LOGGER.info("FID Generation strategy for " + info.featureTypeName + " is " + strategy);
        if (strategy == null || "INSERT_NULL".equalsIgnoreCase(strategy.toString())) {
            return new InsertNullFIDGenerationStrategy();
        }
        if ("MANUAL_INC".equalsIgnoreCase(strategy.toString())) {
            return new MaxIncFIDGenerationStrategy(queryData);
        }
        throw new DataSourceException("No valid fid generation strategy defined: " + strategy);
    }

    static {
        TYPE_MAPPINGS.put(new Integer(12), String.class);
        TYPE_MAPPINGS.put(new Integer(1), String.class);
        TYPE_MAPPINGS.put(new Integer(-1), String.class);
        TYPE_MAPPINGS.put(new Integer(-7), Boolean.class);
        TYPE_MAPPINGS.put(new Integer(16), Boolean.class);
        TYPE_MAPPINGS.put(new Integer(-6), Short.class);
        TYPE_MAPPINGS.put(new Integer(5), Short.class);
        TYPE_MAPPINGS.put(new Integer(4), Integer.class);
        TYPE_MAPPINGS.put(new Integer(-5), Long.class);
        TYPE_MAPPINGS.put(new Integer(7), Float.class);
        TYPE_MAPPINGS.put(new Integer(6), Double.class);
        TYPE_MAPPINGS.put(new Integer(8), Double.class);
        TYPE_MAPPINGS.put(new Integer(3), BigDecimal.class);
        TYPE_MAPPINGS.put(new Integer(2), BigDecimal.class);
        TYPE_MAPPINGS.put(new Integer(91), Date.class);
        TYPE_MAPPINGS.put(new Integer(92), Time.class);
        TYPE_MAPPINGS.put(new Integer(93), Timestamp.class);
    }

    protected class JDBCFeatureWriter
    implements FeatureWriter,
    QueryDataObserver {
        protected QueryData queryData;
        protected AttributeWriter writer;
        protected Feature live = null;
        protected Feature current = null;
        protected FeatureReader fReader;

        public JDBCFeatureWriter(FeatureReader fReader, AttributeWriter writer, QueryData queryData) throws IOException {
            this.queryData = queryData;
            queryData.attachObserver(this);
            this.fReader = fReader;
            this.writer = writer;
        }

        public FeatureType getFeatureType() {
            return this.queryData.getFeatureTypeInfo().getSchema();
        }

        public Feature next() throws IOException {
            if (this.queryData == null) {
                throw new IOException("FeatureWriter has been closed");
            }
            FeatureType featureType = this.queryData.getFeatureTypeInfo().getSchema();
            if (this.hasNext()) {
                try {
                    this.queryData.next(this);
                    this.writer.next();
                    this.live = this.fReader.next();
                    this.current = featureType.duplicate(this.live);
                    LOGGER.finer("Calling next on writer");
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Unable to edit " + this.live.getID() + " of " + featureType.getTypeName(), (Throwable)e);
                }
            }
            this.live = null;
            if (this.fReader != null) {
                this.fReader.close();
                this.fReader = null;
            }
            try {
                Feature temp = DataUtilities.template(featureType);
                this.current = new MutableFIDFeature((DefaultFeatureType)featureType, temp.getAttributes(new Object[temp.getNumberOfAttributes()]), null);
                this.queryData.startInsert();
                this.queryData.next(this);
                this.writer.next();
            }
            catch (IllegalAttributeException e) {
                throw new DataSourceException("Unable to add additional Features of " + featureType.getTypeName(), (Throwable)e);
            }
            catch (SQLException e) {
                throw new DataSourceException("Unable to move to insert row.", (Throwable)e);
            }
            return this.current;
        }

        public void remove() throws IOException {
            if (this.queryData == null) {
                throw new IOException("FeatureWriter has been closed");
            }
            if (this.current == null) {
                throw new IOException("No feature available to remove");
            }
            if (this.live != null) {
                LOGGER.fine("Removing " + this.live);
                Envelope bounds = this.live.getBounds();
                this.live = null;
                this.current = null;
                try {
                    this.queryData.deleteCurrentRow();
                    JDBCDataStore.this.listenerManager.fireFeaturesRemoved(this.queryData.getFeatureTypeInfo().getFeatureTypeName(), this.queryData.getTransaction(), bounds);
                }
                catch (SQLException sqle) {
                    String message = "problem deleting row";
                    if (this.queryData.getTransaction() != Transaction.AUTO_COMMIT) {
                        this.queryData.getTransaction().rollback();
                        message = message + "(transaction canceled)";
                    }
                    throw new DataSourceException(message, (Throwable)sqle);
                }
            } else {
                this.current = null;
            }
        }

        public void write() throws IOException {
            if (this.queryData == null) {
                throw new IOException("FeatureWriter has been closed");
            }
            if (this.current == null) {
                throw new IOException("No feature available to write");
            }
            LOGGER.fine("write called, live is " + this.live + " and cur is " + this.current);
            if (this.live != null) {
                if (this.live.equals(this.current)) {
                    this.live = null;
                    this.current = null;
                } else {
                    this.doUpdate(this.live, this.current);
                    try {
                        this.queryData.updateRow();
                    }
                    catch (SQLException sqlException) {
                        this.queryData.close(sqlException, this);
                        throw new DataSourceException("Error updating row", (Throwable)sqlException);
                    }
                    Envelope bounds = new Envelope();
                    bounds.expandToInclude(this.live.getBounds());
                    bounds.expandToInclude(this.current.getBounds());
                    JDBCDataStore.this.listenerManager.fireFeaturesChanged(this.queryData.getFeatureTypeInfo().getFeatureTypeName(), this.queryData.getTransaction(), bounds);
                    this.live = null;
                    this.current = null;
                }
            } else {
                LOGGER.fine("doing insert in jdbc featurewriter");
                try {
                    this.doInsert((Feature)((MutableFIDFeature)this.current));
                }
                catch (SQLException e) {
                    throw new DataSourceException("Row adding failed.", (Throwable)e);
                }
                JDBCDataStore.this.listenerManager.fireFeaturesAdded(this.queryData.getFeatureTypeInfo().getFeatureTypeName(), this.queryData.getTransaction(), this.current.getBounds());
                this.current = null;
            }
        }

        protected void doInsert(Feature current) throws IOException, SQLException {
            try {
                this.queryData.startInsert();
                FIDGenerationStrategy fidGen = JDBCDataStore.this.getFIDGenerationStrategyFor(this.queryData);
                QueryData.RowData rd = this.queryData.getRowData(this);
                rd.write(fidGen.generateFidFor(current), 1);
                this.doUpdate(DataUtilities.template(current.getFeatureType()), current);
                this.queryData.doInsert();
                MutableFIDFeature mutable = (MutableFIDFeature)current;
                mutable.setID(rd.read(1).toString());
            }
            catch (IllegalAttributeException e) {
                throw new DataSourceException("Unable to do insert", (Throwable)e);
            }
        }

        private void doUpdate(Feature live, Feature current) throws IOException {
            try {
                for (int i = 0; i < current.getNumberOfAttributes(); ++i) {
                    Object curAtt = current.getAttribute(i);
                    Object liveAtt = live.getAttribute(i);
                    if (live != null && DataUtilities.attributesEqual(curAtt, liveAtt)) continue;
                    LOGGER.info("modifying att# " + i + " to " + curAtt);
                    this.writer.write(i, curAtt);
                }
            }
            catch (IOException ioe) {
                String message = "problem modifying row";
                if (this.queryData.getTransaction() != Transaction.AUTO_COMMIT) {
                    this.queryData.getTransaction().rollback();
                    message = message + "(transaction canceled)";
                }
                throw ioe;
            }
        }

        public boolean hasNext() throws IOException {
            if (this.queryData == null) {
                throw new IOException("FeatureWriter has been closed");
            }
            return this.fReader != null && this.fReader.hasNext() && this.writer.hasNext();
        }

        public void close() throws IOException {
            if (this.queryData == null) {
                throw new IOException("FeatureWriter has been closed");
            }
            if (this.fReader != null) {
                this.fReader.close();
            }
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
            if (this.queryData != null) {
                this.queryData.close(null, this);
                this.queryData = null;
            }
            this.current = null;
            this.live = null;
        }
    }

    public static class FeatureTypeInfo {
        private String featureTypeName;
        private String fidColumnName;
        private FeatureType schema;
        private Map sridMap = new HashMap();

        public FeatureTypeInfo(String typeName, String fidColumn, FeatureType schema) {
            this.featureTypeName = typeName;
            this.fidColumnName = fidColumn;
            this.schema = schema;
        }

        public String getFeatureTypeName() {
            return this.featureTypeName;
        }

        public String getFidColumnName() {
            return this.fidColumnName;
        }

        public FeatureType getSchema() {
            return this.schema;
        }

        public int getSRID(String geometryAttributeName) {
            int srid = -1;
            Integer integer = (Integer)this.sridMap.get(geometryAttributeName);
            if (integer != null) {
                srid = integer;
            }
            return srid;
        }

        public Map getSRIDs() {
            return Collections.unmodifiableMap(this.sridMap);
        }

        void putSRID(String geometryColumnName, int srid) {
            this.sridMap.put(geometryColumnName, new Integer(srid));
        }

        public String toString() {
            return "typeName = " + this.featureTypeName + ", fidCol = " + this.fidColumnName + ", schema: " + this.schema + "srids: " + this.sridMap;
        }
    }
}

