/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.geotools.data.AbstractDataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceMetaData;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.feature.FeatureCollection;

public abstract class JDBCDataSource
extends AbstractDataSource {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data");
    private ConnectionPool connectionPool;
    protected Connection transConn;

    public JDBCDataSource(ConnectionPool pool) {
        this.connectionPool = pool;
    }

    public void commit() throws DataSourceException {
        try {
            LOGGER.fine("commit called");
            this.getTransactionConnection().commit();
            this.closeTransactionConnection();
        }
        catch (SQLException sqle) {
            String message = "problem committing";
            LOGGER.info(message + ": " + sqle.getMessage());
            throw new DataSourceException(message, (Throwable)sqle);
        }
    }

    protected DataSourceMetaData createMetaData() {
        AbstractDataSource.MetaDataSupport jdbcMeta = new AbstractDataSource.MetaDataSupport();
        jdbcMeta.setSupportsRollbacks(true);
        return jdbcMeta;
    }

    public void setFeatures(FeatureCollection features) throws DataSourceException {
        if (!this.getMetaData().supportsSetFeatures()) {
            throw new UnsupportedOperationException("Does not support setFeatures");
        }
        boolean originalAutoCommit = this.getAutoCommit();
        this.setAutoCommit(false);
        this.removeFeatures(null);
        this.addFeatures(features);
        this.commit();
        this.setAutoCommit(originalAutoCommit);
    }

    public void rollback() throws DataSourceException {
        try {
            this.getTransactionConnection().rollback();
            this.closeTransactionConnection();
        }
        catch (SQLException sqle) {
            String message = "problem with rollbacks";
            LOGGER.info(message + ": " + sqle.getMessage());
            throw new DataSourceException(message, (Throwable)sqle);
        }
    }

    public boolean getAutoCommit() throws DataSourceException {
        try {
            if (this.transConn == null) {
                return true;
            }
            return this.getTransactionConnection().getAutoCommit();
        }
        catch (SQLException sqle) {
            String message = "problem setting auto commit";
            LOGGER.info(message + ": " + sqle.getMessage());
            throw new DataSourceException(message, (Throwable)sqle);
        }
    }

    protected Connection getConnection() throws DataSourceException {
        try {
            return this.connectionPool.getConnection();
        }
        catch (SQLException sqle) {
            throw new DataSourceException("could not get connection", (Throwable)sqle);
        }
    }

    protected void finalizeTransactionMethod(boolean previousAutoCommit, boolean fail) throws DataSourceException {
        LOGGER.finer("finalizing transaction, prevac: " + previousAutoCommit + ", fail is " + fail);
        if (fail) {
            this.rollback();
        } else if (previousAutoCommit) {
            LOGGER.finer("committing in finalize");
            this.commit();
        }
        this.setAutoCommit(previousAutoCommit);
        this.closeTransactionConnection();
    }

    protected Connection getTransactionConnection() throws DataSourceException, SQLException {
        if (this.transConn == null) {
            this.transConn = this.getConnection();
        }
        return this.transConn;
    }

    protected void closeTransactionConnection() {
        try {
            if (this.transConn != null && this.transConn.getAutoCommit()) {
                LOGGER.finer("Closing Transaction Connection");
                this.transConn.close();
                this.transConn = null;
            } else {
                LOGGER.finer("Transaction connection not open or set to manual commit");
            }
        }
        catch (SQLException e) {
            LOGGER.warning("Error closing transaction connection: " + e);
        }
    }
}

