/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.feature.AttributeType;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.SQLUnpacker;

public class DefaultSQLBuilder
implements SQLBuilder {
    protected SQLEncoder encoder;

    public DefaultSQLBuilder() {
        this(new SQLEncoder());
    }

    public DefaultSQLBuilder(SQLEncoder encoder) {
        this.encoder = encoder;
    }

    public String buildSQLQuery(String typeName, String fidColumnName, AttributeType[] attrTypes, Filter filter) throws SQLEncoderException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT ");
        this.sqlColumns(sqlBuffer, fidColumnName, attrTypes);
        this.sqlFrom(sqlBuffer, typeName);
        this.sqlWhere(sqlBuffer, filter);
        String sqlStmt = sqlBuffer.toString();
        return sqlStmt;
    }

    public Filter getPostQueryFilter(Filter filter) {
        FilterCapabilities cap = this.encoder.getCapabilities();
        SQLUnpacker unpacker = new SQLUnpacker(cap);
        unpacker.unPackAND(filter);
        return unpacker.getUnSupported();
    }

    public Filter getPreQueryFilter(Filter filter) {
        SQLUnpacker unpacker = new SQLUnpacker(this.encoder.getCapabilities());
        unpacker.unPackAND(filter);
        return unpacker.getSupported();
    }

    public void sqlColumns(StringBuffer sql, String fidColumnName, AttributeType[] attributes) {
        if (fidColumnName != null) {
            sql.append(fidColumnName);
        }
        for (int i = 0; i < attributes.length; ++i) {
            sql.append(", ");
            sql.append(attributes[i].getName());
        }
    }

    public void sqlFrom(StringBuffer sql, String typeName) {
        sql.append(" FROM ");
        sql.append(typeName);
    }

    public void sqlWhere(StringBuffer sql, Filter preFilter) throws SQLEncoderException {
        if (preFilter != null && preFilter != Filter.NONE) {
            String where = this.encoder.encode(preFilter);
            sql.append(" ");
            sql.append(where);
        }
    }
}

