/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.opengis.sc.CoordinateReferenceSystem;

public class ForceCoordinateSystemFeatureReader
implements FeatureReader {
    private FeatureReader reader;
    private FeatureType schema;
    private CoordinateReferenceSystem coordianteSystem;

    public ForceCoordinateSystemFeatureReader(FeatureReader reader, CoordinateReferenceSystem cs) throws SchemaException {
        if (cs == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        FeatureType type = reader.getFeatureType();
        CoordinateReferenceSystem origional = type.getDefaultGeometry().getCoordinateSystem();
        if (cs.equals(origional)) {
            throw new IllegalArgumentException("CoordinateSystem " + cs + " already used (check before using wrapper)");
        }
        this.coordianteSystem = cs;
        FeatureTypeFactory typeFactory = FeatureTypeFactory.newInstance((String)type.getTypeName());
        typeFactory.setNamespace(type.getNamespace());
        typeFactory.setName(type.getTypeName());
        GeometryAttributeType defaultGeometryType = null;
        for (int i = 0; i < type.getAttributeCount(); ++i) {
            AttributeType attributeType = type.getAttributeType(i);
            if (attributeType instanceof GeometryAttributeType) {
                GeometryAttributeType geometryType = (GeometryAttributeType)attributeType;
                GeometryAttributeType forcedGeometry = (GeometryAttributeType)AttributeTypeFactory.newAttributeType((String)geometryType.getName(), geometryType.getClass(), (boolean)geometryType.isNillable(), (int)geometryType.getFieldLength(), (Object)geometryType.createDefaultValue(), (Object)cs);
                if (defaultGeometryType == null || geometryType == type.getDefaultGeometry()) {
                    defaultGeometryType = forcedGeometry;
                }
                typeFactory.addType((AttributeType)forcedGeometry);
                continue;
            }
            typeFactory.addType(attributeType);
        }
        typeFactory.setDefaultGeometry(defaultGeometryType);
        this.schema = typeFactory.getFeatureType();
        this.reader = reader;
    }

    public FeatureType getFeatureType() {
        if (this.schema == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.schema;
    }

    public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        Feature next = this.reader.next();
        return this.schema.create(next.getAttributes(null), next.getID());
    }

    public boolean hasNext() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.reader.hasNext();
    }

    public void close() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        this.reader.close();
        this.reader = null;
        this.schema = null;
    }
}

