/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;

public class DiffFeatureReader
implements FeatureReader {
    FeatureReader reader;
    Map diff;
    Feature next = null;

    public DiffFeatureReader(FeatureReader reader, Map diff) {
        this.reader = reader;
        this.diff = new HashMap(diff);
    }

    public FeatureType getFeatureType() {
        return this.reader.getFeatureType();
    }

    public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.hasNext()) {
            Feature live = this.next;
            this.next = null;
            return live;
        }
        throw new NoSuchElementException("No more Feature exists");
    }

    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        if (this.reader != null && this.reader.hasNext()) {
            Feature peek;
            try {
                peek = this.reader.next();
            }
            catch (NoSuchElementException e) {
                throw new DataSourceException("Could not aquire the next Feature", (Throwable)e);
            }
            catch (IllegalAttributeException e) {
                throw new DataSourceException("Could not aquire the next Feature", (Throwable)e);
            }
            String fid = peek.getID();
            if (this.diff.containsKey(fid)) {
                Feature changed = (Feature)this.diff.remove(fid);
                if (changed == null) {
                    return this.hasNext();
                }
                this.next = changed;
                return true;
            }
            this.next = peek;
            return true;
        }
        if (this.diff != null && !this.diff.isEmpty()) {
            Iterator i = this.diff.values().iterator();
            this.next = (Feature)i.next();
            i.remove();
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.diff != null) {
            this.diff.clear();
            this.diff = null;
        }
    }
}

