/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.geotools.data.Catalog;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreMetaData;
import org.geotools.data.DefaultNamespaceMetaData;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureTypeMetaData;
import org.geotools.data.LockingManager;
import org.geotools.data.NamespaceMetaData;
import org.geotools.data.Transaction;

public class DefaultCatalog
implements Catalog {
    protected String defaultPrefix = null;
    protected Map namespaces = new HashMap();
    protected Set datastores = new HashSet();

    public Set getPrefixes() {
        return Collections.unmodifiableSet(this.namespaces.keySet());
    }

    public synchronized NamespaceMetaData getNamespaceMetaData(String prefix) {
        if (this.namespaces.containsKey(prefix)) {
            return (NamespaceMetaData)this.namespaces.get(prefix);
        }
        NamespaceMetaData namespace = this.createNamespaceMetaData(prefix);
        this.namespaces.put(prefix, namespace);
        return namespace;
    }

    protected NamespaceMetaData createNamespaceMetaData(String prefix) {
        return new DefaultNamespaceMetaData(prefix);
    }

    public boolean lockExists(String lockID) {
        if (lockID == null) {
            return false;
        }
        Iterator i = this.datastores.iterator();
        while (i.hasNext()) {
            DataStore store = (DataStore)i.next();
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.exists(lockID)) continue;
            return true;
        }
        return false;
    }

    public boolean lockRefresh(String lockID, Transaction transaction) throws IOException {
        if (lockID == null) {
            throw new IllegalArgumentException("lockID required");
        }
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            throw new IllegalArgumentException("Tansaction required (with authorization for " + lockID + ")");
        }
        boolean refresh = false;
        Iterator i = this.datastores.iterator();
        while (i.hasNext()) {
            DataStore store = (DataStore)i.next();
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.release(lockID, transaction)) continue;
            refresh = true;
        }
        return refresh;
    }

    public boolean lockRelease(String lockID, Transaction transaction) throws IOException {
        if (lockID == null) {
            throw new IllegalArgumentException("lockID required");
        }
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            throw new IllegalArgumentException("Tansaction required (with authorization for " + lockID + ")");
        }
        boolean release = false;
        Iterator i = this.datastores.iterator();
        while (i.hasNext()) {
            DataStore store = (DataStore)i.next();
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.release(lockID, transaction)) continue;
            release = true;
        }
        return release;
    }

    public String getDefaultPrefix() {
        return this.defaultPrefix;
    }

    public void setDefaultPrefix(String prefix) {
        this.defaultPrefix = prefix;
    }

    public void registerDataStore(DataStore dataStore) throws IOException {
        if (this.datastores.contains(dataStore)) {
            throw new IOException("DataStore already registered with Catalog");
        }
    }

    public Set getDataStores(String namespace) {
        return Collections.unmodifiableSet(this.datastores);
    }

    public FeatureSource getFeatureSource(String prefix, String typeName) throws IOException {
        NamespaceMetaData namespace = this.getNamespaceMetaData(prefix);
        FeatureTypeMetaData featureType = namespace.getFeatureTypeMetaData(typeName);
        DataStoreMetaData dataStore = featureType.getDataStoreMetaData();
        return dataStore.getDataStore().getFeatureSource(typeName);
    }

    public Set getDataStores() {
        return Collections.unmodifiableSet(this.datastores);
    }
}

