/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.factory.FactoryFinder;

public final class DataStoreFinder {
    private DataStoreFinder() {
    }

    public static DataStore getDataStore(Map params) throws IOException {
        Iterator ps = DataStoreFinder.getAvailableDataStores();
        while (ps.hasNext()) {
            DataStoreFactorySpi fac = (DataStoreFactorySpi)ps.next();
            if (!fac.canProcess(params)) continue;
            return fac.createDataStore(params);
        }
        return null;
    }

    public static Iterator getAvailableDataStores() {
        return FactoryFinder.factories((Class)DataStoreFactorySpi.class);
    }
}

