/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mapinfo;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.geotools.data.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceFactorySpi;
import org.geotools.data.mapinfo.MapInfoDataSource;

public class MapInfoDataSourceFactory
implements DataSourceFactorySpi {
    public boolean canProcess(Map params) {
        if (!params.containsKey("url")) {
            return false;
        }
        String url = (String)params.get("url");
        return url.toUpperCase().endsWith("MIF");
    }

    public DataSource createDataSource(Map params) throws DataSourceException {
        if (!this.canProcess(params)) {
            return null;
        }
        String location = (String)params.get("url");
        try {
            MapInfoDataSource ds = new MapInfoDataSource(new URL(location));
            return ds;
        }
        catch (MalformedURLException mue) {
            throw new DataSourceException("Unable to attatch datasource to " + location, (Throwable)mue);
        }
    }

    public String getDescription() {
        return "MapInfo(tm) Interchange files MIF/MID (*.mif)";
    }
}

