/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mapinfo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.AbstractDataSource;
import org.geotools.data.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.Query;
import org.geotools.data.mapinfo.MifStyles;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleFactory;

public class MapInfoDataSource
extends AbstractDataSource
implements DataSource {
    private static Logger LOGGER = Logger.getLogger("org.geotools.mifmid");
    public static final String TYPE_NONE = "none";
    public static final String TYPE_POINT = "point";
    public static final String TYPE_LINE = "line";
    public static final String TYPE_PLINE = "pline";
    public static final String TYPE_REGION = "region";
    public static final String TYPE_ARC = "arc";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_RECT = "rectangle";
    public static final String TYPE_ROUNDRECT = "rounded rectangle";
    public static final String TYPE_ELLIPSE = "ellipse";
    public static final String CLAUSE_SYMBOL = "SYMBOL";
    public static final String CLAUSE_PEN = "PEN";
    public static final String CLAUSE_SMOOTH = "SMOOTH";
    public static final String CLAUSE_CENTER = "CENTER";
    public static final String CLAUSE_BRUSH = "BRUSH";
    public static final String CLAUSE_VERSION = "Version";
    public static final String CLAUSE_CHARSET = "Charset";
    public static final String CLAUSE_DELIMETER = "DELIMITER";
    public static final String CLAUSE_UNIQUE = "UNIQUE";
    public static final String CLAUSE_INDEX = "INDEX";
    public static final String CLAUSE_COLUMNS = "COLUMNS";
    String hVersion;
    String hCharset;
    String hDelimeter = "\t";
    ArrayList hColumnsNames;
    ArrayList hColumnsTypes;
    Vector hUnique;
    Vector hIndex;
    private String line;
    private Vector pointFeatures;
    private Vector lineFeatures;
    private Vector polygonFeatures;
    private FeatureType pointFeatureType;
    private FeatureType lineFeatureType;
    private FeatureType polygonFeatureType;
    private FeatureType pointType;
    private FeatureType lineType;
    private FeatureType polygonType;
    private GeometryFactory geomFactory;
    private static final FilterFactory filterFactory = FilterFactory.createFilterFactory();
    private static final StyleFactory styleFactory = StyleFactory.createStyleFactory();
    private Stroke stroke = styleFactory.getDefaultStroke();
    private Fill fill = styleFactory.getDefaultFill();
    private String filename;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public MapInfoDataSource(URL url) throws MalformedURLException {
        this.filename = URLDecoder.decode(url.getFile());
        this.geomFactory = new GeometryFactory();
    }

    protected Vector readMifMid() throws DataSourceException {
        if (this.filename == null) {
            throw new DataSourceException("Invalid filename passed to readMifMid");
        }
        String mifFile = this.setExtension(this.filename, "MIF");
        String midFile = this.setExtension(this.filename, "MID");
        try {
            File mid;
            File mif = new File(mifFile);
            if (!(mif.exists() || (mif = new File(mifFile = this.setExtension(this.filename, "mif"))).exists() || (mif = new File(mifFile = this.setExtension(this.filename.toLowerCase(), "mif"))).exists())) {
                mifFile = this.setExtension(this.filename.toUpperCase(), "MIF");
                mif = new File(mifFile);
            }
            if (!((mid = new File(midFile)).exists() || (mid = new File(midFile = this.setExtension(this.filename, "mid"))).exists() || (mid = new File(midFile = this.setExtension(this.filename.toLowerCase(), "mid"))).exists())) {
                midFile = this.setExtension(this.filename.toUpperCase(), "MID");
                mid = new File(midFile);
            }
            Vector features = this.readMifMid(new BufferedReader(new FileReader(mif)), new BufferedReader(new FileReader(mid)));
            return features;
        }
        catch (FileNotFoundException fnfexp) {
            throw new DataSourceException("FileNotFoundException trying to read mif file : ", (Throwable)fnfexp);
        }
    }

    private String setExtension(String filename, String ext) {
        if (ext.indexOf(".") == -1) {
            ext = "." + ext;
        }
        if (filename.lastIndexOf(".") == -1) {
            return filename + ext;
        }
        return filename.substring(0, filename.lastIndexOf(".")) + ext;
    }

    private void setUpFactories() throws DataSourceException {
        ArrayList<AttributeType> colAttribs = new ArrayList<AttributeType>();
        for (int i = 0; i < this.hColumnsNames.size(); ++i) {
            String type = ((String)this.hColumnsTypes.get(i)).toLowerCase();
            Class typeClass = null;
            if (type.equals("float") || type.startsWith("decimal")) {
                typeClass = class$java$lang$Double == null ? MapInfoDataSource.class$("java.lang.Double") : class$java$lang$Double;
                this.hColumnsTypes.set(i, "Double");
            } else if (type.startsWith("char")) {
                typeClass = class$java$lang$String == null ? MapInfoDataSource.class$("java.lang.String") : class$java$lang$String;
                this.hColumnsTypes.set(i, "String");
            } else if (type.equals("integer") || type.equals("smallint")) {
                typeClass = class$java$lang$Integer == null ? MapInfoDataSource.class$("java.lang.Integer") : class$java$lang$Integer;
                this.hColumnsTypes.set(i, "Integer");
            } else {
                LOGGER.fine("unknown type in mif/mid read " + type + " storing as String");
                typeClass = class$java$lang$String == null ? MapInfoDataSource.class$("java.lang.String") : class$java$lang$String;
                this.hColumnsTypes.set(i, "String");
            }
            colAttribs.add(AttributeTypeFactory.newAttributeType((String)((String)this.hColumnsNames.get(i)), (Class)typeClass));
        }
        colAttribs.add(0, AttributeTypeFactory.newAttributeType((String)TYPE_POINT, (Class)Geometry.class));
        try {
            this.pointType = FeatureTypeFactory.newFeatureType((AttributeType[])colAttribs.toArray(new AttributeType[0]), (String)(this.filename.toString() + "_point"));
        }
        catch (SchemaException schexp) {
            throw new DataSourceException("SchemaException setting up point factory : ", (Throwable)schexp);
        }
        colAttribs.set(0, AttributeTypeFactory.newAttributeType((String)TYPE_LINE, (Class)Geometry.class));
        try {
            this.lineType = FeatureTypeFactory.newFeatureType((AttributeType[])colAttribs.toArray(new AttributeType[0]), (String)(this.filename.toString() + "_line"));
        }
        catch (SchemaException schexp) {
            throw new DataSourceException("SchemaException setting up line factory : ", (Throwable)schexp);
        }
        colAttribs.set(0, AttributeTypeFactory.newAttributeType((String)"polygon", (Class)Geometry.class));
        try {
            this.polygonType = FeatureTypeFactory.newFeatureType((AttributeType[])colAttribs.toArray(new AttributeType[0]), (String)(this.filename.toString() + "_poly"));
        }
        catch (SchemaException schexp) {
            throw new DataSourceException("SchemaException setting up polygon factory : ", (Throwable)schexp);
        }
    }

    private Vector readMifMid(BufferedReader mifReader, BufferedReader midReader) throws DataSourceException {
        Feature feature;
        this.readMifHeader(mifReader);
        this.setUpFactories();
        Vector<Feature> features = new Vector<Feature>();
        try {
            this.line = this.readMifLine(mifReader);
        }
        catch (IOException ioexp) {
            throw new DataSourceException("No data at start of file", (Throwable)ioexp);
        }
        while ((feature = this.readObject(mifReader, midReader)) != null) {
            features.addElement(feature);
        }
        return features;
    }

    private void readMifHeader(BufferedReader mifReader) throws DataSourceException {
        try {
            while (this.readMifLine(mifReader) != null && !this.line.trim().equalsIgnoreCase("DATA")) {
                StringTokenizer st;
                if (this.clause(this.line).equalsIgnoreCase(CLAUSE_VERSION)) {
                    this.hVersion = this.line.trim().substring(this.line.trim().indexOf(32)).trim();
                    LOGGER.info("version [" + this.hVersion + "]");
                }
                if (this.clause(this.line).equalsIgnoreCase(CLAUSE_CHARSET)) {
                    this.hCharset = this.remainder(this.line).replace('\"', ' ').trim();
                    LOGGER.info("Charset [" + this.hCharset + "]");
                }
                if (this.clause(this.line).equalsIgnoreCase(CLAUSE_DELIMETER)) {
                    this.hDelimeter = this.line.replace('\"', ' ').trim().substring(this.line.trim().indexOf(32)).trim();
                    if (this.hDelimeter.length() == 0) {
                        this.hDelimeter = " ";
                    }
                    LOGGER.info("delimiter [" + this.hDelimeter + "]");
                }
                if (this.clause(this.line).equalsIgnoreCase(CLAUSE_UNIQUE)) {
                    st = new StringTokenizer(this.line.trim().substring(this.line.trim().indexOf(32)), ",");
                    this.hUnique = new Vector();
                    LOGGER.info("Unique cols ");
                    while (st.hasMoreTokens()) {
                        String uniq = st.nextToken();
                        LOGGER.info("\t" + uniq);
                        this.hUnique.addElement(uniq);
                    }
                }
                if (this.clause(this.line).equalsIgnoreCase(CLAUSE_INDEX)) {
                    st = new StringTokenizer(this.line.trim().substring(this.line.trim().indexOf(32)), ",");
                    this.hIndex = new Vector();
                    LOGGER.info("Indexes");
                    while (st.hasMoreTokens()) {
                        String index = st.nextToken();
                        LOGGER.info("\t" + index);
                        this.hIndex.addElement(index);
                    }
                }
                if (!this.clause(this.line).equalsIgnoreCase(CLAUSE_COLUMNS)) continue;
                int cols = 0;
                try {
                    cols = Integer.parseInt(this.remainder(this.line));
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Cols " + cols);
                    }
                }
                catch (NumberFormatException nfexp) {
                    LOGGER.severe("bad number of colums " + nfexp);
                }
                this.hColumnsNames = new ArrayList();
                this.hColumnsTypes = new ArrayList();
                for (int i = 0; i < cols; ++i) {
                    this.line = this.readMifLine(mifReader);
                    String name = this.clause(this.line);
                    String value = this.remainder(this.line);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("column name " + name + " value " + value);
                    }
                    this.hColumnsNames.add(name);
                    this.hColumnsTypes.add(value);
                }
            }
        }
        catch (IOException ioexp) {
            throw new DataSourceException("IOException reading MIF header : " + ioexp.getMessage());
        }
    }

    private String clause(String line) {
        return this.clause(line, ' ');
    }

    private String clause(String line, char delimiter) {
        int index = (line = line.trim()).indexOf(delimiter);
        if (index == -1) {
            return line;
        }
        return line.substring(0, index).trim();
    }

    private String remainder(String line) {
        return this.remainder(line, ' ');
    }

    private String remainder(String line, char delimiter) {
        int index = (line = line.trim()).lastIndexOf(delimiter);
        if (index == -1) {
            return "";
        }
        return line.substring(index).trim();
    }

    private String readMifLine(BufferedReader reader) throws IOException, DataSourceException {
        do {
            this.line = reader.readLine();
            if (this.line == null) {
                return null;
            }
            if (!this.isShadingClause(this.line)) continue;
            LOGGER.finest("going to process shading");
            this.processShading(this.line);
            this.line = " ";
        } while (this.line.trim().length() == 0);
        this.line = this.line.trim();
        return this.line;
    }

    private Feature readObject(BufferedReader mifReader, BufferedReader midReader) throws DataSourceException {
        Feature feature = null;
        if (this.line == null) {
            return null;
        }
        int index = this.line.indexOf(32);
        if (index == -1) {
            index = this.line.length();
        }
        if (this.line.substring(0, index).equalsIgnoreCase(TYPE_POINT)) {
            LOGGER.finest("Reading POINT");
            feature = this.readPointObject(mifReader, midReader);
        } else if (this.line.substring(0, index).equalsIgnoreCase(TYPE_LINE)) {
            LOGGER.finest("Reading LINE");
            feature = this.readLineObject(mifReader, midReader);
        } else if (this.line.substring(0, index).equalsIgnoreCase(TYPE_PLINE)) {
            LOGGER.finest("Reading PLINE");
            feature = this.readPLineObject(mifReader, midReader);
        } else if (this.line.substring(0, index).equalsIgnoreCase(TYPE_REGION)) {
            LOGGER.finest("Reading REGION");
            feature = this.readRegionObject(mifReader, midReader);
        } else {
            LOGGER.finest(this.line + " unknown object in mif reader");
        }
        return feature;
    }

    private Feature readPointObject(BufferedReader mifReader, BufferedReader midReader) throws DataSourceException {
        Feature feature = null;
        StringTokenizer st = new StringTokenizer(this.line.substring(this.line.indexOf(" ")), ",");
        try {
            double x = Double.parseDouble(st.nextToken());
            double y = Double.parseDouble(st.nextToken());
            Point pointGeom = this.geomFactory.createPoint(new Coordinate(x, y));
            this.readMifLine(mifReader);
            ArrayList midValues = this.readMid(midReader);
            feature = this.buildFeature(this.pointType, (Geometry)pointGeom, midValues);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Built point feature : " + x + " " + y);
            }
        }
        catch (NumberFormatException nfexp) {
            throw new DataSourceException("Exception reading Point data from MIF file : ", (Throwable)nfexp);
        }
        catch (IOException ioexp) {
            throw new DataSourceException("IOException reading point data : ", (Throwable)ioexp);
        }
        return feature;
    }

    private Feature readLineObject(BufferedReader mifReader, BufferedReader midReader) throws DataSourceException {
        Feature feature = null;
        StringTokenizer st = new StringTokenizer(this.line.substring(this.line.indexOf(" ")), ",");
        try {
            double x1 = Double.parseDouble(st.nextToken());
            double y1 = Double.parseDouble(st.nextToken());
            double x2 = Double.parseDouble(st.nextToken());
            double y2 = Double.parseDouble(st.nextToken());
            Coordinate[] cPoints = new Coordinate[]{new Coordinate(x1, y1), new Coordinate(x2, y2)};
            LineString lineGeom = this.geomFactory.createLineString(cPoints);
            this.readMifLine(mifReader);
            ArrayList midValues = this.readMid(midReader);
            feature = this.buildFeature(this.lineType, (Geometry)lineGeom, midValues);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Built line feature : " + x1 + " " + y1 + " - " + x2 + " " + y2);
            }
        }
        catch (NumberFormatException nfexp) {
            throw new DataSourceException("Exception reading Point data from MIF file : " + nfexp.getMessage());
        }
        catch (IOException ioexp) {
            throw new DataSourceException("IOException reading point data : " + ioexp.getMessage());
        }
        return feature;
    }

    private Feature readPLineObject(BufferedReader mifReader, BufferedReader midReader) throws DataSourceException {
        Feature feature = null;
        StringTokenizer st = new StringTokenizer(this.line.substring(this.line.indexOf(" ")));
        try {
            int numsections = 1;
            if (st.hasMoreTokens() && st.nextToken().trim().equalsIgnoreCase("MULTIPLE")) {
                numsections = Integer.parseInt(st.nextToken());
            }
            Vector<Coordinate> coords = new Vector<Coordinate>();
            for (int i = 0; i < numsections; ++i) {
                int numpoints = Integer.parseInt(this.readMifLine(mifReader));
                for (int p = 0; p < numpoints; ++p) {
                    StringTokenizer pst = new StringTokenizer(this.readMifLine(mifReader));
                    double x = Double.parseDouble(pst.nextToken());
                    double y = Double.parseDouble(pst.nextToken());
                    coords.addElement(new Coordinate(x, y));
                }
            }
            LineString plineGeom = this.geomFactory.createLineString(coords.toArray(new Coordinate[coords.size()]));
            this.readMifLine(mifReader);
            ArrayList midValues = this.readMid(midReader);
            feature = this.buildFeature(this.lineType, (Geometry)plineGeom, midValues);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Read polyline (" + coords.size() + ")");
            }
        }
        catch (NumberFormatException nfexp) {
            throw new DataSourceException("Exception reading Point data from MIF file : " + nfexp.getMessage());
        }
        catch (IOException ioexp) {
            throw new DataSourceException("IOException reading point data : " + ioexp.getMessage());
        }
        return feature;
    }

    private Feature readRegionObject(BufferedReader mifReader, BufferedReader midReader) throws DataSourceException {
        Feature feature = null;
        StringTokenizer st = new StringTokenizer(this.line.substring(this.line.indexOf(" ")));
        try {
            int numpolygons = Integer.parseInt(st.nextToken());
            Vector<Polygon> polys = new Vector<Polygon>();
            for (int i = 0; i < numpolygons; ++i) {
                Vector<Coordinate> coords = new Vector<Coordinate>();
                int numpoints = Integer.parseInt(this.readMifLine(mifReader));
                for (int p = 0; p < numpoints; ++p) {
                    StringTokenizer pst = new StringTokenizer(this.readMifLine(mifReader));
                    double x = Double.parseDouble(pst.nextToken());
                    double y = Double.parseDouble(pst.nextToken());
                    coords.addElement(new Coordinate(x, y));
                }
                coords.addElement(new Coordinate(((Coordinate)coords.get((int)0)).x, ((Coordinate)coords.get((int)0)).y));
                try {
                    Polygon pol = this.geomFactory.createPolygon(this.geomFactory.createLinearRing(coords.toArray(new Coordinate[coords.size()])), null);
                    polys.addElement(pol);
                    continue;
                }
                catch (TopologyException topexp) {
                    throw new DataSourceException("TopologyException reading Region polygon : ", (Throwable)topexp);
                }
            }
            MultiPolygon polyGeom = this.geomFactory.createMultiPolygon(polys.toArray(new Polygon[polys.size()]));
            this.readMifLine(mifReader);
            ArrayList midValues = this.readMid(midReader);
            feature = this.buildFeature(this.polygonType, (Geometry)polyGeom, midValues);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Read Region (" + polys.size() + ")");
            }
        }
        catch (NumberFormatException nfexp) {
            throw new DataSourceException("Exception reading Point data from MIF file : ", (Throwable)nfexp);
        }
        catch (IOException ioexp) {
            throw new DataSourceException("IOException reading point data : ", (Throwable)ioexp);
        }
        return feature;
    }

    private Feature buildFeature(FeatureType featureType, Geometry geom, ArrayList attribs) throws DataSourceException {
        int numAttribs = featureType.getAttributeTypes().length;
        attribs.add(0, geom);
        if (numAttribs != attribs.size()) {
            LOGGER.severe("wrong number of attributes passed to buildFeature");
            throw new DataSourceException("wrong number of attributes passed to buildFeature.\nexpected " + numAttribs + " got " + attribs.size());
        }
        try {
            return featureType.create(attribs.toArray());
        }
        catch (IllegalAttributeException ifexp) {
            throw new DataSourceException("IllegalAttributeException creating feature : ", (Throwable)ifexp);
        }
    }

    private ArrayList readMid(BufferedReader midReader) throws DataSourceException {
        ArrayList midValues = new ArrayList();
        if (midReader == null) {
            return new ArrayList();
        }
        String midLine = "";
        try {
            midLine = midReader.readLine();
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Read MID " + midLine);
            }
        }
        catch (IOException ioexp) {
            throw new DataSourceException("IOException reading MID file");
        }
        int col = 0;
        List tokens = this.parse(midLine, this.hDelimeter.charAt(0));
        Iterator values = tokens.iterator();
        while (values.hasNext()) {
            String value = (String)values.next();
            String type = (String)this.hColumnsTypes.get(col++);
            this.addAttribute(type, value.trim(), midValues);
        }
        return midValues;
    }

    private void addAttribute(String type, String token, ArrayList midValues) {
        if (type.equals("String")) {
            midValues.add(token);
        } else if (type.equals("Double")) {
            try {
                midValues.add(new Double(token));
            }
            catch (NumberFormatException nfe) {
                LOGGER.info("Bad double " + token);
                midValues.add(new Double(0.0));
            }
        } else if (type.equals("Integer")) {
            try {
                midValues.add(new Integer(token));
            }
            catch (NumberFormatException nfe) {
                LOGGER.info("Bad Integer value " + token);
                midValues.add(new Integer(0));
            }
        } else {
            LOGGER.info("Unknown type " + type);
        }
    }

    private void processShading(String line) throws DataSourceException {
        int pattern;
        if (line == null) {
            return;
        }
        String shadeType = line.toLowerCase();
        String name = this.clause(shadeType, '(');
        String settings = this.remainder(shadeType, '(');
        StringTokenizer st = new StringTokenizer(settings, "(),");
        String[] values = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            values[i] = st.nextToken();
            ++i;
        }
        if (name.equals("pen")) {
            try {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("setting new pen " + settings);
                    LOGGER.finest("width " + values[0]);
                }
                this.stroke.setWidth((Expression)filterFactory.createLiteralExpression((Object)new Integer(values[0])));
                pattern = Integer.parseInt(values[1]);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("pattern = " + pattern);
                }
                this.stroke.setDashArray(MifStyles.getPenPattern(new Integer(pattern)));
                int color = Integer.parseInt(values[2]);
                String rgb = Integer.toHexString(color);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("color " + color + " -> " + rgb);
                }
                this.stroke.setColor((Expression)filterFactory.createLiteralExpression(rgb));
            }
            catch (Exception nfe) {
                throw new DataSourceException("Error setting up pen", (Throwable)nfe);
            }
            return;
        }
        if (name.equals("brush")) {
            LOGGER.finest("setting new brush " + settings);
            pattern = Integer.parseInt(values[0]);
            LOGGER.finest("pattern = " + pattern);
            Graphic dg = styleFactory.getDefaultGraphic();
            dg.addExternalGraphic(MifStyles.getBrushPattern(new Integer(pattern)));
            this.stroke.setGraphicFill(dg);
            int color = Integer.parseInt(values[1]);
            String rgb = Integer.toHexString(color);
            LOGGER.finest("color " + color + " -> " + rgb);
            this.fill.setColor((Expression)filterFactory.createLiteralExpression(rgb));
            if (values.length == 3) {
                color = Integer.parseInt(values[2]);
                rgb = Integer.toHexString(color);
                LOGGER.finest("color " + color + " -> " + rgb);
                this.fill.setBackgroundColor((Expression)filterFactory.createLiteralExpression(rgb));
            } else {
                this.fill.setBackgroundColor((Expression)null);
            }
        } else if (name.equals("center")) {
            LOGGER.finest("setting center " + settings);
        } else if (name.equals("smooth")) {
            LOGGER.finest("setting smooth on");
        } else if (name.equals("symbol")) {
            LOGGER.finest("setting symbol " + settings);
            Object symbol = null;
            ExternalGraphic eg = null;
            if (values.length != 3 && values.length != 6) {
                if (values.length == 4) {
                    eg = styleFactory.createExternalGraphic("CustSymb/" + values[0], "image/unknown");
                } else {
                    LOGGER.info("unexpected symbol style " + name + settings);
                }
            }
        } else if (name.equals("font")) {
            LOGGER.finest("setting font " + settings);
        } else {
            LOGGER.finest("unknown styling directive " + name + settings);
        }
    }

    private boolean isShadingClause(String line) {
        boolean ret = (line = line.toUpperCase()).indexOf(CLAUSE_PEN) != -1 || line.indexOf(CLAUSE_SYMBOL) != -1 || line.indexOf(CLAUSE_SMOOTH) != -1 || line.indexOf(CLAUSE_CENTER) != -1 || line.indexOf(CLAUSE_BRUSH) != -1;
        return ret;
    }

    public void getFeatures(FeatureCollection collection, Query query) throws DataSourceException {
        Filter filter = null;
        if (query != null) {
            filter = query.getFilter();
        }
        Vector features = this.readMifMid();
        for (int i = 0; i < features.size(); ++i) {
            if (filter != null && !filter.contains((Feature)features.elementAt(i))) continue;
            collection.add(features.elementAt(i));
        }
    }

    public FeatureType getSchema() {
        return DefaultFeatureType.EMPTY;
    }

    private List parse(String s, char delim) {
        ArrayList<String> tokens = new ArrayList<String>();
        int index = 0;
        boolean inQuotes = false;
        boolean gettingToken = true;
        StringBuffer token = new StringBuffer("");
        while (true) {
            if (s.length() <= index) {
                if (token.toString().equals("")) break;
                tokens.add(token.toString());
                break;
            }
            char c = s.charAt(index);
            ++index;
            if (c == '\"') {
                if (inQuotes) {
                    tokens.add(token.toString());
                    token.setLength(0);
                }
                gettingToken = inQuotes = !inQuotes;
                continue;
            }
            if (c == delim || c == '\u0000') {
                if (inQuotes) {
                    token.append(c);
                    continue;
                }
                if (!gettingToken || token.length() <= 0) continue;
                tokens.add(token.toString());
                token.setLength(0);
                gettingToken = false;
                continue;
            }
            token.append(c);
            gettingToken = true;
        }
        return tokens;
    }
}

