/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.SQLEncoder;

public class SQLEncoderOracle
extends SQLEncoder {
    private static FilterCapabilities capabilities = null;
    private static final Logger LOGGER = Logger.getLogger("org.geotools.filter.SQLEncoderOracle");
    private static final Map SDO_RELATE_MASK_MAP = new HashMap();
    private static final String SQL_WILD_MULTI = "%";
    private static final String SQL_WILD_SINGLE = "_";
    private static final String TOLERANCE = "0.001";
    private String escapedWildcardMulti = "\\.\\*";
    private String escapedWildcardSingle = "\\.\\?";
    private Map srids;
    private String fidColumn;
    private String currentGeomColumnName = null;
    boolean inGeomFilter = false;

    public SQLEncoderOracle(String fidColumn, int defaultSRID) {
        this(fidColumn, new HashMap());
        this.srids.put(null, new Integer(defaultSRID));
    }

    public SQLEncoderOracle(String fidColumn, Map srids) {
        this.srids = srids;
        this.fidColumn = fidColumn;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities capabilities = super.createFilterCapabilities();
        capabilities.addType((short)4);
        capabilities.addType((short)11);
        capabilities.addType((short)9);
        capabilities.addType((short)5);
        capabilities.addType((short)7);
        capabilities.addType((short)12);
        capabilities.addType((short)8);
        capabilities.addType((short)10);
        capabilities.addType((short)22);
        capabilities.addType((short)20);
        return capabilities;
    }

    private void doBBoxFilter(GeometryFilter geomFilter) throws IOException {
        Expression left = geomFilter.getLeftGeometry();
        Expression right = geomFilter.getRightGeometry();
        if (left != null && right != null) {
            this.inGeomFilter = true;
            this.out.write("SDO_GEOM.RELATE(");
            left.accept((FilterVisitor)this);
            this.out.write(",'disjoint',");
            right.accept((FilterVisitor)this);
            this.out.write(",0.001) = 'FALSE' ");
            this.inGeomFilter = false;
        } else {
            LOGGER.warning("Invalid filter. Cannot have a Geometry filter with only one expression.");
        }
    }

    private void doSdoRelate(GeometryFilter geomFilter) throws IOException {
        String mask = (String)SDO_RELATE_MASK_MAP.get(new Short(geomFilter.getFilterType()));
        Expression left = geomFilter.getLeftGeometry();
        Expression right = geomFilter.getRightGeometry();
        if (left != null && right != null && mask != null) {
            this.inGeomFilter = true;
            this.out.write("SDO_RELATE(");
            left.accept((FilterVisitor)this);
            this.out.write(",");
            right.accept((FilterVisitor)this);
            this.out.write(",'mask=" + mask + " querytype=WINDOW') = 'TRUE' ");
            this.inGeomFilter = false;
        } else {
            LOGGER.warning("Invalid filter. Cannot have a Geometry filter with only one expression.");
        }
    }

    private String toSDOGeom(Geometry geometry, int srid) {
        if (Point.class.isAssignableFrom(geometry.getClass())) {
            return this.toSDOGeom((Point)geometry, srid);
        }
        if (LineString.class.isAssignableFrom(geometry.getClass())) {
            return this.toSDOGeom((LineString)geometry, srid);
        }
        if (Polygon.class.isAssignableFrom(geometry.getClass())) {
            return this.toSDOGeom((Polygon)geometry, srid);
        }
        LOGGER.warning("Got a literal geometry that I can't handle: " + geometry.getClass().getName());
        return "";
    }

    private String toSDOGeom(LineString line, int srid) {
        if (line.getDimension() > 2) {
            LOGGER.warning("" + line.getDimension() + " dimensioned geometry provided." + " This encoder only supports 2D geometries. The query will be constructed as" + " a 2D query.");
        }
        StringBuffer buffer = new StringBuffer("MDSYS.SDO_GEOMETRY(");
        buffer.append(line.getDimension());
        buffer.append("002,");
        if (srid > 0) {
            LOGGER.fine("Using layer SRID: " + srid);
            buffer.append(srid);
        } else {
            LOGGER.fine("Using NULL SRID: ");
            buffer.append("NULL");
        }
        buffer.append(",NULL,MDSYS.SDO_ELEM_INFO_ARRAY(1,2,1),");
        buffer.append("MDSYS.SDO_ORDINATE_ARRAY(");
        Coordinate[] coordinates = line.getCoordinates();
        for (int i = 0; i < coordinates.length; ++i) {
            buffer.append(coordinates[i].x);
            buffer.append(",");
            buffer.append(coordinates[i].y);
            if (i == coordinates.length - 1) continue;
            buffer.append(",");
        }
        buffer.append("))");
        return buffer.toString();
    }

    private String toSDOGeom(Point point, int srid) {
        if (point.getDimension() > 2) {
            LOGGER.warning("" + point.getDimension() + " dimensioned geometry provided." + " This encoder only supports 2D geometries. The query will be constructed as" + " a 2D query.");
        }
        StringBuffer buffer = new StringBuffer("MDSYS.SDO_GEOMETRY(");
        buffer.append(point.getDimension());
        buffer.append("001,");
        if (srid > 0) {
            LOGGER.fine("Using layer SRID: " + srid);
            buffer.append(srid);
        } else {
            LOGGER.fine("Using NULL SRID: ");
            buffer.append("NULL");
        }
        buffer.append(",MDSYS.SDO_POINT_TYPE(");
        buffer.append(point.getX());
        buffer.append(",");
        buffer.append(point.getY());
        buffer.append(",NULL),NULL,NULL)");
        return buffer.toString();
    }

    private String toSDOGeom(Polygon polygon, int srid) {
        StringBuffer buffer = new StringBuffer();
        if (polygon.getDimension() > 2) {
            LOGGER.warning("" + polygon.getDimension() + " dimensioned geometry provided." + " This encoder only supports 2D geometries. The query will be constructed as" + " a 2D query.");
        }
        if (polygon.getExteriorRing() != null) {
            buffer.append("MDSYS.SDO_GEOMETRY(");
            buffer.append(polygon.getDimension());
            buffer.append("003,");
            if (srid > 0) {
                LOGGER.fine("Using layer SRID: " + srid);
                buffer.append(srid);
            } else {
                LOGGER.fine("Using NULL SRID: ");
                buffer.append("NULL");
            }
            buffer.append(",NULL,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),");
            buffer.append("MDSYS.SDO_ORDINATE_ARRAY(");
            Coordinate[] coordinates = polygon.getExteriorRing().getCoordinates();
            for (int i = 0; i < coordinates.length; ++i) {
                buffer.append(coordinates[i].x);
                buffer.append(",");
                buffer.append(coordinates[i].y);
                if (i == coordinates.length - 1) continue;
                buffer.append(",");
            }
            buffer.append("))");
        } else {
            LOGGER.warning("No Exterior ring on polygon.  This encode only supports Polygons with exterior rings.");
        }
        if (polygon.getNumInteriorRing() > 0) {
            LOGGER.warning("Polygon contains Interior Rings. These rings will not be included in the query.");
        }
        return buffer.toString();
    }

    public void visit(GeometryFilter geomFilter) {
        LOGGER.finer("Visiting a Geometry filter");
        try {
            if (geomFilter.getFilterType() == 4) {
                this.doBBoxFilter(geomFilter);
            } else if (SDO_RELATE_MASK_MAP.get(new Short(geomFilter.getFilterType())) != null) {
                this.doSdoRelate(geomFilter);
            } else {
                LOGGER.warning("Unknown filter type: " + geomFilter.getFilterType());
            }
        }
        catch (IOException e) {
            LOGGER.warning("IO Error exporting geometry filter");
        }
    }

    public void visit(LikeFilter filter) {
        try {
            String pattern = filter.getPattern();
            pattern = pattern.replaceAll(this.escapedWildcardMulti, SQL_WILD_MULTI);
            pattern = pattern.replaceAll(this.escapedWildcardSingle, SQL_WILD_SINGLE);
            this.out.write("UPPER(");
            filter.getValue().accept((FilterVisitor)this);
            this.out.write(") LIKE ");
            this.out.write("UPPER('" + pattern + "')");
            String esc = filter.getEscape();
            if (pattern.indexOf(esc) != -1) {
                this.out.write(" ESCAPE '" + esc + "'");
            }
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export filter" + ioe);
        }
    }

    public void visit(LiteralExpression literal) {
        if (literal.getType() == 104) {
            Geometry geometry = (Geometry)literal.getLiteral();
            try {
                int srid = -1;
                Integer sridO = (Integer)this.srids.get(this.currentGeomColumnName);
                if (sridO == null) {
                    sridO = (Integer)this.srids.get(null);
                }
                if (sridO != null) {
                    srid = sridO;
                }
                this.out.write(this.toSDOGeom(geometry, srid));
            }
            catch (IOException e) {
                LOGGER.warning("IO Error exporting Literal Geometry");
            }
        } else {
            super.visit(literal);
        }
    }

    public void visit(FidFilter filter) {
        String[] fids = filter.getFids();
        LOGGER.finer("Exporting FID=" + Arrays.asList(fids));
        for (int i = 0; i < fids.length; ++i) {
            try {
                this.out.write(this.fidColumn);
                this.out.write(" = '");
                int pos = fids[i].indexOf(46);
                if (pos != -1) {
                    this.out.write(fids[i].substring(pos + 1));
                } else {
                    this.out.write(fids[i]);
                }
                this.out.write("'");
                if (i >= fids.length - 1) continue;
                this.out.write(" OR ");
                continue;
            }
            catch (IOException e) {
                LOGGER.warning("IO Error exporting FID Filter.");
            }
        }
    }

    public void visit(AttributeExpression ae) throws RuntimeException {
        super.visit(ae);
        if (this.inGeomFilter) {
            this.currentGeomColumnName = ae.getAttributePath();
        }
    }

    static {
        SDO_RELATE_MASK_MAP.put(new Short(11), "contains");
        SDO_RELATE_MASK_MAP.put(new Short(9), "overlapbydisjoint");
        SDO_RELATE_MASK_MAP.put(new Short(5), "equal");
        SDO_RELATE_MASK_MAP.put(new Short(7), "anyinteract");
        SDO_RELATE_MASK_MAP.put(new Short(12), "overlapbyintersect");
        SDO_RELATE_MASK_MAP.put(new Short(8), "touch");
        SDO_RELATE_MASK_MAP.put(new Short(10), "inside");
    }
}

