/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.sdoapi.OraSpatialManager;
import oracle.sdoapi.adapter.AdapterSDO;
import oracle.sdoapi.adapter.GeometryInputTypeNotSupportedException;
import oracle.sdoapi.adapter.GeometryOutputTypeNotSupportedException;
import oracle.sdoapi.geom.Geometry;
import oracle.sdoapi.geom.GeometryFactory;
import oracle.sdoapi.geom.InvalidGeometryException;
import oracle.sdoapi.sref.SRException;
import oracle.sdoapi.sref.SRManager;
import oracle.sdoapi.sref.SpatialReference;
import oracle.sql.STRUCT;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.QueryDataObserver;
import org.geotools.data.jdbc.ResultSetAttributeIO;
import org.geotools.data.oracle.AdapterJTS;
import org.geotools.feature.AttributeType;

public class OracleSDOAttributeReader
extends ResultSetAttributeIO {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.oracle");
    private AdapterJTS adapterJTS;
    private AdapterSDO adapterSDO;
    private int columnIndex;
    private QueryData queryData;

    public OracleSDOAttributeReader(AttributeType metaData, QueryData queryData, int columnIndex) throws DataSourceException {
        super(new AttributeType[]{metaData}, queryData, columnIndex, columnIndex + 1);
        this.queryData = queryData;
        this.columnIndex = columnIndex;
        try {
            String tableName = queryData.getFeatureTypeInfo().getFeatureTypeName();
            String columnName = metaData.getName();
            LOGGER.fine("About to create Geometry convertor for " + tableName + "." + columnName);
            OracleConnection conn = (OracleConnection)queryData.getConnection();
            GeometryFactory gFact = null;
            int srid = queryData.getFeatureTypeInfo().getSRID(columnName);
            if (srid != -1) {
                SRManager srManager = OraSpatialManager.getSpatialReferenceManager((OracleConnection)conn);
                SpatialReference sr = srManager.retrieve(srid);
                gFact = OraSpatialManager.getGeometryFactory((SpatialReference)sr);
            } else {
                gFact = OraSpatialManager.getGeometryFactory();
            }
            this.adapterSDO = new AdapterSDO(gFact, conn);
            this.adapterJTS = new AdapterJTS(gFact);
        }
        catch (SQLException e) {
            queryData.close(e, (QueryDataObserver)this);
            String msg = "Error setting up SDO Geometry convertor";
            LOGGER.log(Level.SEVERE, msg, e);
            throw new DataSourceException(msg + ":" + e.getMessage(), (Throwable)e);
        }
        catch (SRException e) {
            throw new DataSourceException("Error setting up SDO Geometry convertor", (Throwable)e);
        }
    }

    public Object read(int i) throws IOException, ArrayIndexOutOfBoundsException {
        if (this.isClosed()) {
            throw new IOException("Close has already been called on this AttributeReader.");
        }
        if (i != 0) {
            throw new ArrayIndexOutOfBoundsException("This Reader only reads one attribute so i should always be 0");
        }
        try {
            QueryData.RowData rd = this.queryData.getRowData((QueryDataObserver)this);
            Object struct = rd.read(this.columnIndex);
            Geometry sdoGeom = this.adapterSDO.importGeometry(struct);
            return this.adapterJTS.exportGeometry(com.vividsolutions.jts.geom.Geometry.class, sdoGeom);
        }
        catch (SQLException e) {
            String msg = "SQL Exception reading geometry column";
            LOGGER.log(Level.SEVERE, msg, e);
            throw new DataSourceException(msg, (Throwable)e);
        }
        catch (InvalidGeometryException e) {
            String msg = "Problem with the geometry";
            LOGGER.log(Level.SEVERE, msg, e);
            throw new DataSourceException(msg, (Throwable)e);
        }
        catch (GeometryInputTypeNotSupportedException e) {
            String msg = "Geometry Conversion type error";
            LOGGER.log(Level.SEVERE, msg, e);
            throw new DataSourceException(msg, (Throwable)e);
        }
        catch (GeometryOutputTypeNotSupportedException e) {
            String msg = "Geometry Conversion type error";
            LOGGER.log(Level.SEVERE, msg, e);
            throw new DataSourceException(msg, (Throwable)e);
        }
    }

    public void write(int position, Object attribute) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Close has already been called on this AttributeReader.");
        }
        if (position != 0) {
            throw new ArrayIndexOutOfBoundsException("This Reader only reads one attribute so i should always be 0");
        }
        try {
            Geometry sdoGeom = this.adapterJTS.importGeometry(attribute);
            Object o = this.adapterSDO.exportGeometry(STRUCT.class, sdoGeom);
            QueryData.RowData rd = this.queryData.getRowData((QueryDataObserver)this);
            rd.write(o, this.columnIndex);
        }
        catch (SQLException sqlException) {
            this.queryData.close(sqlException, (QueryDataObserver)this);
            String msg = "SQL Exception writing geometry column";
            LOGGER.log(Level.SEVERE, msg, sqlException);
            throw new DataSourceException(msg, (Throwable)sqlException);
        }
        catch (InvalidGeometryException e) {
            String msg = "Problem with the geometry";
            LOGGER.log(Level.SEVERE, msg, e);
            throw new DataSourceException(msg, (Throwable)e);
        }
        catch (GeometryInputTypeNotSupportedException e) {
            String msg = "Geometry Conversion type error";
            LOGGER.log(Level.SEVERE, msg, e);
            throw new DataSourceException(msg, (Throwable)e);
        }
        catch (GeometryOutputTypeNotSupportedException e) {
            String msg = "Geometry Conversion type error";
            LOGGER.log(Level.SEVERE, msg, e);
            throw new DataSourceException(msg, (Throwable)e);
        }
    }
}

