/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.oracle.OracleConnectionFactory;
import org.geotools.data.oracle.OracleDataStore;

public class OracleDataStoreFactory
implements DataStoreFactorySpi {
    public boolean canProcess(Map params) {
        return params.containsKey("dbtype") && params.get("dbtype").equals("oracle") && params.containsKey("host") && params.containsKey("port") && params.containsKey("user") && params.containsKey("passwd") && params.containsKey("instance");
    }

    public DataStore createDataStore(Map params) throws IOException {
        if (!this.canProcess(params)) {
            return null;
        }
        String host = (String)params.get("host");
        String port = (String)params.get("port");
        String instance = (String)params.get("instance");
        String user = (String)params.get("user");
        String passwd = (String)params.get("passwd");
        String schema = (String)params.get("schema");
        try {
            OracleConnectionFactory ocFactory = new OracleConnectionFactory(host, port, instance);
            ocFactory.setLogin(user, passwd);
            ConnectionPool pool = ocFactory.getConnectionPool();
            OracleDataStore dataStore = new OracleDataStore(pool, schema);
            return dataStore;
        }
        catch (SQLException ex) {
            throw new DataSourceException("Error creating oracle DataSource", (Throwable)ex);
        }
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("Oracle cannot create a new Database");
    }

    public String getDescription() {
        return "Oracle Spatial Database";
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return new DataStoreFactorySpi.Param[]{new DataStoreFactorySpi.Param("oracle", String.class, "This must be 'oracle'.", true), new DataStoreFactorySpi.Param("host", String.class, "The host name of the server.", true), new DataStoreFactorySpi.Param("port", String.class, "The port oracle is running on.", true), new DataStoreFactorySpi.Param("user", String.class, "The user name to log in with.", true), new DataStoreFactorySpi.Param("passwd", String.class, "The password.", true), new DataStoreFactorySpi.Param("instance", String.class, "The name of the Oracle instance to connect to.", true), new DataStoreFactorySpi.Param("schema", String.class, "The schema to narrow down the exposed tables.", false)};
    }
}

