/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.sdoapi.OraSpatialManager;
import oracle.sdoapi.util.GeometryMetaData;
import org.geotools.data.AttributeReader;
import org.geotools.data.AttributeWriter;
import org.geotools.data.DataSourceException;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.DefaultSQLBuilder;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.oracle.OracleSDOAttributeReader;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderOracle;

public class OracleDataStore
extends JDBCDataStore {
    public OracleDataStore(ConnectionPool connectionPool, String schemaName) throws IOException {
        super(connectionPool, schemaName);
    }

    public OracleDataStore(ConnectionPool connectionPool, String namespace, String schemaName) throws IOException {
        super(connectionPool, namespace, schemaName);
    }

    protected boolean allowTable(String tablename) {
        if (tablename.endsWith("$")) {
            return false;
        }
        if (tablename.startsWith("XDB$")) {
            return false;
        }
        if (tablename.startsWith("DR$")) {
            return false;
        }
        if (tablename.startsWith("DEF$")) {
            return false;
        }
        if (tablename.startsWith("SDO_")) {
            return false;
        }
        if (tablename.startsWith("WM$")) {
            return false;
        }
        if (tablename.startsWith("WK$")) {
            return false;
        }
        return !tablename.startsWith("AW$");
    }

    protected AttributeReader createGeometryReader(AttributeType attrType, QueryData queryData, int index) throws IOException {
        return new OracleSDOAttributeReader(attrType, queryData, index);
    }

    protected AttributeWriter createGeometryWriter(AttributeType attrType, QueryData queryData, int index) throws IOException {
        return new OracleSDOAttributeReader(attrType, queryData, index);
    }

    protected AttributeType buildAttributeType(ResultSet rs) throws SQLException, DataSourceException {
        int COLUMN_NAME = 4;
        int DATA_TYPE = 5;
        int TYPE_NAME = 6;
        if (rs.getString(6).equals("SDO_GEOMETRY")) {
            String columnName = rs.getString(4);
            return AttributeTypeFactory.newAttributeType((String)columnName, (Class)Geometry.class);
        }
        return super.buildAttributeType(rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int determineSRID(String tableName, String geometryColumnName) throws IOException {
        OracleConnection conn = null;
        try {
            conn = (OracleConnection)this.getConnection(Transaction.AUTO_COMMIT);
            GeometryMetaData gMetaData = OraSpatialManager.getGeometryMetaData((OracleConnection)conn, (String)tableName, (String)geometryColumnName);
            int n = gMetaData.getSpatialReferenceID();
            return n;
        }
        finally {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
        }
    }

    public SQLBuilder getSqlBuilder(String typeName) throws IOException {
        JDBCDataStore.FeatureTypeInfo info = this.getFeatureTypeInfo(typeName);
        SQLEncoderOracle encoder = new SQLEncoderOracle(info.getFidColumnName(), info.getSRIDs());
        return new DefaultSQLBuilder((SQLEncoder)encoder);
    }
}

