/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.sql.SQLException;
import java.util.Map;
import org.geotools.data.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceFactorySpi;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.oracle.OracleConnectionFactory;
import org.geotools.data.oracle.OracleDataSource;

public class OracleDataSourceFactory
implements DataSourceFactorySpi {
    public DataSource createDataSource(Map params) throws DataSourceException {
        if (!this.canProcess(params)) {
            return null;
        }
        String host = (String)params.get("host");
        String port = (String)params.get("port");
        String instance = (String)params.get("instance");
        String user = (String)params.get("user");
        String passwd = (String)params.get("passwd");
        String tableName = (String)params.get("table");
        String fidDefault = (String)params.get("fiddefault");
        if (fidDefault == null) {
            fidDefault = "OBJECTID";
        }
        try {
            OracleConnectionFactory ocFactory = new OracleConnectionFactory(host, port, instance);
            ocFactory.setLogin(user, passwd);
            ConnectionPool pool = ocFactory.getConnectionPool();
            OracleDataSource dataSource = new OracleDataSource(pool, tableName, fidDefault);
            return dataSource;
        }
        catch (SQLException ex) {
            throw new DataSourceException("Error creating oracle DataSource", (Throwable)ex);
        }
    }

    public String getDescription() {
        return "Oracle Spatial Database";
    }

    public boolean canProcess(Map params) {
        return params.containsKey("dbtype") && params.get("dbtype").equals("oracle") && params.containsKey("host") && params.containsKey("port") && params.containsKey("passwd") && params.containsKey("instance") && params.containsKey("table");
    }
}

