/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import com.vividsolutions.jts.geom.Envelope;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.sdoapi.OraSpatialManager;
import oracle.sdoapi.adapter.AdapterSDO;
import oracle.sdoapi.adapter.GeometryInputTypeNotSupportedException;
import oracle.sdoapi.adapter.GeometryOutputTypeNotSupportedException;
import oracle.sdoapi.geom.Geometry;
import oracle.sdoapi.geom.GeometryFactory;
import oracle.sdoapi.geom.InvalidGeometryException;
import oracle.sdoapi.sref.SRException;
import oracle.sdoapi.sref.SRManager;
import oracle.sdoapi.sref.SpatialReference;
import oracle.sdoapi.util.GeometryMetaData;
import org.geotools.data.AbstractDataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceMetaData;
import org.geotools.data.Query;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.oracle.AdapterJTS;
import org.geotools.data.oracle.FIDSequence;
import org.geotools.data.oracle.SqlStatementEncoder;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.factory.FactoryConfigurationError;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.SQLEncoderOracle;
import org.geotools.filter.SQLUnpacker;

public final class OracleDataSource
extends AbstractDataSource {
    private final String DEFAULT_FID_COLUMN;
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.oracle");
    private static final int NAME_COLUMN = 4;
    private static final int TYPE_STRING_COLUMN = 6;
    private static final Map TYPE_MAPPINGS = new HashMap();
    private AdapterJTS adapterJTS;
    private OracleConnection transactionConnection = null;
    private ConnectionPool connectionPool;
    private String fidColumn;
    private FIDSequence fidSequence;
    private int srid = -1;
    private String oraSchemaName = null;
    private FeatureType schema = null;
    private String tableName = null;
    private SQLUnpacker unpacker;
    private SqlStatementEncoder sqlEncoder;
    static /* synthetic */ Class class$oracle$sql$STRUCT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleDataSource(ConnectionPool connectionPool, String tableName, String fidDefault) throws DataSourceException, SQLException {
        this.DEFAULT_FID_COLUMN = fidDefault;
        int dotIndex = -1;
        this.connectionPool = connectionPool;
        dotIndex = tableName.indexOf(".");
        if (dotIndex > -1) {
            LOGGER.finer("Splitting table name on " + dotIndex);
            this.oraSchemaName = tableName.substring(0, dotIndex);
            this.tableName = tableName.substring(dotIndex + 1);
            LOGGER.finer("oraSchemaName = " + this.oraSchemaName + ", tableName = " + this.tableName);
        } else {
            this.tableName = tableName;
        }
        OracleConnection conn = this.getConnection();
        try {
            this.fidColumn = this.getFidColumn(conn, tableName);
            this.schema = this.makeSchema(conn);
            this.fidSequence = new FIDSequence((Connection)conn, tableName, this.fidColumn);
        }
        finally {
            conn.close();
        }
        SQLEncoderOracle encoder = new SQLEncoderOracle(this.fidColumn, this.srid);
        this.unpacker = new SQLUnpacker(encoder.getCapabilities());
        this.sqlEncoder = new SqlStatementEncoder(encoder, this.tableName, this.fidColumn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set addFeatures(FeatureCollection fc) throws DataSourceException {
        boolean previousAutoCommit = this.getAutoCommit();
        this.setAutoCommit(false);
        boolean fail = false;
        TreeSet<String> fids = new TreeSet<String>();
        String sql = this.sqlEncoder.makeInsertSQL(this.schema);
        OracleConnection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getTransactionConnection();
            statement = conn.prepareStatement(sql);
            Iterator iter = fc.iterator();
            while (iter.hasNext()) {
                Feature feature = (Feature)iter.next();
                if (!this.tableName.equals(feature.getFeatureType().getTypeName())) {
                    LOGGER.warning("Got a feature that is not of the correct type");
                    continue;
                }
                int fidInt = this.fidSequence.getNext();
                String fid = this.tableName + "." + fidInt;
                AttributeType[] attributeTypes = this.schema.getAttributeTypes();
                statement.setInt(1, fidInt);
                for (int j = 0; j < attributeTypes.length; ++j) {
                    if (attributeTypes[j].isGeometry()) {
                        Geometry geometry = this.adapterJTS.importGeometry(feature.getAttribute(j));
                        AdapterSDO adaptersdo = this.getSDOAdapter(conn, attributeTypes[j].getName());
                        Object exportedStruct = adaptersdo.exportGeometry(class$oracle$sql$STRUCT == null ? OracleDataSource.class$("oracle.sql.STRUCT") : class$oracle$sql$STRUCT, geometry);
                        statement.setObject(j + 2, exportedStruct);
                        continue;
                    }
                    statement.setObject(j + 2, feature.getAttribute(j));
                }
                statement.executeUpdate();
                fids.add(fid);
            }
            this.close(statement);
        }
        catch (SQLException e) {
            try {
                fail = true;
                String message = "Database error when adding features: " + e.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, (Throwable)e);
                catch (InvalidGeometryException e2) {
                    fail = true;
                    message = "Geometry Conversion error when adding features: " + e2.getMessage();
                    LOGGER.warning(message);
                    throw new DataSourceException(message, (Throwable)e2);
                }
                catch (GeometryInputTypeNotSupportedException e3) {
                    fail = true;
                    message = "Geometry input type error when adding features: " + e3.getMessage();
                    LOGGER.warning(message);
                    throw new DataSourceException(message, (Throwable)e3);
                }
                catch (GeometryOutputTypeNotSupportedException e4) {
                    fail = true;
                    message = "Geometry output type error when adding features: " + e4.getMessage();
                    LOGGER.warning(message);
                    throw new DataSourceException(message, (Throwable)e4);
                }
            }
            catch (Throwable throwable) {
                this.close(statement);
                this.finalizeTransactionMethod(previousAutoCommit, fail);
                throw throwable;
            }
        }
        this.finalizeTransactionMethod(previousAutoCommit, fail);
        return fids;
    }

    private void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warning("Failed to close result set - " + e.getMessage());
        }
    }

    private void close(Statement s) {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warning("Failed to close PreparedStatement - " + e.getMessage());
        }
    }

    public void commit() throws DataSourceException {
        try {
            this.getTransactionConnection().commit();
            this.closeTransactionConnection();
        }
        catch (SQLException e) {
            String message = "problem committing";
            LOGGER.warning(message + ": " + e.getMessage());
            throw new DataSourceException(message, (Throwable)e);
        }
    }

    private Feature createFeature(OracleConnection conn, ResultSet result, FeatureType localSchema) throws SQLException, DataSourceException {
        try {
            AttributeType[] attrTypes = localSchema.getAttributeTypes();
            Object[] attributes = new Object[localSchema.getAttributeCount()];
            String fid = this.getTypeName() + "." + result.getString(1);
            for (int i = 0; i < attributes.length; ++i) {
                if (attrTypes[i].isGeometry()) {
                    LOGGER.finest("getting Adapter");
                    AdapterSDO adaptersdo = this.getSDOAdapter(conn, attrTypes[i].getName());
                    LOGGER.finest("about to get geom");
                    attributes[i] = this.adapterJTS.exportGeometry(class$com$vividsolutions$jts$geom$Geometry == null ? OracleDataSource.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry, adaptersdo.importGeometry(result.getObject(i + 2)));
                    LOGGER.finest("get geom " + attributes[i]);
                    continue;
                }
                attributes[i] = result.getObject(i + 2);
            }
            return localSchema.create(attributes, fid);
        }
        catch (InvalidGeometryException e) {
            String message = "Error parsing geometry: " + e.toString();
            LOGGER.warning(message);
            throw new DataSourceException(message, (Throwable)e);
        }
        catch (GeometryOutputTypeNotSupportedException e) {
            String message = "Geometry Conversion type error: " + e.toString();
            LOGGER.warning(message);
            throw new DataSourceException(message, (Throwable)e);
        }
        catch (GeometryInputTypeNotSupportedException e) {
            String message = "Geometry Conversion type error: " + e.toString();
            LOGGER.warning(message);
            throw new DataSourceException(message, (Throwable)e);
        }
        catch (IllegalAttributeException e) {
            String message = "Error instantiating feature: " + e.toString();
            LOGGER.warning(message);
            throw new DataSourceException(message, (Throwable)e);
        }
    }

    protected DataSourceMetaData createMetaData() {
        AbstractDataSource.MetaDataSupport support = new AbstractDataSource.MetaDataSupport();
        support.setFastBbox(true);
        support.setSupportsRollbacks(true);
        support.setSupportsAdd(true);
        support.setSupportsModify(true);
        support.setSupportsRemove(true);
        support.setSupportsSetFeatures(true);
        support.setSupportsGetBbox(true);
        return support;
    }

    private String formatFid(Feature feature) {
        String fid = feature.getID();
        if (fid.startsWith(this.tableName)) {
            fid = fid.substring(this.tableName.length() + 1);
        }
        return fid;
    }

    private AttributeType[] getAttTypes(Query query) throws DataSourceException {
        AttributeType[] schemaTypes = this.schema.getAttributeTypes();
        if (query.retrieveAllProperties()) {
            return schemaTypes;
        }
        ArrayList<String> attNames = new ArrayList<String>();
        attNames.addAll(Arrays.asList(query.getPropertyNames()));
        AttributeType[] retAttTypes = new AttributeType[attNames.size()];
        int j = 0;
        int n = schemaTypes.length;
        for (int i = 0; i < n; ++i) {
            String schemaTypeName = schemaTypes[i].getName();
            if (!attNames.contains(schemaTypeName)) continue;
            retAttTypes[j] = schemaTypes[i];
            ++j;
            attNames.remove(schemaTypeName);
        }
        if (attNames.size() > 0) {
            String msg = "Attempted to request a property, " + attNames.get(0) + " that is not part of the schema";
            throw new DataSourceException(msg);
        }
        return retAttTypes;
    }

    public boolean getAutoCommit() throws DataSourceException {
        try {
            if (this.transactionConnection == null) {
                return true;
            }
            return this.getTransactionConnection().getAutoCommit();
        }
        catch (SQLException e) {
            String message = "problem getting auto commit";
            LOGGER.warning(message + ": " + e.getMessage());
            throw new DataSourceException(message, (Throwable)e);
        }
    }

    public Envelope getBounds() {
        try {
            Envelope bbox = null;
            OracleConnection conn = this.getConnection();
            GeometryMetaData metaData = OraSpatialManager.getGeometryMetaData((OracleConnection)conn, (String)this.tableName, (String)this.schema.getDefaultGeometry().getName());
            if (metaData != null) {
                oracle.sdoapi.geom.Envelope oraEnv = metaData.getExtent();
                bbox = new Envelope(oraEnv.getMinX(), oraEnv.getMaxX(), oraEnv.getMinY(), oraEnv.getMaxY());
            }
            LOGGER.fine("Got bounds " + bbox);
            return bbox;
        }
        catch (DataSourceException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getFeatures(FeatureCollection collection, Query query) throws DataSourceException {
        LOGGER.finest("Entering getFeatures");
        OracleConnection conn = null;
        int maxFeatures = query.getMaxFeatures();
        Filter filter = query.getFilter();
        ArrayList<Feature> features = new ArrayList<Feature>();
        ResultSet result = null;
        Statement statement = null;
        try {
            Filter manualFilter = null;
            Filter supportedFilters = null;
            conn = this.getConnection();
            statement = conn.createStatement();
            if (filter != null) {
                LOGGER.finer("Unpacking filter");
                this.unpacker.unPackAND(filter);
                manualFilter = this.unpacker.getUnSupported();
                supportedFilters = this.unpacker.getSupported();
            }
            AttributeType[] attrTypes = this.getAttTypes(query);
            FeatureType localSchema = FeatureTypeFactory.newFeatureType((AttributeType[])attrTypes, (String)this.tableName);
            boolean useMax = filter == Filter.NONE || manualFilter == null;
            String sqlQuery = this.sqlEncoder.makeSelectSQL(attrTypes, supportedFilters, maxFeatures, useMax);
            LOGGER.fine("SQLQuery: " + sqlQuery);
            result = statement.executeQuery(sqlQuery);
            while (true) {
                if (!result.next()) {
                    collection.addAll(features);
                    this.close(result);
                    this.close(statement);
                    this.close(conn);
                    return;
                }
                Feature newFeature = this.createFeature(conn, result, localSchema);
                if (newFeature == null) {
                    LOGGER.finer("Null feature return, trying the next one.");
                    continue;
                }
                if (manualFilter == null) {
                    LOGGER.fine("Adding feature: " + newFeature.getID());
                    features.add(newFeature);
                    continue;
                }
                if (!manualFilter.contains(newFeature)) continue;
                LOGGER.fine("Adding Manually filtered features: " + newFeature.getID());
                features.add(newFeature);
            }
        }
        catch (SQLException e) {
            try {
                String message = "SQL Error when loading features: " + e.toString();
                LOGGER.warning(message);
                throw new DataSourceException(message, (Throwable)e);
                catch (FactoryConfigurationError e2) {
                    message = "Error instantiating feature factory: " + e2.toString();
                    LOGGER.warning(message);
                    throw new DataSourceException(message, (Throwable)e2);
                }
                catch (SchemaException e3) {
                    message = "Error creating schema: " + e3.toString();
                    LOGGER.warning(message);
                    throw new DataSourceException(message, (Throwable)e3);
                }
                catch (SQLEncoderException e4) {
                    message = "Error creating sql statement: " + e4.toString();
                    LOGGER.warning(message);
                    throw new DataSourceException(message, (Throwable)e4);
                }
            }
            catch (Throwable throwable) {
                this.close(result);
                this.close(statement);
                this.close(conn);
                throw throwable;
            }
        }
    }

    private void close(OracleConnection conn) {
        try {
            conn.close();
        }
        catch (SQLException e) {
            LOGGER.warning("Error closing connection: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFidColumn(OracleConnection conn, String tableName) {
        String pkString = this.DEFAULT_FID_COLUMN;
        ResultSet rs = null;
        try {
            DatabaseMetaData dbMetadata = conn.getMetaData();
            rs = dbMetadata.getPrimaryKeys(null, null, tableName);
            if (rs.next()) {
                pkString = rs.getString(4);
            }
            this.close(rs);
        }
        catch (SQLException e) {
            try {
                LOGGER.warning("Could not find the primary key - using the default");
                this.close(rs);
            }
            catch (Throwable throwable) {
                this.close(rs);
                throw throwable;
            }
        }
        LOGGER.finest("FID=" + pkString);
        return pkString;
    }

    private AttributeType getGeometryAttribute(OracleConnection conn, String tableName, String columnName) throws DataSourceException {
        AttributeType attributeType = null;
        ResultSet rs = null;
        Statement statement = null;
        try {
            StringBuffer queryBuffer = new StringBuffer("SELECT ");
            queryBuffer.append(columnName);
            queryBuffer.append(" FROM ");
            queryBuffer.append(tableName);
            queryBuffer.append(" WHERE ROWNUM = 1");
            String query = queryBuffer.toString();
            LOGGER.finer("Checking geometry using: " + query);
            statement = conn.createStatement();
            rs = statement.executeQuery(query);
            if (rs.next()) {
                try {
                    Object geomObject = rs.getObject(columnName);
                    AdapterSDO adaptersdo = this.getSDOAdapter(conn, columnName);
                    this.adapterJTS = this.getJTSAdapter(conn, columnName);
                    Geometry sdoGeom = adaptersdo.importGeometry(geomObject);
                    com.vividsolutions.jts.geom.Geometry geometry = (com.vividsolutions.jts.geom.Geometry)this.adapterJTS.exportGeometry(com.vividsolutions.jts.geom.Geometry.class, sdoGeom);
                    Class geomClass = JTSUtilities.findBestGeometryClass((ShapeType)JTSUtilities.findBestGeometryType((com.vividsolutions.jts.geom.Geometry)geometry));
                    attributeType = AttributeTypeFactory.newAttributeType((String)columnName, (Class)geomClass);
                }
                catch (Exception e) {
                    String message = "Could not import geometry";
                    LOGGER.log(Level.SEVERE, message, e);
                    throw new DataSourceException(message, (Throwable)e);
                }
            } else {
                throw new DataSourceException("Could not get any features to determine geometry type");
            }
            this.close(rs);
            this.close(statement);
        }
        catch (SQLException e) {
            try {
                String message = "Database error when getting geometry attribute";
                LOGGER.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(statement);
                throw throwable;
            }
        }
        return attributeType;
    }

    public FeatureType getSchema() {
        return this.schema;
    }

    private String getTypeName() {
        String typeName = "";
        if (this.oraSchemaName != null) {
            typeName = typeName + this.oraSchemaName + ".";
        }
        typeName = typeName + this.tableName;
        return typeName;
    }

    private AdapterSDO getSDOAdapter(OracleConnection conn, String geometryColumnName) throws DataSourceException {
        try {
            GeometryMetaData metaData = OraSpatialManager.getGeometryMetaData((OracleConnection)conn, (String)this.tableName, (String)geometryColumnName);
            if (metaData == null) {
                throw new DataSourceException("No geometry metadata found for " + this.tableName + "," + geometryColumnName + ". Every Geometry must have an entry in" + "the USER__SDO_GEOM_METADATA table.");
            }
            SRManager srManager = OraSpatialManager.getSpatialReferenceManager((OracleConnection)conn);
            if (this.srid == -1) {
                this.srid = metaData.getSpatialReferenceID();
            }
            SpatialReference sr = srManager.retrieve(this.srid);
            GeometryFactory gFact = OraSpatialManager.getGeometryFactory((SpatialReference)sr);
            return new AdapterSDO(gFact, conn);
        }
        catch (SRException e) {
            String message = e.getMessage();
            LOGGER.warning(message);
            throw new DataSourceException(message, (Throwable)e);
        }
        catch (SQLException e) {
            String message = e.getMessage();
            LOGGER.warning(message);
            throw new DataSourceException(message, (Throwable)e);
        }
    }

    private AdapterJTS getJTSAdapter(OracleConnection conn, String geometryColumnName) throws DataSourceException {
        try {
            GeometryMetaData metaData = OraSpatialManager.getGeometryMetaData((OracleConnection)conn, (String)this.tableName, (String)geometryColumnName);
            SRManager srManager = OraSpatialManager.getSpatialReferenceManager((OracleConnection)conn);
            if (this.srid == -1) {
                this.srid = metaData.getSpatialReferenceID();
            }
            SpatialReference sr = srManager.retrieve(this.srid);
            GeometryFactory gFact = OraSpatialManager.getGeometryFactory((SpatialReference)sr);
            return new AdapterJTS(gFact);
        }
        catch (SRException e) {
            String message = e.getMessage();
            LOGGER.warning(message);
            throw new DataSourceException(message, (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FeatureType makeSchema(OracleConnection conn) throws DataSourceException {
        FeatureType featureType = null;
        ResultSet tableInfo = null;
        try {
            DatabaseMetaData dbMetaData = conn.getMetaData();
            tableInfo = dbMetaData.getColumns(null, this.oraSchemaName, this.tableName, "%");
            ArrayList<AttributeType> attributeTypes = new ArrayList<AttributeType>();
            while (true) {
                if (!tableInfo.next()) {
                    AttributeType[] types = attributeTypes.toArray(new AttributeType[0]);
                    featureType = FeatureTypeFactory.newFeatureType((AttributeType[])types, (String)this.tableName);
                    this.close(tableInfo);
                    return featureType;
                }
                LOGGER.fine("Column Name = " + tableInfo.getObject(4) + "; Column Type = " + tableInfo.getObject(6));
                String attributeName = tableInfo.getString(4);
                if (this.fidColumn.equals(attributeName)) continue;
                if ("SDO_GEOMETRY".equals(tableInfo.getString(6))) {
                    AttributeType geomType = this.getGeometryAttribute(conn, this.tableName, attributeName);
                    attributeTypes.add(geomType);
                    continue;
                }
                Class type = (Class)TYPE_MAPPINGS.get(tableInfo.getString(6));
                if (type != null) {
                    AttributeType attributeType = AttributeTypeFactory.newAttributeType((String)attributeName, (Class)type);
                    attributeTypes.add(attributeType);
                    continue;
                }
                LOGGER.fine("Ignoring an SQL type that is not known: " + tableInfo.getString(6));
            }
        }
        catch (SQLException e) {
            try {
                String error = "Database error in schema construction: " + e;
                LOGGER.warning(error);
                throw new DataSourceException(error, (Throwable)e);
                catch (SchemaException e2) {
                    error = "Error in schema construction: " + (Object)((Object)e2);
                    LOGGER.warning(error);
                    throw new DataSourceException(error, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.close(tableInfo);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyFeatures(AttributeType[] types, Object[] values, Filter filter) throws DataSourceException {
        boolean previousAutoCommit = this.getAutoCommit();
        this.setAutoCommit(false);
        boolean fail = false;
        OracleConnection conn = null;
        PreparedStatement pStatement = null;
        Statement statement = null;
        if (types.length != values.length) {
            throw new DataSourceException("The number of AttributeTypes must match the number of values");
        }
        this.unpacker.unPackOR(filter);
        Filter supported = this.unpacker.getSupported();
        Filter unsupported = this.unpacker.getUnSupported();
        try {
            conn = this.getTransactionConnection();
            if (supported != null) {
                String update = this.sqlEncoder.makeModifyTemplate(types, supported);
                LOGGER.finer("Update STMT: " + update);
                pStatement = conn.prepareStatement(update);
                for (int i = 0; i < values.length; ++i) {
                    if (types[i].isGeometry()) {
                        Geometry geometry = this.adapterJTS.importGeometry(values[i]);
                        AdapterSDO adaptersdo = this.getSDOAdapter(conn, types[i].getName());
                        pStatement.setObject(i + 1, adaptersdo.exportGeometry(class$oracle$sql$STRUCT == null ? OracleDataSource.class$("oracle.sql.STRUCT") : class$oracle$sql$STRUCT, geometry));
                        continue;
                    }
                    pStatement.setObject(i + 1, values[i]);
                }
                pStatement.executeUpdate();
            }
            if (unsupported != null) {
                String sqlTemplate = this.sqlEncoder.makeModifyTemplate(types);
                FeatureCollection features = this.getFeatures(unsupported);
                if (features.size() > 0) {
                    int i = 0;
                    StringBuffer updateBuffer = new StringBuffer(sqlTemplate + " WHERE ");
                    Iterator iter = features.iterator();
                    while (iter.hasNext()) {
                        Feature feature = (Feature)iter.next();
                        updateBuffer.append(this.fidColumn);
                        updateBuffer.append(" = ");
                        updateBuffer.append(this.formatFid(feature));
                        if (i < features.size() - 1) {
                            updateBuffer.append(" OR ");
                        } else {
                            updateBuffer.append(" ");
                        }
                        ++i;
                    }
                    String update = updateBuffer.toString();
                    LOGGER.fine("Manual Update STMT: " + update);
                    pStatement = conn.prepareStatement(update);
                    this.fillModifyValues(types, values, pStatement, conn);
                    pStatement.executeUpdate();
                }
            }
        }
        catch (SQLEncoderException e) {
            fail = true;
            String message = "Failed to encode filter: " + (Object)((Object)e);
            LOGGER.warning(message);
            throw new DataSourceException(message, (Throwable)e);
        }
        catch (SQLException e) {
            fail = true;
            String message = "An SQL Error occured: " + e;
            LOGGER.warning(message);
            throw new DataSourceException(message, (Throwable)e);
        }
        catch (GeometryInputTypeNotSupportedException e) {
            fail = true;
            String message = "Geometry input type error when updating features: " + (Object)((Object)e);
            LOGGER.warning(message);
            throw new DataSourceException(message, (Throwable)e);
        }
        catch (GeometryOutputTypeNotSupportedException e) {
            fail = true;
            String message = "Geometry output type error when updating features: " + (Object)((Object)e);
            LOGGER.warning(message);
            throw new DataSourceException(message, (Throwable)e);
        }
        catch (InvalidGeometryException e) {
            fail = true;
            String message = "Geometry Conversion error when updating features: " + (Object)((Object)e);
            LOGGER.warning(message);
        }
        finally {
            this.close(pStatement);
            this.close(statement);
            this.finalizeTransactionMethod(previousAutoCommit, fail);
        }
    }

    private void fillModifyValues(AttributeType[] types, Object[] values, PreparedStatement pStatement, OracleConnection conn) throws InvalidGeometryException, GeometryInputTypeNotSupportedException, SQLException, GeometryOutputTypeNotSupportedException, DataSourceException {
        for (int i = 0; i < values.length; ++i) {
            if (types[i].isGeometry()) {
                Geometry geometry = this.adapterJTS.importGeometry(values[i]);
                AdapterSDO adaptersdo = this.getSDOAdapter(conn, types[i].getName());
                Object geomStruct = adaptersdo.exportGeometry(class$oracle$sql$STRUCT == null ? OracleDataSource.class$("oracle.sql.STRUCT") : class$oracle$sql$STRUCT, geometry);
                pStatement.setObject(i + 1, geomStruct);
                continue;
            }
            pStatement.setObject(i + 1, values[i]);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeFeatures(Filter filter) throws DataSourceException {
        boolean previousAutoCommit = this.getAutoCommit();
        this.setAutoCommit(false);
        boolean fail = false;
        this.unpacker.unPackOR(filter);
        Filter supported = this.unpacker.getSupported();
        Filter unsupported = this.unpacker.getUnSupported();
        OracleConnection conn = null;
        Statement statement = null;
        try {
            FeatureCollection features;
            conn = this.getTransactionConnection();
            statement = conn.createStatement();
            if (supported != null) {
                String sql = this.sqlEncoder.makeDeleteSQL(filter);
                LOGGER.finer("delete sql is " + sql);
                statement.executeUpdate(sql);
            }
            if (unsupported != null && (features = this.getFeatures(unsupported)).size() > 0) {
                int i = 0;
                StringBuffer manualDelete = new StringBuffer("DELETE FROM ");
                manualDelete.append(this.tableName);
                manualDelete.append(" WHERE ");
                Iterator iter = features.iterator();
                while (iter.hasNext()) {
                    Feature feature = (Feature)iter.next();
                    manualDelete.append(this.fidColumn);
                    manualDelete.append(" = ");
                    manualDelete.append(this.formatFid(feature));
                    if (i < features.size() - 1) {
                        manualDelete.append(" OR ");
                    }
                    ++i;
                }
                String manualDeleteStmt = manualDelete.toString();
                LOGGER.finer("Manual Delete is: " + manualDeleteStmt);
                statement.executeUpdate(manualDeleteStmt);
            }
            this.close(statement);
        }
        catch (SQLException e) {
            try {
                fail = true;
                String message = "An SQL Error occured: " + e.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, (Throwable)e);
                catch (SQLEncoderException e2) {
                    fail = true;
                    message = "Failed to encode filter: " + e2.getMessage();
                    LOGGER.warning(message);
                    throw new DataSourceException(message, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.close(statement);
                this.finalizeTransactionMethod(previousAutoCommit, fail);
                throw throwable;
            }
        }
        this.finalizeTransactionMethod(previousAutoCommit, fail);
    }

    private void finalizeTransactionMethod(boolean previousAutoCommit, boolean fail) throws DataSourceException {
        if (fail) {
            this.rollback();
        } else if (previousAutoCommit) {
            this.commit();
        }
        this.setAutoCommit(previousAutoCommit);
        this.closeTransactionConnection();
    }

    public void rollback() throws DataSourceException {
        try {
            this.getTransactionConnection().rollback();
            this.closeTransactionConnection();
        }
        catch (SQLException e) {
            String message = "problem with rollbacks";
            LOGGER.warning(message + ": " + e.getMessage());
            throw new DataSourceException(message, (Throwable)e);
        }
    }

    public void setAutoCommit(boolean b) throws DataSourceException {
        try {
            OracleConnection conn = this.getTransactionConnection();
            conn.setAutoCommit(b);
            this.closeTransactionConnection();
        }
        catch (SQLException e) {
            String message = "Error beginning Multi Transaction: " + e.getMessage();
            LOGGER.warning(message);
            throw new DataSourceException(message, (Throwable)e);
        }
    }

    public void setFeatures(FeatureCollection features) throws DataSourceException {
        boolean originalAutoCommit = this.getAutoCommit();
        this.setAutoCommit(false);
        this.removeFeatures(null);
        this.addFeatures(features);
        this.commit();
        this.setAutoCommit(originalAutoCommit);
    }

    private OracleConnection getConnection() throws DataSourceException, SQLException {
        Connection conn = this.connectionPool.getConnection();
        if (conn instanceof OracleConnection) {
            return (OracleConnection)conn;
        }
        throw new DataSourceException("Connection Pool did not return a connection toan Oracle Spatial Database.");
    }

    private OracleConnection getTransactionConnection() throws DataSourceException, SQLException {
        if (this.transactionConnection == null) {
            this.transactionConnection = this.getConnection();
        }
        return this.transactionConnection;
    }

    private void closeTransactionConnection() {
        try {
            if (this.transactionConnection != null && this.transactionConnection.getAutoCommit()) {
                LOGGER.fine("Closing Transaction Connection");
                this.transactionConnection.close();
                this.transactionConnection = null;
            } else {
                LOGGER.fine("Transaction connection not open or set to manual commit");
            }
        }
        catch (SQLException e) {
            LOGGER.warning("Error closing transaction connection: " + e);
        }
    }

    static {
        TYPE_MAPPINGS.put("NUMBER", Double.class);
        TYPE_MAPPINGS.put("VARCHAR", String.class);
        TYPE_MAPPINGS.put("VARCHAR2", String.class);
        TYPE_MAPPINGS.put("INT4", Integer.class);
        TYPE_MAPPINGS.put("FLOAT4", Float.class);
        TYPE_MAPPINGS.put("FLOAT8", Double.class);
    }
}

