/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.ConnectionPoolDataSource;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.ConnectionPoolManager;

public class OracleConnectionFactory {
    private static final String JDBC_PATH = "jdbc:oracle:thin:@";
    private static Map dataSources = new HashMap();
    private String dbUrl;
    private String username = "";
    private String passwd = "";

    public OracleConnectionFactory(String host, String port, String instance) {
        this.dbUrl = JDBC_PATH + host + ":" + port + ":" + instance;
    }

    public ConnectionPool getConnectionPool(String user, String pass) throws SQLException {
        String poolKey = this.dbUrl + user + pass;
        OracleConnectionPoolDataSource poolDataSource = (OracleConnectionPoolDataSource)dataSources.get(poolKey);
        if (poolDataSource == null) {
            poolDataSource = new OracleConnectionPoolDataSource();
            poolDataSource.setURL(this.dbUrl);
            poolDataSource.setUser(user);
            poolDataSource.setPassword(pass);
            dataSources.put(poolKey, poolDataSource);
        }
        ConnectionPoolManager manager = ConnectionPoolManager.getInstance();
        ConnectionPool connectionPool = manager.getConnectionPool((ConnectionPoolDataSource)poolDataSource);
        return connectionPool;
    }

    public ConnectionPool getConnectionPool() throws SQLException {
        return this.getConnectionPool(this.username, this.passwd);
    }

    public void setLogin(String user, String pass) {
        this.username = user;
        this.passwd = pass;
    }
}

