/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.sdoapi.OraSpatialManager;
import oracle.sdoapi.adapter.GeometryAdapter;
import oracle.sdoapi.adapter.GeometryInputTypeNotSupportedException;
import oracle.sdoapi.adapter.GeometryOutputTypeNotSupportedException;
import oracle.sdoapi.geom.CoordPoint;
import oracle.sdoapi.geom.CoordPointImpl;
import oracle.sdoapi.geom.CurvePolygon;
import oracle.sdoapi.geom.CurveString;
import oracle.sdoapi.geom.Geometry;
import oracle.sdoapi.geom.GeometryCollection;
import oracle.sdoapi.geom.InvalidGeometryException;
import oracle.sdoapi.geom.LineString;
import oracle.sdoapi.geom.Polygon;
import oracle.sdoapi.sref.SpatialReference;

public class AdapterJTS
implements GeometryAdapter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.oracle.AdapterJTS");
    private static final String FORMAT_NAME = "JTS";
    private static final String FORMAT_VERSION = "1.3";
    private static final Class[] SUPPORTED_OUTPUT = new Class[]{com.vividsolutions.jts.geom.Geometry.class};
    private static final Class[] SUPPORTED_INPUT = new Class[]{com.vividsolutions.jts.geom.Geometry.class};
    private static final Class[] SUPPORTED_PASS_THROUGH = new Class[0];
    private GeometryFactory jtsFactory = null;
    private oracle.sdoapi.geom.GeometryFactory sdoFactory = null;

    public AdapterJTS() {
        this(new GeometryFactory(), OraSpatialManager.getGeometryFactory());
    }

    public AdapterJTS(GeometryFactory jtsFactory) {
        this(jtsFactory, OraSpatialManager.getGeometryFactory());
    }

    public AdapterJTS(GeometryFactory jtsFactory, oracle.sdoapi.geom.GeometryFactory sdoFactory) {
        this.jtsFactory = jtsFactory;
        this.sdoFactory = sdoFactory;
    }

    public AdapterJTS(oracle.sdoapi.geom.GeometryFactory sdoFactory) {
        this(new GeometryFactory(), sdoFactory);
    }

    public Object exportGeometry(Class outputType, Geometry geom) throws InvalidGeometryException, GeometryOutputTypeNotSupportedException {
        com.vividsolutions.jts.geom.Geometry returnGeometry;
        if (!this.outputTypeSupported(outputType)) {
            throw new GeometryOutputTypeNotSupportedException("Output not supported");
        }
        if (outputType == com.vividsolutions.jts.geom.Polygon.class) {
            outputType = MultiPolygon.class;
        }
        if (outputType == com.vividsolutions.jts.geom.LineString.class) {
            Class clazz = outputType = MultiLineString.class;
        }
        if (!outputType.isInstance(returnGeometry = this.sdoToJts(geom, false))) {
            throw new GeometryOutputTypeNotSupportedException("AdapterJTS does not support convertingfrom " + geom.getClass().getName() + " to " + outputType.getName());
        }
        return this.sdoToJts(geom, false);
    }

    public void exportGeometry(Object outputObject, Geometry geom) throws InvalidGeometryException, GeometryOutputTypeNotSupportedException {
        throw new GeometryOutputTypeNotSupportedException("AdapterJTS does not support exporting to existing objects");
    }

    public Geometry importGeometry(Object inputSource) throws InvalidGeometryException, GeometryInputTypeNotSupportedException {
        if (!this.inputTypeSupported(inputSource.getClass())) {
            throw new GeometryInputTypeNotSupportedException("AdapterJTS does not support " + inputSource.getClass().getName());
        }
        return this.jtsToSdo((com.vividsolutions.jts.geom.Geometry)inputSource);
    }

    public Geometry importGeometry(Object inputSource, int nDim) throws InvalidGeometryException, GeometryInputTypeNotSupportedException {
        return this.importGeometry(inputSource);
    }

    public boolean inputTypeSupported(Class type) {
        return com.vividsolutions.jts.geom.Geometry.class.isAssignableFrom(type);
    }

    public boolean outputTypeSupported(Class type) {
        return com.vividsolutions.jts.geom.Geometry.class.isAssignableFrom(type);
    }

    public boolean passthroughOutputTypeSupported(Class type) {
        return false;
    }

    public Class[] getSupportedInputTypes() {
        return SUPPORTED_INPUT;
    }

    public Class[] getSupportedOutputTypes() {
        return SUPPORTED_OUTPUT;
    }

    public Class[] getSupportedPassthroughOutputTypes() {
        return SUPPORTED_PASS_THROUGH;
    }

    public String getFormatName() {
        return FORMAT_NAME;
    }

    public String getFormatVersion() {
        return FORMAT_VERSION;
    }

    public void setDefaultSRS(SpatialReference sr) {
        this.sdoFactory.setSpatialReference(sr);
    }

    public SpatialReference getDefaultSRS() {
        return this.sdoFactory.getSpatialReference();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private com.vividsolutions.jts.geom.Geometry sdoToJts(Geometry geom, boolean isSubGeom) throws InvalidGeometryException {
        Class geometryType = geom.getGeometryType();
        Point output = null;
        if (geometryType.equals(oracle.sdoapi.geom.Point.class)) {
            oracle.sdoapi.geom.Point point = (oracle.sdoapi.geom.Point)geom;
            output = this.jtsFactory.createPoint(new Coordinate(point.getX(), point.getY(), point.getZ()));
        } else if (geometryType.equals(LineString.class)) {
            LineString line = (LineString)geom;
            output = this.jtsFactory.createLineString(this.coordPointsToCoordinates(line.getPointArray(), line.getDimensionality()));
        } else if (geometryType.equals(CurveString.class)) {
            CurveString curve = (CurveString)geom;
            output = this.jtsFactory.createLineString(this.curveStringToCoordinates(curve));
        } else if (geometryType.equals(Polygon.class)) {
            Polygon polygon = (Polygon)geom;
            Coordinate[] exteriorRingCoords = this.curveStringToCoordinates(polygon.getExteriorRing());
            LinearRing exterior = this.jtsFactory.createLinearRing(exteriorRingCoords);
            LinearRing[] interiors = this.curveStringsToLinearRings(polygon.getInteriorRingArray());
            output = this.jtsFactory.createPolygon(exterior, interiors);
        } else if (geometryType.equals(CurvePolygon.class)) {
            CurvePolygon curvePolygon = (CurvePolygon)geom;
            Coordinate[] exteriorRingCoords = this.curveStringToCoordinates(curvePolygon.getExteriorRing());
            LinearRing exterior = this.jtsFactory.createLinearRing(exteriorRingCoords);
            LinearRing[] interiors = this.curveStringsToLinearRings(curvePolygon.getInteriorRingArray());
            output = this.jtsFactory.createPolygon(exterior, interiors);
        } else if (GeometryCollection.class.isAssignableFrom(geometryType)) {
            GeometryCollection geomCollection = (GeometryCollection)geom;
            ArrayList<com.vividsolutions.jts.geom.Geometry> geometries = new ArrayList<com.vividsolutions.jts.geom.Geometry>(geomCollection.getNumGeometries());
            for (int i = 0; i < geomCollection.getNumGeometries(); ++i) {
                geometries.add(this.sdoToJts(geomCollection.getGeometryAt(i), true));
            }
            if (geometries.size() > 1) {
                output = this.jtsFactory.buildGeometry(geometries);
            } else {
                if (geometries.size() != 1) throw new InvalidGeometryException("No geometries were found.");
                output = (com.vividsolutions.jts.geom.Geometry)geometries.get(0);
            }
        } else {
            String message = "Got a geometry that I don't know how to handle: " + geometryType.getName();
            LOGGER.warning(message);
            throw new InvalidGeometryException(message);
        }
        output.setSRID(geom.getSpatialReference().getID());
        if (isSubGeom) return output;
        return this.checkForMulti((com.vividsolutions.jts.geom.Geometry)output);
    }

    private com.vividsolutions.jts.geom.Geometry checkForMulti(com.vividsolutions.jts.geom.Geometry output) {
        if (output.getClass() == com.vividsolutions.jts.geom.Polygon.class) {
            return this.jtsFactory.createMultiPolygon(new com.vividsolutions.jts.geom.Polygon[]{(com.vividsolutions.jts.geom.Polygon)output});
        }
        if (output.getClass() == com.vividsolutions.jts.geom.LineString.class) {
            return this.jtsFactory.createMultiLineString(new com.vividsolutions.jts.geom.LineString[]{(com.vividsolutions.jts.geom.LineString)output});
        }
        return output;
    }

    private Coordinate[] coordPointsToCoordinates(CoordPoint[] coordPoints, int nDim) throws InvalidGeometryException {
        if (nDim != 3 && nDim != 2) {
            String message = "nDim was not 2 or 3. nDim = " + nDim;
            LOGGER.warning(message);
            throw new InvalidGeometryException(message);
        }
        Coordinate[] coordinates = new Coordinate[coordPoints.length];
        for (int i = 0; i < coordPoints.length; ++i) {
            CoordPoint cp = coordPoints[i];
            coordinates[i] = new Coordinate(cp.getX(), cp.getY(), cp.getZ());
        }
        return coordinates;
    }

    private Coordinate[] curveStringToCoordinates(CurveString cs) throws InvalidGeometryException {
        return this.coordPointsToCoordinates(cs.getPointArray(), cs.getDimensionality());
    }

    private LinearRing[] curveStringsToLinearRings(CurveString[] curveStrings) throws InvalidGeometryException {
        if (curveStrings == null) {
            return new LinearRing[0];
        }
        LinearRing[] rings = new LinearRing[curveStrings.length];
        for (int i = 0; i < curveStrings.length; ++i) {
            rings[i] = this.jtsFactory.createLinearRing(this.curveStringToCoordinates(curveStrings[i]));
        }
        return rings;
    }

    private Geometry jtsToSdo(com.vividsolutions.jts.geom.Geometry geom) throws InvalidGeometryException {
        Class<?> geometryType = geom.getClass();
        LineString output = null;
        if (geometryType.equals(Point.class)) {
            Point point = (Point)geom;
            Coordinate coordinate = point.getCoordinate();
            output = this.sdoFactory.createPoint(this.coordinatesToCoordPoint(coordinate, point.getDimension()));
        } else if (geometryType.equals(com.vividsolutions.jts.geom.LineString.class)) {
            com.vividsolutions.jts.geom.LineString line = (com.vividsolutions.jts.geom.LineString)geom;
            output = this.lineStringJtsToSdo(line);
        } else if (geometryType.equals(com.vividsolutions.jts.geom.Polygon.class)) {
            com.vividsolutions.jts.geom.Polygon polygon = (com.vividsolutions.jts.geom.Polygon)geom;
            LineString exteriorRing = this.lineStringJtsToSdo(polygon.getExteriorRing());
            LineString[] interiorRings = new LineString[polygon.getNumInteriorRing()];
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                interiorRings[i] = this.lineStringJtsToSdo(polygon.getInteriorRingN(i));
            }
            output = this.sdoFactory.createPolygon(exteriorRing, interiorRings);
        } else if (com.vividsolutions.jts.geom.GeometryCollection.class.isAssignableFrom(geom.getClass())) {
            com.vividsolutions.jts.geom.GeometryCollection geomCollection = (com.vividsolutions.jts.geom.GeometryCollection)geom;
            ArrayList<Geometry> sdoGeometries = new ArrayList<Geometry>();
            for (int i = 0; i < geomCollection.getNumGeometries(); ++i) {
                sdoGeometries.add(this.jtsToSdo(geomCollection.getGeometryN(i)));
            }
            Geometry[] sdoGeomArray = sdoGeometries.toArray(new Geometry[0]);
            output = this.sdoFactory.createGeometryCollection(sdoGeomArray);
        } else {
            String message = "Got a geometry that I don't know how to handle: " + geometryType.getName();
            LOGGER.warning(message);
            throw new InvalidGeometryException(message);
        }
        return output;
    }

    private CoordPoint coordinatesToCoordPoint(Coordinate coordinate, int dim) {
        CoordPointImpl coordPoint = new CoordPointImpl(coordinate.x, coordinate.y, coordinate.z);
        return coordPoint;
    }

    private LineString lineStringJtsToSdo(com.vividsolutions.jts.geom.LineString line) throws InvalidGeometryException {
        Coordinate[] coordinates = line.getCoordinates();
        CoordPoint[] coordPoints = new CoordPoint[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            coordPoints[i] = this.coordinatesToCoordPoint(coordinates[i], line.getDimension());
        }
        return this.sdoFactory.createLineString(coordPoints);
    }
}

