/*
 * Decompiled with CFR 0.152.
 */
package org.swixml;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import org.jdom.Document;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXBuilder;
import org.swixml.Localizer;
import org.swixml.Parser;
import org.swixml.SwingTagLibrary;
import org.swixml.TagLibrary;
import org.xml.sax.SAXParseException;

public class SwingEngine {
    public static final String MAC_OSX_LOCALE_VARIANT = "mac";
    public static final boolean DEBUG_MODE = false;
    private static final String XML_ERROR_MSG = "Invalid SwiXML Descriptor.";
    private static final String IO_ERROR_MSG = "Resource could not be found ";
    private static final String MAPPING_ERROR_MSG = " could not be mapped to any Object and remained un-initialized.";
    private static Frame appFrame;
    private static String default_resource_bundle_name;
    private static Locale default_locale;
    private static boolean MAC_OSX;
    private static boolean MAC_OSX_SUPPORTED;
    private Parser parser = new Parser(this);
    private Object client;
    private Container root;
    private Map idmap = new HashMap();
    private Collection components = null;
    private Localizer localizer = new Localizer();
    private final TagLibrary taglib = SwingTagLibrary.getInstance();
    protected ClassLoader cl = this.getClass().getClassLoader();
    static /* synthetic */ Class class$org$swixml$SwingEngine;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$java$awt$Container;
    static /* synthetic */ Class class$javax$swing$AbstractButton;
    static /* synthetic */ Class class$javax$swing$JMenu;
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$javax$swing$JDialog;

    public SwingEngine() {
        this.client = this;
        this.setLocale(default_locale);
        this.getLocalizer().setResourceBundle(default_resource_bundle_name);
        try {
            if (SwingEngine.isMacOSXSupported() && SwingEngine.isMacOSX()) {
                System.setProperty("com.apple.macos.useScreenMenuBar", "true");
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("apple.awt.showGrowBox", "true");
                System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public SwingEngine(Object object) {
        this();
        this.client = object;
    }

    public SwingEngine(String string) throws FileNotFoundException {
        this((class$org$swixml$SwingEngine == null ? (class$org$swixml$SwingEngine = SwingEngine.class$("org.swixml.SwingEngine")) : class$org$swixml$SwingEngine).getClassLoader(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwingEngine(ClassLoader classLoader, String string) throws FileNotFoundException {
        this();
        this.setClassLoader(classLoader);
        Reader reader = null;
        try {
            InputStream inputStream = classLoader.getResourceAsStream(string);
            if (inputStream == null) {
                throw new IOException(IO_ERROR_MSG + string);
            }
            reader = new BufferedReader(new InputStreamReader(inputStream));
            this.render(reader);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container render(URL uRL) throws Exception {
        Reader reader = null;
        Container container = null;
        try {
            InputStream inputStream = uRL.openStream();
            if (inputStream == null) {
                throw new IOException(IO_ERROR_MSG + uRL.toString());
            }
            reader = new BufferedReader(new InputStreamReader(inputStream));
            container = this.render(reader);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container render(String string) throws Exception {
        Reader reader = null;
        Container container = null;
        try {
            InputStream inputStream = this.cl.getResourceAsStream(string);
            if (inputStream == null) {
                throw new IOException(IO_ERROR_MSG + string);
            }
            reader = new BufferedReader(new InputStreamReader(inputStream));
            container = this.render(reader);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return container;
    }

    public Container render(File file) throws Exception {
        if (file == null) {
            throw new IOException();
        }
        return this.render(new FileReader(file));
    }

    public Container render(Reader reader) throws Exception {
        if (reader == null) {
            throw new IOException();
        }
        try {
            return this.render(new SAXBuilder().build(reader));
        }
        catch (SAXParseException sAXParseException) {
            System.err.println(sAXParseException);
        }
        catch (JDOMParseException jDOMParseException) {
            System.err.println((Object)jDOMParseException);
        }
        throw new Exception(XML_ERROR_MSG);
    }

    public Container render(Document document) throws Exception {
        this.idmap.clear();
        this.root = (Container)this.parser.parse(document);
        this.components = null;
        this.mapMembers(this.client);
        if ((class$java$awt$Frame == null ? (class$java$awt$Frame = SwingEngine.class$("java.awt.Frame")) : class$java$awt$Frame).isAssignableFrom(this.root.getClass())) {
            SwingEngine.setAppFrame((Frame)this.root);
        }
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(URL uRL, Container container) throws Exception {
        Reader reader = null;
        try {
            InputStream inputStream = uRL.openStream();
            if (inputStream == null) {
                throw new IOException(IO_ERROR_MSG + uRL.toString());
            }
            reader = new BufferedReader(new InputStreamReader(inputStream));
            this.insert(reader, container);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    public void insert(Reader reader, Container container) throws Exception {
        if (reader == null) {
            throw new IOException();
        }
        this.insert(new SAXBuilder().build(reader), container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String string, Container container) throws Exception {
        Reader reader = null;
        try {
            InputStream inputStream = this.cl.getResourceAsStream(string);
            if (inputStream == null) {
                throw new IOException(IO_ERROR_MSG + string);
            }
            reader = new BufferedReader(new InputStreamReader(inputStream));
            this.insert(reader, container);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    public void insert(Document document, Container container) throws Exception {
        this.root = container;
        this.parser.parse(document, container);
        this.components = null;
        this.mapMembers(this.client);
    }

    public static void setResourceBundleName(String string) {
        default_resource_bundle_name = string;
    }

    public static void setDefaultLocale(Locale locale) {
        default_locale = locale;
    }

    public static void setAppFrame(Frame frame) {
        if (frame != null && appFrame == null) {
            appFrame = frame;
        }
    }

    public static Frame getAppFrame() {
        return appFrame;
    }

    public Object getClient() {
        return this.client;
    }

    public Container getRootComponent() {
        return this.root;
    }

    public Iterator getAllComponentItertor() {
        if (this.components == null) {
            this.components = new ArrayList();
            SwingEngine.traverse(this.root, this.components);
        }
        return this.components.iterator();
    }

    public Iterator getIdComponentItertor() {
        return this.idmap.values().iterator();
    }

    public Map getIdMap() {
        return this.idmap;
    }

    public int cleanup() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.idmap.keySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            Object k = iterator.next();
            Object v = this.idmap.get(k);
            if (!(v instanceof Component) || ((Component)v).isDisplayable()) continue;
            arrayList.add(k);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.idmap.remove(arrayList.get(i));
        }
        this.components = null;
        return arrayList.size();
    }

    public void forget(String string) {
        this.idmap.remove(string);
    }

    public Component find(String string) {
        return (Component)this.idmap.get(string);
    }

    public void setLocale(Locale locale) {
        if (SwingEngine.isMacOSXSupported() && SwingEngine.isMacOSX()) {
            locale = new Locale(locale.getLanguage(), locale.getCountry(), MAC_OSX_LOCALE_VARIANT);
        }
        this.localizer.setLocale(locale);
    }

    public void setResourceBundle(String string) {
        this.localizer.setResourceBundle(string);
    }

    public Localizer getLocalizer() {
        return this.localizer;
    }

    public TagLibrary getTaglib() {
        return this.taglib;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.cl = classLoader;
        this.localizer.setClassLoader(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public boolean setActionListener(Component component, ActionListener actionListener) {
        boolean bl = false;
        if (component != null) {
            int n;
            Object object;
            if ((class$java$awt$Container == null ? (class$java$awt$Container = SwingEngine.class$("java.awt.Container")) : class$java$awt$Container).isAssignableFrom(component.getClass())) {
                object = ((Container)component).getComponents();
                for (n = 0; n < ((Component[])object).length; ++n) {
                    bl |= this.setActionListener(object[n], actionListener);
                }
            }
            if (!bl) {
                if ((class$javax$swing$AbstractButton == null ? (class$javax$swing$AbstractButton = SwingEngine.class$("javax.swing.AbstractButton")) : class$javax$swing$AbstractButton).isAssignableFrom(component.getClass())) {
                    ((AbstractButton)component).addActionListener(actionListener);
                    bl = true;
                } else if ((class$javax$swing$JMenu == null ? (class$javax$swing$JMenu = SwingEngine.class$("javax.swing.JMenu")) : class$javax$swing$JMenu).isAssignableFrom(component.getClass())) {
                    object = (JMenu)component;
                    n = ((JMenu)object).getItemCount();
                    for (int i = 0; i < n; ++i) {
                        bl |= this.setActionListener(((JMenu)object).getItem(i), actionListener);
                    }
                }
            }
        }
        return bl;
    }

    public Iterator getDescendants(Component component) {
        ArrayList arrayList = new ArrayList(12);
        SwingEngine.traverse(component, arrayList);
        return arrayList.iterator();
    }

    protected void mapMembers(Object object) {
        Field[] fieldArray = object.getClass().getFields();
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Object v = this.idmap.get(fieldArray[i].getName());
            if (v != null && fieldArray[i].getType().isAssignableFrom(v.getClass())) {
                try {
                    fieldArray[i].set(object, v);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            if (fieldArray[i] == null) {
                try {
                    fieldArray[i].set(object, fieldArray[i].getType().newInstance());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
            }
            if (fieldArray[i] != null) continue;
        }
    }

    protected static void traverse(Component component, Collection collection) {
        block2: {
            block3: {
                if (component == null) break block2;
                collection.add(component);
                if (!(component instanceof JMenu)) break block3;
                JMenu jMenu = (JMenu)component;
                int n = jMenu.getItemCount();
                for (int i = 0; i < n; ++i) {
                    SwingEngine.traverse(jMenu.getItem(i), collection);
                }
                break block2;
            }
            if (!(component instanceof Container)) break block2;
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                SwingEngine.traverse(componentArray[i], collection);
            }
        }
    }

    public static void setMacOSXSuport(boolean bl) {
        MAC_OSX_SUPPORTED = bl;
    }

    public static boolean isMacOSXSupported() {
        return MAC_OSX_SUPPORTED;
    }

    public static boolean isMacOSX() {
        return MAC_OSX;
    }

    public void test() {
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                System.exit(0);
            }
        };
        if (this.root != null) {
            if ((class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = SwingEngine.class$("javax.swing.JFrame")) : class$javax$swing$JFrame).isAssignableFrom(this.root.getClass()) || (class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = SwingEngine.class$("javax.swing.JDialog")) : class$javax$swing$JDialog).isAssignableFrom(this.root.getClass())) {
                ((Window)this.root).addWindowListener(windowAdapter);
                this.root.setVisible(true);
            } else {
                JFrame jFrame = new JFrame("SwiXml Test");
                jFrame.getContentPane().add(this.root);
                jFrame.pack();
                jFrame.addWindowListener(windowAdapter);
                jFrame.setVisible(true);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        default_resource_bundle_name = null;
        default_locale = Locale.getDefault();
        MAC_OSX = false;
        MAC_OSX_SUPPORTED = true;
        System.out.println("SwixML 1.0.1 (#136)");
        try {
            MAC_OSX = System.getProperty("mrj.version") != null;
        }
        catch (Exception exception) {
            MAC_OSX = false;
        }
    }
}

