/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml;

import java.io.IOException;
import java.util.Iterator;
import org.geotools.data.DataSourceException;
import org.geotools.data.Query;
import org.geotools.data.gml.GMLDataSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.gml.GMLFilterDocument;
import org.geotools.gml.GMLFilterGeometry;
import org.geotools.gml.TestHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TestParser {
    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("-g")) {
            TestParser.parseGeometries(args[1]);
        } else if (args.length > 0 && args[0].equals("-f")) {
            TestParser.parseFeatures(args[1]);
        } else {
            System.out.println("Incorrect specification...useage:");
            System.out.println(" java org.geotools.gml.TestParser [flags] [URI to parse]");
            System.out.println("");
            System.out.println(" flags:");
            System.out.println("  -g: parse geometries only");
            System.out.println("  -f: parse flat feature collection");
            System.out.println("");
            System.out.println(" example: java org.geotools.gml.TestParser -g /home/rob/myGml.gml");
        }
    }

    public static void parseGeometries(String uri) {
        System.out.println("Parsing just the geometries in this GML resource:" + uri);
        try {
            TestHandler contentHandler = new TestHandler();
            GMLFilterGeometry geometryFilter = new GMLFilterGeometry(contentHandler);
            GMLFilterDocument documentFilter = new GMLFilterDocument(geometryFilter);
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            parser.setContentHandler(documentFilter);
            parser.parse(uri);
        }
        catch (IOException e) {
            System.out.println("Error reading uri: " + uri);
        }
        catch (SAXException e) {
            System.out.println("Error in parsing: " + e.getMessage());
        }
    }

    public static void parseFeatures(String uri) {
        System.out.println("Parsing the flat feature collection in this GML resource:" + uri);
        try {
            GMLDataSource data = new GMLDataSource(uri);
            FeatureCollection featureCollection = data.getFeatures(Query.ALL);
            Iterator i = featureCollection.iterator();
            while (i.hasNext()) {
                System.out.println("Parsed feature is ... " + i.next());
            }
        }
        catch (DataSourceException e) {
            System.out.println("TestParser->parseFeatures DataSourceException: " + e.toString());
        }
    }
}

