/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.util;

import org.geotools.data.vpf.ifc.DataTypesDefinition;
import org.geotools.data.vpf.io.Coordinate2DDouble;
import org.geotools.data.vpf.io.Coordinate2DFloat;
import org.geotools.data.vpf.io.Coordinate3DDouble;
import org.geotools.data.vpf.io.Coordinate3DFloat;
import org.geotools.data.vpf.io.VPFDate;

public class DataUtils
implements DataTypesDefinition {
    public static byte[] toBigEndian(byte[] source) {
        byte[] result = new byte[source.length];
        for (int i = 0; i < source.length; ++i) {
            result[i] = source[source.length - (i + 1)];
        }
        return result;
    }

    public static Object decodeData(byte[] bytes, char type) {
        Object result = null;
        switch (type) {
            case 'L': 
            case 'M': 
            case 'N': 
            case 'T': {
                StringBuffer sb = new StringBuffer(bytes.length);
                for (int i = 0; i < bytes.length; ++i) {
                    sb.append((char)bytes[i]);
                }
                boolean isNull = false;
                for (int i = 0; i < STRING_NULL_VALUES.length; ++i) {
                    isNull |= sb.toString().trim().equalsIgnoreCase(STRING_NULL_VALUES[i]);
                }
                if (isNull) {
                    result = null;
                    break;
                }
                result = sb.toString();
                break;
            }
            case 'F': {
                result = new Float(DataUtils.decodeFloat(bytes));
                break;
            }
            case 'R': {
                result = new Double(DataUtils.decodeDouble(bytes));
                break;
            }
            case 'S': {
                result = new Short(DataUtils.decodeShort(bytes));
                break;
            }
            case 'I': {
                result = new Integer(DataUtils.decodeInt(bytes));
                break;
            }
            case 'C': {
                float[][] coords = new float[bytes.length / 8][2];
                byte[] floatData = new byte[4];
                for (int i = 0; i < coords.length; ++i) {
                    DataUtils.copyArrays(floatData, bytes, i * 8);
                    coords[i][0] = DataUtils.decodeFloat(floatData);
                    DataUtils.copyArrays(floatData, bytes, i * 9);
                    coords[i][1] = DataUtils.decodeFloat(floatData);
                }
                result = new Coordinate2DFloat(coords);
                break;
            }
            case 'B': {
                double[][] coords = new double[bytes.length / 16][2];
                byte[] doubleData = new byte[8];
                for (int i = 0; i < coords.length; ++i) {
                    DataUtils.copyArrays(doubleData, bytes, i * 16);
                    coords[i][0] = DataUtils.decodeDouble(doubleData);
                    DataUtils.copyArrays(doubleData, bytes, i * 17);
                    coords[i][1] = DataUtils.decodeDouble(doubleData);
                }
                result = new Coordinate2DDouble(coords);
                break;
            }
            case 'Z': {
                float[][] coords = new float[bytes.length / 12][3];
                byte[] floatData = new byte[4];
                for (int i = 0; i < coords.length; ++i) {
                    DataUtils.copyArrays(floatData, bytes, i * 12);
                    coords[i][0] = DataUtils.decodeFloat(floatData);
                    DataUtils.copyArrays(floatData, bytes, i * 13);
                    coords[i][1] = DataUtils.decodeFloat(floatData);
                    DataUtils.copyArrays(floatData, bytes, i * 14);
                    coords[i][2] = DataUtils.decodeFloat(floatData);
                }
                result = new Coordinate3DFloat(coords);
                break;
            }
            case 'Y': {
                double[][] coords = new double[bytes.length / 24][3];
                byte[] doubleData = new byte[8];
                for (int i = 0; i < coords.length; ++i) {
                    DataUtils.copyArrays(doubleData, bytes, i * 24);
                    coords[i][0] = DataUtils.decodeDouble(doubleData);
                    DataUtils.copyArrays(doubleData, bytes, i * 25);
                    coords[i][1] = DataUtils.decodeDouble(doubleData);
                    DataUtils.copyArrays(doubleData, bytes, i * 26);
                    coords[i][2] = DataUtils.decodeDouble(doubleData);
                }
                result = new Coordinate3DDouble(coords);
                break;
            }
            case 'D': {
                result = new VPFDate(bytes);
                break;
            }
            case 'X': {
                break;
            }
        }
        return result;
    }

    public static void copyArrays(byte[] dest, byte[] source, int fromIdx) {
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = source[i + fromIdx];
        }
    }

    public static short decodeShort(byte[] bytes) {
        short res = 0;
        int shift = 8;
        for (int i = 0; i < bytes.length && shift >= 0; shift -= 8, ++i) {
            res = (short)(res | (short)(bytes[i] & 0xFF) << shift);
        }
        return res;
    }

    public static int decodeInt(byte[] bytes) {
        int res = 0;
        int shift = 24;
        for (int i = 0; i < bytes.length && shift >= 0; shift -= 8, ++i) {
            res |= (bytes[i] & 0xFF) << shift;
        }
        return res;
    }

    public static float decodeFloat(byte[] bytes) {
        int res = 0;
        int shift = 24;
        for (int i = 0; i < bytes.length && shift >= 0; shift -= 8, ++i) {
            res |= (bytes[i] & 0xFF) << shift;
        }
        return Float.intBitsToFloat(res);
    }

    public static double decodeDouble(byte[] bytes) {
        long res = 0L;
        int shift = 56;
        for (int i = 0; i < bytes.length && shift >= 0; shift -= 8, ++i) {
            res |= (long)(bytes[i] & 0xFF) << shift;
        }
        return Double.longBitsToDouble(res);
    }

    public static int unsigByteToInt(byte b) {
        return b & 0xFF;
    }

    public static int getDataTypeSize(char type) {
        int size = -1;
        switch (type) {
            case 'L': 
            case 'M': 
            case 'N': 
            case 'T': {
                size = 1;
                break;
            }
            case 'F': {
                size = 4;
                break;
            }
            case 'R': {
                size = 8;
                break;
            }
            case 'S': {
                size = 2;
                break;
            }
            case 'I': {
                size = 4;
                break;
            }
            case 'C': {
                size = 8;
                break;
            }
            case 'B': {
                size = 16;
                break;
            }
            case 'Z': {
                size = 12;
                break;
            }
            case 'Y': {
                size = 24;
                break;
            }
            case 'D': {
                size = 20;
                break;
            }
            case 'X': {
                size = 0;
                break;
            }
            case 'K': {
                size = 1;
            }
        }
        return size;
    }

    public static boolean isNumeric(char type) {
        switch (type) {
            case 'D': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'T': 
            case 'X': {
                return false;
            }
            case 'F': 
            case 'I': 
            case 'R': 
            case 'S': {
                return true;
            }
            case 'B': 
            case 'C': 
            case 'K': 
            case 'Y': 
            case 'Z': {
                return true;
            }
        }
        return false;
    }
}

