/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.List;
import org.geotools.data.vpf.exc.VPFDataException;
import org.geotools.data.vpf.ifc.DataTypesDefinition;
import org.geotools.data.vpf.ifc.FileConstants;
import org.geotools.data.vpf.ifc.VPFHeader;
import org.geotools.data.vpf.ifc.VPFRow;
import org.geotools.data.vpf.io.CoordinateDouble;
import org.geotools.data.vpf.io.CoordinateFloat;
import org.geotools.data.vpf.io.TripletId;
import org.geotools.data.vpf.io.VariableIndexInputStream;
import org.geotools.data.vpf.io.VariableIndexRow;
import org.geotools.data.vpf.util.DataUtils;

public abstract class VPFInputStream
implements FileConstants,
DataTypesDefinition {
    protected RandomAccessFile input = null;
    protected VPFHeader header = null;
    protected String streamFile = null;
    private List rowsReadAhead = new LinkedList();
    private VPFInputStream variableIndex = null;
    private char byteOrder = (char)76;
    private String accessMode = "r";

    public VPFInputStream(String file) throws IOException {
        this.streamFile = file;
        this.input = new RandomAccessFile(this.streamFile, this.accessMode);
        this.header = this.readHeader();
        if (this.header.getRecordSize() < 0) {
            this.variableIndex = new VariableIndexInputStream(this.getVariableIndexFileName(), this.getByteOrder());
        }
    }

    public VPFInputStream(String file, char byteOrder) throws IOException {
        this.streamFile = file;
        this.byteOrder = byteOrder;
        this.input = new RandomAccessFile(this.streamFile, this.accessMode);
        this.header = this.readHeader();
    }

    public abstract VPFHeader readHeader() throws IOException;

    public abstract VPFRow readRow() throws IOException;

    public abstract int tableSize() throws IOException;

    public String getVariableIndexFileName() {
        if (this.streamFile.equals("fcs")) {
            return "fcz";
        }
        return this.streamFile.substring(0, this.streamFile.length() - 1) + "x";
    }

    public VPFHeader getHeader() {
        return this.header;
    }

    public char getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(char newByteOrder) {
        this.byteOrder = newByteOrder;
    }

    protected void unread(long bytes) throws IOException {
        this.input.seek(this.input.getFilePointer() - bytes);
    }

    protected void seek(long pos) throws IOException {
        this.input.seek(pos);
    }

    public void setPosition(long pos) throws IOException {
        if (this.header.getRecordSize() < 0) {
            VariableIndexRow varRow = (VariableIndexRow)this.variableIndex.readRow((int)pos);
            this.seek(varRow.getOffset());
        } else {
            this.seek((long)this.header.getLength() + (pos - 1L) * (long)this.header.getRecordSize());
        }
    }

    public VPFRow readRow(int index) throws IOException {
        this.setPosition(index);
        return this.readRow();
    }

    public List readAllRows() throws IOException {
        LinkedList<VPFRow> list = new LinkedList<VPFRow>();
        VPFRow row = this.readRow();
        while (row != null) {
            list.add(row);
            row = this.readRow();
        }
        return list;
    }

    public int readRows(VPFRow[] rows) throws IOException {
        int counter = 0;
        VPFRow row = this.readRow();
        while (row != null && counter < rows.length) {
            rows[counter++] = row;
            row = this.readRow();
        }
        return counter;
    }

    public int readRows(VPFRow[] rows, int fromIndex) throws IOException {
        this.setPosition(fromIndex);
        return this.readRows(rows);
    }

    protected char readChar() throws IOException {
        return (char)this.input.read();
    }

    protected String readString(String terminators) throws IOException {
        StringBuffer text = new StringBuffer();
        char ctrl = this.readChar();
        if (terminators.indexOf(ctrl) != -1) {
            if (ctrl == ':') {
                this.unread(1L);
            }
            return null;
        }
        while (terminators.indexOf(ctrl) == -1) {
            text.append(ctrl);
            ctrl = this.readChar();
        }
        if (text.toString().equals("-")) {
            return null;
        }
        return text.toString();
    }

    protected Object readVariableSizeData(char dataType) throws IOException {
        int instances = this.readInteger();
        return this.readFixedSizeData(dataType, instances);
    }

    protected Object readFixedSizeData(char dataType, int instancesCount) throws IOException {
        Object result = null;
        switch (dataType) {
            case 'L': 
            case 'M': 
            case 'N': 
            case 'T': {
                byte[] dataBytes = new byte[instancesCount * DataUtils.getDataTypeSize(dataType)];
                this.input.read(dataBytes);
                result = DataUtils.decodeData(dataBytes, dataType);
                break;
            }
            case 'F': {
                result = new Float(this.readFloat());
                break;
            }
            case 'R': {
                result = new Double(this.readDouble());
                break;
            }
            case 'S': {
                result = new Short(this.readShort());
                break;
            }
            case 'I': {
                result = new Integer(this.readInteger());
                break;
            }
            case 'X': {
                result = "NULL";
                break;
            }
            case 'K': {
                result = this.readTripletId();
                break;
            }
            case 'C': {
                result = this.readCoordFloat(instancesCount, 2);
                break;
            }
            case 'B': {
                result = this.readCoordDouble(instancesCount, 2);
                break;
            }
            case 'Z': {
                result = this.readCoordFloat(instancesCount, 3);
                break;
            }
            case 'Y': {
                result = this.readCoordDouble(instancesCount, 3);
                break;
            }
        }
        return result;
    }

    protected byte[] readNumber(int cnt) throws IOException {
        byte[] dataBytes = new byte[cnt];
        int res = this.input.read(dataBytes);
        if (res == cnt) {
            if (this.byteOrder == 'L') {
                dataBytes = DataUtils.toBigEndian(dataBytes);
            }
            return dataBytes;
        }
        if (res < 1) {
            throw new EOFException("No more bytes in input stream");
        }
        throw new VPFDataException("Inssufficient bytes in input stream : " + res);
    }

    protected short readShort() throws IOException {
        return DataUtils.decodeShort(this.readNumber(2));
    }

    protected int readInteger() throws IOException {
        return DataUtils.decodeInt(this.readNumber(4));
    }

    protected float readFloat() throws IOException {
        return DataUtils.decodeFloat(this.readNumber(4));
    }

    protected double readDouble() throws IOException {
        return DataUtils.decodeDouble(this.readNumber(8));
    }

    protected TripletId readTripletId() throws IOException {
        byte tripletDef = (byte)this.input.read();
        int dataSize = TripletId.calculateDataSize(tripletDef);
        byte[] tripletData = new byte[dataSize + 1];
        tripletData[0] = tripletDef;
        if (dataSize > 0) {
            this.input.read(tripletData, 1, dataSize);
        }
        return new TripletId(tripletData);
    }

    protected CoordinateFloat readCoordFloat(int instancesCount, int dim) throws IOException {
        float[][] data = new float[instancesCount][dim];
        for (int i = 0; i < instancesCount; ++i) {
            for (int j = 0; j < dim; ++j) {
                data[i][j] = this.readFloat();
            }
        }
        return new CoordinateFloat(data);
    }

    protected CoordinateDouble readCoordDouble(int instancesCount, int dim) throws IOException {
        double[][] data = new double[instancesCount][dim];
        for (int i = 0; i < instancesCount; ++i) {
            for (int j = 0; j < dim; ++j) {
                data[i][j] = this.readDouble();
            }
        }
        return new CoordinateDouble(data);
    }

    public int availableRows() {
        return this.rowsReadAhead != null ? this.rowsReadAhead.size() : 0;
    }

    public void close() throws IOException {
        this.input.close();
        this.input = null;
    }

    protected void condeb(String msg) {
        System.out.println(msg);
    }
}

