/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.io;

public class TripletId {
    private byte[] rawData = null;

    public TripletId(byte[] data) {
        this.rawData = data;
    }

    public String toString() {
        return this.rawData == null ? "NULL" : new String(this.rawData, 1, this.rawData.length - 1);
    }

    public static int calculateDataSize(byte definition) {
        int[] pieces = new int[]{definition >> 2 & 3, definition >> 4 & 3, definition >> 6 & 3};
        int size = 0;
        block6: for (int i = 0; i < pieces.length; ++i) {
            switch (pieces[i]) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    ++size;
                    continue block6;
                }
                case 2: {
                    size += 2;
                    continue block6;
                }
                case 3: {
                    size += 4;
                    continue block6;
                }
                default: {
                    System.out.println("Tripled id size decoding error");
                    System.out.println("tripled definition: " + definition);
                    System.out.println("piece 0: " + pieces[0]);
                    System.out.println("piece 1: " + pieces[1]);
                    System.out.println("piece 2: " + pieces[2]);
                }
            }
        }
        return size;
    }
}

