/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.io;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.geotools.data.vpf.exc.VPFHeaderFormatException;
import org.geotools.data.vpf.ifc.DataTypesDefinition;
import org.geotools.data.vpf.ifc.FileConstants;
import org.geotools.data.vpf.ifc.VPFHeader;
import org.geotools.data.vpf.ifc.VPFRow;
import org.geotools.data.vpf.io.RowField;
import org.geotools.data.vpf.io.TableColumnDef;
import org.geotools.data.vpf.io.TableHeader;
import org.geotools.data.vpf.io.TableRow;
import org.geotools.data.vpf.io.VPFInputStream;
import org.geotools.data.vpf.util.DataUtils;

public class TableInputStream
extends VPFInputStream
implements FileConstants,
DataTypesDefinition {
    private static final String EMPTY_STRING = "";
    public static final int AHEAD_BUFFER_SIZE = 0;

    public TableInputStream(String file) throws IOException {
        super(file);
    }

    public TableInputStream(String file, char byteOrder) throws IOException {
        super(file, byteOrder);
    }

    public VPFHeader readHeader() throws VPFHeaderFormatException, IOException {
        char order;
        byte[] fourBytes = new byte[4];
        this.input.read(fourBytes);
        char ctrl = order = this.readChar();
        if (order == ';') {
            order = 'L';
        } else {
            ctrl = this.readChar();
        }
        if (order == 'L') {
            fourBytes = DataUtils.toBigEndian(fourBytes);
        }
        int length = DataUtils.decodeInt(fourBytes);
        if (ctrl != ';') {
            throw new VPFHeaderFormatException("Header format does not fit VPF file definition.");
        }
        String description = this.readString(";");
        String narrativeTable = this.readString(";");
        ArrayList<TableColumnDef> colDefs = new ArrayList<TableColumnDef>();
        TableColumnDef colDef = this.readColumnDef();
        while (colDef != null) {
            colDefs.add(colDef);
            ctrl = this.readChar();
            if (ctrl != ':') {
                throw new VPFHeaderFormatException("Header format does not fit VPF file definition.");
            }
            colDef = this.readColumnDef();
        }
        if (colDefs.size() == 0) {
            colDefs = null;
        }
        return new TableHeader(length, order, description, narrativeTable, colDefs);
    }

    private TableColumnDef readColumnDef() throws VPFHeaderFormatException, IOException, NumberFormatException {
        char ctrl = this.readChar();
        if (ctrl == ';') {
            return null;
        }
        String name = ctrl + this.readString("=");
        char type = this.readChar();
        ctrl = this.readChar();
        if (ctrl != ',') {
            throw new VPFHeaderFormatException("Header format does not fit VPF file definition.");
        }
        String elemStr = this.readString(",").trim();
        if (elemStr.equals("*")) {
            elemStr = "-1";
        }
        int elements = Integer.parseInt(elemStr);
        char key = this.readChar();
        ctrl = this.readChar();
        if (ctrl != ',') {
            throw new VPFHeaderFormatException("Header format does not fit VPF file definition.");
        }
        String colDesc = this.readString(",:");
        String descTableName = this.readString(",:");
        String indexFile = this.readString(",:");
        String narrTable = this.readString(",:");
        return new TableColumnDef(name, type, elements, key, colDesc, descTableName, indexFile, narrTable);
    }

    public VPFRow readRow() throws IOException {
        List rowsDef = ((TableHeader)this.header).getColumnDefs();
        RowField[] fieldsArr = new RowField[rowsDef.size()];
        HashMap<String, RowField> fieldsMap = new HashMap<String, RowField>();
        for (int i = 0; i < rowsDef.size(); ++i) {
            RowField field;
            TableColumnDef tcd = (TableColumnDef)rowsDef.get(i);
            Object value = null;
            try {
                value = tcd.getColumnSize() < 0 ? this.readVariableSizeData(tcd.getType()) : this.readFixedSizeData(tcd.getType(), tcd.getElementsNumber());
            }
            catch (EOFException e) {
                return null;
            }
            fieldsArr[i] = field = new RowField(value, tcd.getType());
            fieldsMap.put(tcd.getName(), field);
        }
        return new TableRow(fieldsArr, fieldsMap);
    }

    public int tableSize() {
        return -1;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Put valid file name as parameter.");
            System.exit(1);
        }
        TableInputStream testInput = new TableInputStream(args[0]);
        TableHeader testHeader = (TableHeader)testInput.getHeader();
        System.out.println(testHeader.toString());
        List fieldDefs = testHeader.getColumnDefs();
        TableRow row = (TableRow)testInput.readRow();
        while (row != null) {
            for (int i = 0; i < fieldDefs.size(); ++i) {
                TableColumnDef tcd = (TableColumnDef)fieldDefs.get(i);
                System.out.println(tcd.getName() + "=" + row.get(i).toString());
            }
            row = (TableRow)testInput.readRow();
        }
    }
}

