/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.geotools.data.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceFactorySpi;
import org.geotools.data.vpf.VPFDataSource;

public class VPFDataSourceFactory
implements DataSourceFactorySpi {
    public DataSource createDataSource(Map hashMap) throws DataSourceException {
        if (!this.canProcess(hashMap)) {
            return null;
        }
        try {
            File file = new File(new URI((String)hashMap.get("url")));
            try {
                return new VPFDataSource(file);
            }
            catch (IOException e) {
                throw new DataSourceException("Unable to open VPF data base " + file, (Throwable)e);
            }
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String getDescription() {
        return "Vector Product Format data source implementation.";
    }

    public boolean canProcess(Map hashMap) {
        if (!hashMap.containsKey("url")) {
            return false;
        }
        String url = (String)hashMap.get("url");
        try {
            File file = new File(new File(new URI(url)), "dht");
            return file.exists() && !file.isDirectory();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

