/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.geotools.data.vpf.ifc.FileConstants;
import org.geotools.data.vpf.io.TableInputStream;
import org.geotools.data.vpf.io.TableRow;

public class VPFDataBase
implements FileConstants {
    private File directory = null;
    private TableRow dataBaseInfo = null;
    private TableRow[] libraries = null;
    private TableRow[][] coverages = null;

    public VPFDataBase(File directory) throws IOException {
        this.directory = directory;
        String vpfTableName = new File(directory, "dht").toString();
        TableInputStream vpfTable = new TableInputStream(vpfTableName);
        this.dataBaseInfo = (TableRow)vpfTable.readRow();
        vpfTable.close();
        vpfTableName = new File(directory, "lat").toString();
        vpfTable = new TableInputStream(vpfTableName);
        List list = vpfTable.readAllRows();
        vpfTable.close();
        this.libraries = list.toArray(new TableRow[list.size()]);
        this.coverages = new TableRow[this.libraries.length][];
        for (int i = 0; i < this.coverages.length; ++i) {
            this.coverages[i] = null;
        }
    }

    public double getMinX() {
        double xmin = this.libraries[0].get("xmin").getAsDouble();
        for (int i = 1; i < this.libraries.length; ++i) {
            double temp = this.libraries[i].get("xmin").getAsDouble();
            xmin = Math.min(xmin, temp);
        }
        return xmin;
    }

    public double getMinY() {
        double ymin = this.libraries[0].get("ymin").getAsDouble();
        for (int i = 1; i < this.libraries.length; ++i) {
            double temp = this.libraries[i].get("ymin").getAsDouble();
            ymin = Math.min(ymin, temp);
        }
        return ymin;
    }

    public double getMaxX() {
        double xmax = this.libraries[0].get("xmax").getAsDouble();
        for (int i = 1; i < this.libraries.length; ++i) {
            double temp = this.libraries[i].get("xmax").getAsDouble();
            xmax = Math.min(xmax, temp);
        }
        return xmax;
    }

    public double getMaxY() {
        double ymax = this.libraries[0].get("ymax").getAsDouble();
        for (int i = 1; i < this.libraries.length; ++i) {
            double temp = this.libraries[i].get("ymax").getAsDouble();
            ymax = Math.min(ymax, temp);
        }
        return ymax;
    }

    public TableRow[] getCoverages(int libId) throws IOException {
        if (libId < 0 && libId >= this.coverages.length) {
            return null;
        }
        if (this.coverages[libId] == null) {
            String libCover = this.libraries[libId].get("library_name").getAsString();
            String vpfTableName = new File(new File(this.directory, libCover), "cat").toString();
            TableInputStream vpfTable = new TableInputStream(vpfTableName);
            List list = vpfTable.readAllRows();
            vpfTable.close();
            this.coverages[libId] = list.toArray(new TableRow[list.size()]);
        }
        return this.coverages[libId];
    }

    public static void main(String[] args) {
    }
}

