/*
 * Decompiled with CFR 0.152.
 */
package de.soldin.gt2jump.readwrite;

import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import de.soldin.gt2jump.readwrite.FCConverter;
import de.soldin.gt2jump.readwrite.GT2ReaderWriterPlugin;
import javax.swing.JPopupMenu;
import org.geotools.data.DataSourceMetaData;

public class GT2WriterPlugin
extends GT2ReaderWriterPlugin {
    private final String NAME = "Save Dataset with GT2";

    public String getName() {
        return "Save Dataset with GT2";
    }

    public void initialize(PlugInContext context) {
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        EnableCheckFactory checkFactory = new EnableCheckFactory(context.getWorkbenchContext());
        MultiEnableCheck savecheck = new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
        featureInstaller.addMainMenuItem((PlugIn)this, "File", "Save Dataset with GT2", null, (EnableCheck)savecheck);
        TitledPopupMenu layerNamePopupMenu = context.getWorkbenchContext().getWorkbench().getFrame().getLayerNamePopupMenu();
        context.getFeatureInstaller().addPopupMenuItem((JPopupMenu)layerNamePopupMenu, (PlugIn)this, "Save Dataset with GT2", false, null, (EnableCheck)savecheck);
    }

    public void exec(TaskMonitor monitor, PlugInContext context) throws Exception {
        if (this.isCancelled()) {
            return;
        }
        String sup_text = "Datasource supports... ";
        StringBuffer mode_text = new StringBuffer();
        this.report(mode_text.toString());
        DataSourceMetaData ds_m = this.ds.getMetaData();
        boolean writesupport = false;
        if (ds_m.supportsSetFeatures()) {
            writesupport = true;
            mode_text.append(" setFeatures()");
            this.report(String.valueOf(sup_text) + mode_text.toString());
        }
        if (ds_m.supportsAdd()) {
            writesupport = true;
            mode_text.append(" addFeatures()");
            this.report(String.valueOf(sup_text) + mode_text.toString());
        }
        if (ds_m.supportsModify()) {
            writesupport = true;
            mode_text.append(" modifyFeatures()");
            this.report(String.valueOf(sup_text) + mode_text.toString());
        }
        if (!writesupport) {
            writesupport = true;
            mode_text.append(" currently no write operation supported.");
            context.getLayerViewPanel().getContext().warnUser("Write failed! Datasource does not currently support writing.");
            this.report(mode_text.toString());
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        this.report("Retrieve dataset from layer...");
        Layer layer = context.getSelectedLayer(0);
        if (layer == null) {
            context.getLayerViewPanel().getContext().warnUser("No layer selected!");
            return;
        }
        FeatureCollection features = layer.getFeatureCollectionWrapper().getUltimateWrappee();
        if (this.isCancelled()) {
            return;
        }
        this.report("Convert dataset...");
        org.geotools.feature.FeatureCollection gt2_features = FCConverter.convert(features);
        if (this.isCancelled()) {
            return;
        }
        this.report("Save dataset...");
        try {
            this.ds.setFeatures(gt2_features);
        }
        catch (UnsupportedOperationException e) {
            try {
                this.ds.addFeatures(gt2_features);
            }
            catch (UnsupportedOperationException e1) {
                context.getLayerViewPanel().getContext().warnUser("Write failed! Reason setF(),add() are unsupported.");
            }
        }
    }
}

