/*
 * Decompiled with CFR 0.152.
 */
package de.soldin.gt2jump.readwrite;

import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import de.soldin.gt2jump.readwrite.GT2DatasourceFactoryChooser;
import java.awt.Frame;
import java.awt.Point;
import javax.swing.JInternalFrame;
import org.geotools.data.DataSource;

public abstract class GT2ReaderWriterPlugin
implements ThreadedPlugIn {
    protected GT2DatasourceFactoryChooser f_ch;
    protected TaskMonitor monitor;
    protected PlugInContext context;
    protected DataSource ds;
    protected String ds_name;

    public abstract void initialize(PlugInContext var1);

    public boolean execute(PlugInContext context) throws Exception {
        Point location;
        JInternalFrame frame;
        if (this.f_ch == null) {
            this.f_ch = new GT2DatasourceFactoryChooser((Frame)context.getWorkbenchFrame(), this.getName());
        }
        if ((frame = context.getActiveInternalFrame()) instanceof TaskFrame) {
            location = frame.getLocationOnScreen();
        } else {
            frame = context.getWorkbenchFrame();
            location = frame.getLocationOnScreen();
        }
        location.translate(125, 25);
        this.f_ch.dialog.setLocation(location);
        do {
            try {
                this.ds = this.f_ch.choose();
                this.ds_name = this.f_ch.getDSName();
            }
            catch (Exception exc) {
                context.getErrorHandler().handleThrowable((Throwable)exc);
            }
            catch (Error err) {
                context.getErrorHandler().handleThrowable((Throwable)err);
            }
        } while (this.ds == null && !this.isCancelled());
        if (this.ds == null && !this.isCancelled()) {
            context.getLayerViewPanel().getContext().warnUser("No valid datasource. Please check parameters!");
            return false;
        }
        return true;
    }

    protected void report(String msg) {
        if (this.monitor != null) {
            this.monitor.report(msg);
        }
    }

    protected boolean isCancelled() {
        boolean thread_cancelled;
        boolean bl = thread_cancelled = this.monitor == null ? false : this.monitor.isCancelRequested();
        return thread_cancelled || this.f_ch.isCancelled();
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.monitor = monitor;
        this.monitor.allowCancellationRequests();
        this.context = context;
        this.exec(monitor, context);
        this.monitor = null;
        this.context = null;
    }

    public abstract void exec(TaskMonitor var1, PlugInContext var2) throws Exception;

    public abstract String getName();
}

