/*
 * Decompiled with CFR 0.152.
 */
package de.soldin.gt2jump.readwrite;

import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import de.soldin.gt2jump.readwrite.FCConverter;
import de.soldin.gt2jump.readwrite.GT2ReaderWriterPlugin;
import java.util.Collection;
import javax.swing.JPopupMenu;

public class GT2ReaderPlugin
extends GT2ReaderWriterPlugin {
    private final String NAME = "Load Dataset with GT2";

    public String getName() {
        return "Load Dataset with GT2";
    }

    public void initialize(PlugInContext context) {
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuItem((PlugIn)this, "File", "Load Dataset with GT2", null, null);
        TitledPopupMenu categoryPopups = context.getWorkbenchContext().getWorkbench().getFrame().getCategoryPopupMenu();
        context.getFeatureInstaller().addPopupMenuItem((JPopupMenu)categoryPopups, (PlugIn)this, "Load Dataset with GT2", false, null, null);
    }

    public void exec(TaskMonitor monitor, PlugInContext context) throws Exception {
        Category category;
        if (this.isCancelled()) {
            return;
        }
        this.report("Detect category...");
        Collection categories = context.getLayerNamePanel().getSelectedCategories();
        if (categories.isEmpty()) {
            categories = context.getLayerManager().getCategories();
            if (categories.isEmpty()) {
                context.getLayerViewPanel().getContext().warnUser("Please create a category to put dataset in!");
                return;
            }
            context.getLayerViewPanel().getContext().warnUser("No category selected! Put dataset in first category available.");
            category = (Category)categories.toArray()[0];
        } else {
            category = (Category)categories.toArray()[0];
        }
        if (this.isCancelled()) {
            return;
        }
        this.report("Load Dataset from '" + this.ds_name + "' now...");
        org.geotools.feature.FeatureCollection gt2_features = this.ds.getFeatures();
        if (this.isCancelled()) {
            return;
        }
        this.report("Convert Dataset now...");
        FeatureCollection features = FCConverter.convert(gt2_features);
        if (this.isCancelled()) {
            return;
        }
        this.report("Add Layer now...");
        Layer layer = context.getLayerManager().addLayer(category.getName(), this.ds_name, features);
    }
}

