/*
 * Decompiled with CFR 0.152.
 */
package de.soldin.gt2jump.readwrite;

import de.soldin.gt2jump.readwrite.GT2ReaderWriterExtension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.geotools.data.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceFactorySpi;
import org.geotools.factory.FactoryFinder;
import org.swixml.SwingEngine;
import org.swixml.TagLibrary;

public class GT2DatasourceFactoryChooser
extends SwingEngine
implements ActionListener,
ItemListener {
    private static String templates = "de/soldin/gt2jump/readwrite/";
    public JPanel p_main;
    public JPanel p_attributes;
    public JPanel p_file;
    public JPanel p_db;
    public JPanel p_error;
    public JTextPane errormsg;
    public JTextField user;
    public JTextField passwd;
    public JTextField host;
    public JTextField port;
    public JTextField table;
    public JFileChooser file;
    public JComboBox ds_factorychooser;
    JDialog dialog;
    public static int DS_FILE = 0;
    public static int DS_DB = 1;
    public static int DS_ERROR = 2;
    private String ds_name;
    private HashMap ds_factories = new HashMap();
    private DataSourceFactorySpi ds_f_selected;
    private Map ds_f_params;
    private boolean cancelled = false;
    public JTextField database;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public GT2DatasourceFactoryChooser() throws Exception {
        this(new Frame(), "", GT2DatasourceFactoryChooser.getAvailableDS());
    }

    public GT2DatasourceFactoryChooser(Frame owner) throws Exception {
        this(owner, "", GT2DatasourceFactoryChooser.getAvailableDS());
    }

    public GT2DatasourceFactoryChooser(Frame owner, String title) throws Exception {
        this(owner, title, GT2DatasourceFactoryChooser.getAvailableDS());
    }

    public GT2DatasourceFactoryChooser(Frame owner, String title, HashMap in_ds_factories) throws Exception {
        TagLibrary tagLibrary = this.getTaglib();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.JFileChooser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        tagLibrary.registerTag("filechooser", (Class)clazz);
        this.ds_factories = in_ds_factories;
        this.dialog = new JDialog(owner, title, true);
        this.dialog.getContentPane().setLayout(new GridBagLayout());
        this.p_file = (JPanel)this.render(String.valueOf(templates) + "filepanel.xml");
        this.p_db = (JPanel)this.render(String.valueOf(templates) + "dbpanel.xml");
        this.p_error = (JPanel)this.render(String.valueOf(templates) + "errorpanel.xml");
        this.p_main = (JPanel)this.render(String.valueOf(templates) + "dialog.xml");
        this.ds_factorychooser.addItemListener(this);
        this.setFactories(in_ds_factories);
        this.setActionListener(this.p_main, this);
        this.dialog.getContentPane().add(this.p_main);
        this.dialog.pack();
    }

    public void setLocation(int x, int y) {
        this.dialog.setLocation(x, y);
    }

    public void setTitle(String title) {
        this.dialog.setTitle(title);
    }

    public void setFactories(HashMap in_ds_factories) {
        this.ds_factories = in_ds_factories;
        this.ds_factorychooser.removeAllItems();
        Object[] keys = this.ds_factories.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            this.ds_factorychooser.addItem(keys[i]);
            ++i;
        }
        if (this.ds_factorychooser.getItemCount() > 0) {
            this.ds_factorychooser.setSelectedItem(this.ds_factorychooser.getItemAt(0));
        }
    }

    public DataSource choose() throws Exception {
        this.cancelled = false;
        this.ds_name = "untitled";
        this.file.rescanCurrentDirectory();
        this.file.setSelectedFile(null);
        this.file.setSelectedFiles(new File[0]);
        this.file.repaint();
        this.dialog.setVisible(true);
        if (this.cancelled) {
            return null;
        }
        if (this.ds_f_selected != null) {
            Map ds_f_params = this.getDSParamMap();
            if (ds_f_params.containsKey("dbtype")) {
                String[] words = (String[])ds_f_params.get("dbtype");
                int i = 0;
                while (i < words.length) {
                    String word = words[i];
                    HashMap<String, String> foo = new HashMap<String, String>(ds_f_params);
                    foo.put("dbtype", word);
                    DataSource ds = this.ds_f_selected.createDataSource(foo);
                    if (ds != null) {
                        return ds;
                    }
                    ++i;
                }
            } else {
                return this.ds_f_selected.createDataSource(ds_f_params);
            }
        }
        return null;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getDSName() {
        return this.ds_name != null ? this.ds_name : "untitled";
    }

    public static void main(String[] args) throws Exception {
        GT2DatasourceFactoryChooser fch = new GT2DatasourceFactoryChooser();
        fch.setLocation(100, 200);
        fch.setTitle("Ich bin ein Bibabutzemann");
        try {
            System.out.println(fch.choose());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("AC_OK".equals(command)) {
            this.file.approveSelection();
            this.dialog.setVisible(false);
        } else if ("AC_CANCEL".equals(command)) {
            this.cancelled = true;
            this.dialog.setVisible(false);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.p_attributes.removeAll();
            String key = (String)e.getItem();
            try {
                this.ds_f_selected = (DataSourceFactorySpi)this.ds_factories.get(key);
                if (this.ds_f_selected == null) {
                    System.err.println("empty item selected");
                    return;
                }
                if (GT2DatasourceFactoryChooser.detectType(this.ds_f_selected) == DS_DB) {
                    this.p_attributes.add(this.p_db);
                } else {
                    this.p_attributes.add(this.p_file);
                }
            }
            catch (ClassCastException cce) {
                String errmsg;
                try {
                    Exception exc = (Exception)this.ds_factories.get(key);
                    errmsg = GT2DatasourceFactoryChooser.throwableToString(exc);
                }
                catch (ClassCastException cce2) {
                    try {
                        Error err = (Error)this.ds_factories.get(key);
                        errmsg = GT2DatasourceFactoryChooser.throwableToString(err);
                    }
                    catch (ClassCastException cce3) {
                        errmsg = "Unknown Error occured:\n" + this.ds_factories.get(key).toString();
                    }
                }
                this.errormsg.setText(errmsg);
                this.p_attributes.add(this.p_error);
            }
            this.p_attributes.validate();
            this.dialog.pack();
        }
    }

    public Map getDSParamMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.ds_f_selected == null) {
            return params;
        }
        if (GT2DatasourceFactoryChooser.detectType(this.ds_f_selected) == DS_DB) {
            Pattern word_pattern = Pattern.compile("[\\s]+");
            String[] words = word_pattern.split(this.ds_f_selected.getDescription());
            int i = 0;
            while (i < words.length) {
                words[i] = words[i].toLowerCase();
                ++i;
            }
            params.put("dbtype", words);
            params.put("host", this.host.getText().toString());
            params.put("port", this.port.getText().toString());
            params.put("user", this.user.getText().toString());
            params.put("passwd", this.passwd.getText().toString());
            params.put("database", this.database.getText().toString());
            params.put("table", this.table.getText().toString());
            this.ds_name = (String)params.get("table");
        } else {
            try {
                if (this.file.getSelectedFiles().length > 0) {
                    params.put("url", this.file.getSelectedFiles()[0].toURL().toString());
                    this.ds_name = new File(new URL((String)params.get("url")).getFile()).getName();
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return params;
    }

    public static HashMap getAvailableDS() throws DataSourceException {
        HashMap<String, Object> ds_factories = new HashMap<String, Object>();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.geotools.data.DataSourceFactorySpi");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator it = FactoryFinder.factories((Class)clazz, (ClassLoader)GT2ReaderWriterExtension.createLoader());
        while (it.hasNext()) {
            try {
                DataSourceFactorySpi ds = (DataSourceFactorySpi)it.next();
                ds_factories.put(ds.getDescription(), ds);
            }
            catch (Exception e) {
                ds_factories.put("Exception: " + (e.getMessage() != null ? e.getMessage().subSequence(0, 50) : ""), e);
            }
            catch (Error e) {
                ds_factories.put("Error: " + (e.getMessage() != null ? e.getMessage().subSequence(0, 50) : ""), e);
            }
        }
        return (HashMap)ds_factories.clone();
    }

    public static int detectType(DataSourceFactorySpi ds) {
        String desc = ds.getDescription();
        Pattern db_pattern = Pattern.compile(".*Database.*", 66);
        Matcher m = db_pattern.matcher(desc);
        if (m.matches()) {
            return DS_DB;
        }
        return DS_FILE;
    }

    public static String throwableToString(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        StringBuffer buffy = new StringBuffer();
        do {
            buffy.append("\nMESSAGE:\t" + t.toString() + "\n");
            buffy.append("\nSTACK:\n");
            StackTraceElement[] stackies = t.getStackTrace();
            int i = 0;
            while (i < stackies.length) {
                StackTraceElement stacky = stackies[i];
                buffy.append(stacky + "\n");
                ++i;
            }
        } while ((t = t.getCause()) != null);
        return buffy.toString();
    }

    private JTextField getDatabase() {
        return this.database;
    }

    private void setDatabase(JTextField database) {
        this.database = database;
    }
}

