/*
 * Decompiled with CFR 0.152.
 */
package de.soldin.gt2jump.readwrite;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.Iterator;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;

public class FCConverter {
    public static org.geotools.feature.FeatureCollection convert(FeatureCollection jump_features) throws Exception {
        org.geotools.feature.FeatureCollection gt2_features = FeatureCollections.newCollection();
        Iterator iter = jump_features.iterator();
        while (iter.hasNext()) {
            Feature jump_feature = (Feature)iter.next();
            FeatureSchema jump_fschema = jump_feature.getSchema();
            FeatureTypeFactory gt2_ftype_factory = FeatureTypeFactory.newInstance((String)Integer.toString(jump_feature.getID()));
            Object[] gt2_attribs = new Object[jump_fschema.getAttributeCount()];
            int i = 0;
            while (i < jump_fschema.getAttributeCount()) {
                AttributeType a_type = jump_fschema.getAttributeType(i);
                org.geotools.feature.AttributeType gt2_a_type = AttributeTypeFactory.newAttributeType((String)jump_fschema.getAttributeName(i), (Class)a_type.toJavaClass());
                gt2_ftype_factory.addType(gt2_a_type);
                gt2_attribs[i] = jump_feature.getAttribute(i);
                ++i;
            }
            FeatureType gt2_ftype = gt2_ftype_factory.getFeatureType();
            String fid = Integer.toString(jump_feature.getID());
            org.geotools.feature.Feature gt2_feature = gt2_ftype.create(gt2_attribs, fid);
            gt2_features.add((Object)gt2_feature);
        }
        return gt2_features;
    }

    public static FeatureCollection convert(org.geotools.feature.FeatureCollection gt2_features) {
        FeatureDataset result = null;
        Object jump_fctype = null;
        Iterator iter = gt2_features.iterator();
        while (iter.hasNext()) {
            org.geotools.feature.Feature gt2_feature = (org.geotools.feature.Feature)iter.next();
            FeatureSchema jump_fschema = new FeatureSchema();
            FeatureType gt2_ftype = gt2_feature.getFeatureType();
            int i = 0;
            while (i < gt2_ftype.getAttributeCount()) {
                org.geotools.feature.AttributeType a_type = gt2_ftype.getAttributeType(i);
                if (a_type.isGeometry()) {
                    jump_fschema.addAttribute(a_type.getName(), AttributeType.GEOMETRY);
                } else {
                    jump_fschema.addAttribute(a_type.getName(), AttributeType.toAttributeType((Class)a_type.getType()));
                }
                ++i;
            }
            BasicFeature jump_feature = new BasicFeature(jump_fschema);
            Object[] gt2_attribs = gt2_feature.getAttributes(null);
            int i2 = 0;
            while (i2 < gt2_attribs.length) {
                Object attrib = gt2_attribs[i2];
                jump_feature.setAttribute(jump_fschema.getAttributeIndex(jump_fschema.getAttributeName(i2)), attrib);
                ++i2;
            }
            if (result == null) {
                result = new FeatureDataset(jump_fschema);
            }
            result.add((Feature)jump_feature);
        }
        if (result == null) {
            result = new FeatureDataset(new FeatureSchema());
        }
        gt2_features = null;
        System.gc();
        return result;
    }

    public static FeatureSchema convert(FeatureType gt2_ftype) {
        FeatureSchema jump_fschema = new FeatureSchema();
        int i = 0;
        while (i < gt2_ftype.getAttributeCount()) {
            org.geotools.feature.AttributeType a_type = gt2_ftype.getAttributeType(i);
            if (a_type.isGeometry()) {
                jump_fschema.addAttribute(a_type.getName(), AttributeType.GEOMETRY);
            } else {
                jump_fschema.addAttribute(a_type.getName(), AttributeType.toAttributeType((Class)a_type.getType()));
            }
            ++i;
        }
        return jump_fschema;
    }
}

