/*
 * Decompiled with CFR 0.152.
 */
package de.soldin.gt2jump;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;

public class UndoableSetGeometry
extends AbstractUndoableEdit
implements Collection {
    private Collection actions = new Vector();
    private String name;
    private Layer layer;
    private HashMap proposed_geoms = new HashMap();
    private HashMap original_geoms = new HashMap();

    public void redo() {
        this.execute();
        super.redo();
    }

    public void undo() {
        this.unexecute();
        super.undo();
    }

    public String getPresentationName() {
        return this.getName();
    }

    public String getUndoPresentationName() {
        return this.getName();
    }

    public String getRedoPresentationName() {
        return this.getName();
    }

    public UndoableSetGeometry(Layer layer, String name) {
        this.layer = layer;
        this.name = String.valueOf(name) + " (Layer: " + layer.getName() + ")";
    }

    public UndoableSetGeometry(String name) {
        this.name = name;
    }

    public void execute() {
        if (this.layer != null) {
            List features = this.layer.getFeatureCollectionWrapper().getFeatures();
            ArrayList<Feature> modifiedFeatures = new ArrayList<Feature>();
            ArrayList<Object> modifiedFeaturesOldClones = new ArrayList<Object>();
            Iterator iter = this.proposed_geoms.keySet().iterator();
            while (iter.hasNext()) {
                Feature feature = (Feature)iter.next();
                Geometry new_geom = (Geometry)this.proposed_geoms.get(feature);
                Geometry old_geom = feature.getGeometry();
                this.original_geoms.put(feature, old_geom);
                modifiedFeatures.add(feature);
                modifiedFeaturesOldClones.add(feature.clone());
                feature.setGeometry(new_geom);
            }
            this.refreshUI(modifiedFeatures, modifiedFeaturesOldClones);
        } else {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                UndoableSetGeometry transformation = (UndoableSetGeometry)iter.next();
                transformation.execute();
            }
        }
    }

    public void unexecute() {
        if (this.layer != null && this.original_geoms.size() > 0) {
            List features = this.layer.getFeatureCollectionWrapper().getFeatures();
            ArrayList<Feature> modifiedFeatures = new ArrayList<Feature>();
            ArrayList<Object> modifiedFeaturesOldClones = new ArrayList<Object>();
            Iterator iter = this.original_geoms.keySet().iterator();
            while (iter.hasNext()) {
                Feature feature = (Feature)iter.next();
                Geometry new_geom = (Geometry)this.original_geoms.get(feature);
                modifiedFeatures.add(feature);
                modifiedFeaturesOldClones.add(feature.clone());
                feature.setGeometry(new_geom);
            }
            this.original_geoms.clear();
            this.refreshUI(modifiedFeatures, modifiedFeaturesOldClones);
        } else {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                UndoableSetGeometry transformation = (UndoableSetGeometry)iter.next();
                transformation.unexecute();
            }
        }
    }

    private void refreshUI(ArrayList modifiedFeatures, ArrayList modifiedFeaturesOldClones) {
        if (this.layer != null) {
            Layer.tryToInvalidateEnvelope((Layer)this.layer);
            if (!modifiedFeatures.isEmpty()) {
                this.layer.getLayerManager().fireGeometryModified((Collection)modifiedFeatures, this.layer, (Collection)modifiedFeaturesOldClones);
            }
        }
    }

    public String getName() {
        String out = "";
        if (this.layer == null) {
            Iterator iter = this.actions.iterator();
            while (iter.hasNext()) {
                out = String.valueOf(out) + (out.length() > 0 ? ", " : "") + ((UndoableSetGeometry)iter.next()).getName();
            }
        }
        return String.valueOf(this.name) + ": " + out;
    }

    public void setGeom(Feature feature, Geometry geom) {
        this.proposed_geoms.put(feature, geom);
    }

    public Geometry getGeom(Feature in_feature) {
        List features = this.layer.getFeatureCollectionWrapper().getFeatures();
        Feature feature = (Feature)features.get(features.indexOf(in_feature));
        return (Geometry)feature.getGeometry().clone();
    }

    public boolean add(UndoableSetGeometry t) {
        return this.actions.add(t);
    }

    public int size() {
        return this.actions.size();
    }

    public void clear() {
        this.actions.clear();
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public Object[] toArray() {
        return this.actions.toArray();
    }

    public boolean add(Object o) {
        return this.actions.add(o);
    }

    public boolean contains(Object o) {
        return this.actions.contains(o);
    }

    public boolean remove(Object o) {
        return this.actions.remove(o);
    }

    public boolean addAll(Collection c) {
        return this.actions.addAll(c);
    }

    public boolean containsAll(Collection c) {
        return this.actions.containsAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.actions.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.actions.retainAll(c);
    }

    public Iterator iterator() {
        return this.actions.iterator();
    }

    public Object[] toArray(Object[] a) {
        return this.actions.toArray(a);
    }
}

