/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.tiff;

import com.sun.imageio.plugins.tiff.TIFFImageReader;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class TIFFImageReaderSpi
extends ImageReaderSpi {
    private static final int kTiffMagicNumber = 42;
    private static final String vendorName = "Apple computer Inc.";
    private static final String version = "1.0";
    private static final String[] names = new String[]{"tiff"};
    private static final String[] suffixes = new String[]{"tiff", "TIFF", "tif", "TIF"};
    private static final String[] MIMETypes = new String[]{"image/tiff"};
    private static final String readerClassName = "com.sun.imageio.plugins.tiff.TIFFImageReader";
    private static final String[] writerSpiNames = null;

    public TIFFImageReaderSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, ImageReaderSpi.STANDARD_INPUT_TYPE, writerSpiNames, false, null, null, null, null, false, null, null, null, null);
    }

    public String getDescription(Locale locale) {
        return "Standard TIFF image reader";
    }

    public boolean canDecodeInput(Object object) throws IOException {
        boolean bl;
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        byte[] byArray = new byte[2];
        imageInputStream.readFully(byArray);
        boolean bl2 = byArray[0] == 77 && byArray[1] == 77;
        boolean bl3 = bl = byArray[0] == 73 && byArray[1] == 73;
        if (!bl2 && !bl) {
            imageInputStream.reset();
            return false;
        }
        if (bl2) {
            imageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
        } else {
            imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }
        imageInputStream.readFully(byArray);
        imageInputStream.reset();
        int n = byArray[0];
        n <<= 16;
        return (n |= byArray[1]) == 42;
    }

    public ImageReader createReaderInstance(Object object) {
        return new TIFFImageReader(this);
    }
}

