/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.tiff;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class TIFFImageReader
extends ImageReader {
    static final int fBufferSize = 4096;
    static final int fNumberOfImages = 1;
    ImageInputStream stream = null;
    boolean fileProcessed = false;
    BufferedImage bim = null;

    public TIFFImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        if (object != null) {
            if (!(object instanceof ImageInputStream)) {
                throw new IllegalArgumentException("input not an ImageInputStream");
            }
            this.stream = (ImageInputStream)object;
        } else {
            this.stream = null;
        }
        this.resetStreamSettings();
    }

    public int getNumImages(boolean bl) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("input not set");
        }
        if (this.seekForwardOnly && bl) {
            throw new IllegalStateException("seekForwardOnly and allowSearch can't both be true");
        }
        return 1;
    }

    public int getWidth(int n) throws IIOException {
        this.processFile(n);
        this.checkIndex(n);
        return this.bim.getWidth();
    }

    public int getHeight(int n) throws IIOException {
        this.processFile(n);
        this.checkIndex(n);
        return this.bim.getHeight();
    }

    public Iterator getImageTypes(int n) throws IIOException {
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(3));
        return arrayList.iterator();
    }

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    public IIOMetadata getStreamMetadata() throws IIOException {
        return null;
    }

    public IIOMetadata getImageMetadata(int n) throws IIOException {
        return null;
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IIOException {
        this.processFile(n);
        this.checkIndex(n);
        return this.bim;
    }

    public void reset() {
        super.reset();
        this.resetStreamSettings();
    }

    void processFile(int n) throws IIOException {
        block22: {
            byte[] byArray;
            if (this.fileProcessed) break block22;
            try {
                if (!this.originatingProvider.canDecodeInput(this.stream)) {
                    throw new IIOException("invalid tiff image");
                }
            }
            catch (IOException iOException) {
                throw new IIOException(iOException.getMessage());
            }
            this.fileProcessed = true;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            try {
                this.stream.mark();
                long l = this.stream.length();
                if (l == -1L) {
                    byArray2 = new byte[4096];
                    this.stream.readFully(byArray2);
                    while (true) {
                        byArray3 = new byte[2 * byArray2.length];
                        this.stream.readFully(byArray3);
                        byte[] byArray4 = new byte[byArray2.length + byArray3.length];
                        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
                        System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
                        byArray2 = byArray4;
                    }
                }
                if (l > Integer.MAX_VALUE) {
                    throw new IIOException("cannot handle " + l + " bit long tiff");
                }
                byArray2 = new byte[(int)l];
                this.stream.readFully(byArray2);
            }
            catch (EOFException eOFException) {
                if (byArray3 != null) {
                    byArray = new byte[byArray2.length + byArray3.length];
                    System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                    System.arraycopy(byArray3, 0, byArray, byArray2.length, byArray3.length);
                    byArray2 = byArray;
                }
            }
            catch (IOException iOException) {
                throw new IIOException(iOException.getMessage());
            }
            try {
                this.stream.reset();
            }
            catch (IOException iOException) {
                throw new IIOException(iOException.getMessage());
            }
            int[] nArray = new int[11];
            byArray = null;
            try {
                byArray = this.decode(byArray2, nArray);
            }
            catch (Exception exception) {
                throw new IIOException(exception.getMessage());
            }
            catch (Error error) {
                throw new IIOException(error.getMessage());
            }
            int n2 = nArray[0];
            boolean bl = nArray[1] == 1;
            boolean bl2 = nArray[2] == 1;
            int n3 = nArray[3];
            int n4 = nArray[4];
            int n5 = nArray[5];
            int n6 = nArray[6];
            int n7 = nArray[7];
            boolean bl3 = nArray[8] == 1;
            int n8 = nArray[9];
            int n9 = nArray[10];
            if (byArray == null) {
                if (bl3) {
                    throw new IIOException("cannot handle planar tiffs yet (bitsPerSample=" + n2 + ", hasAlpha=" + bl + ", isOpaque=" + bl2 + ", pixelsWide=" + n3 + ", pixelsHigh=" + n4 + ", bitsPerPixel=" + n5 + ", bytesPerPlane=" + n6 + ", bytesPerRow=" + n7 + ", isPlanar=" + bl3 + ", numberOfPlanes=" + n8 + ", samplesPerPixel=" + n9 + ")");
                }
                throw new IIOException("error while decoding tiff (bitsPerSample=" + n2 + ", hasAlpha=" + bl + ", isOpaque=" + bl2 + ", pixelsWide=" + n3 + ", pixelsHigh=" + n4 + ", bitsPerPixel=" + n5 + ", bytesPerPlane=" + n6 + ", bytesPerRow=" + n7 + ", isPlanar=" + bl3 + ", numberOfPlanes=" + n8 + ", samplesPerPixel=" + n9 + ")");
            }
            if (n5 <= 16) {
                throw new IIOException("cannot handle such tiffs yet (bitsPerSample=" + n2 + ", hasAlpha=" + bl + ", isOpaque=" + bl2 + ", pixelsWide=" + n3 + ", pixelsHigh=" + n4 + ", bitsPerPixel=" + n5 + ", bytesPerPlane=" + n6 + ", bytesPerRow=" + n7 + ", isPlanar=" + bl3 + ", numberOfPlanes=" + n8 + ", samplesPerPixel=" + n9 + ")");
            }
            this.bim = ImageReader.getDestination(this.getDefaultReadParam(), this.getImageTypes(n), n3, n4);
            WritableRaster writableRaster = this.bim.getRaster();
            DataBuffer dataBuffer = writableRaster.getDataBuffer();
            if (n5 == 32) {
                int n10 = 0;
                int n11 = 0;
                while (n11 < dataBuffer.getSize()) {
                    dataBuffer.setElem(n11, byArray[n10++] << 24 | byArray[n10++] << 16 | byArray[n10++] << 8 | byArray[n10++]);
                    ++n11;
                }
            } else {
                int n12 = 0;
                int n13 = 0;
                while (n13 < dataBuffer.getSize()) {
                    dataBuffer.setElem(n13, 0xFF000000 | byArray[n12++] << 16 | byArray[n12++] << 8 | byArray[n12++]);
                    ++n13;
                }
            }
        }
    }

    void checkIndex(int n) throws IIOException {
        if (n < 0 || n >= 1) {
            throw new IndexOutOfBoundsException();
        }
    }

    void resetStreamSettings() {
        this.fileProcessed = false;
        this.bim = null;
    }

    private native byte[] decode(byte[] var1, int[] var2);
}

