/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CocoaEvent;
import apple.awt.ContainerModel;
import apple.awt.EventFactoryProxy;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import sun.awt.PeerEvent;
import sun.java2d.SunGraphics2D;

public class PeerPaintEvent
extends CocoaEvent
implements Runnable {
    ContainerModel fPeer;
    private long fView;
    public Object fInPaintLOCK = new Object();
    private boolean fInPaintLOCKABLE = false;
    boolean fDispatched = false;
    private long fNSGraphicsContext = 0L;
    boolean fLiveResize = false;
    boolean fFirstTimePaintedByCocoa = true;
    private Object fResizeEventLOCK = new Object();
    ComponentEvent fResizeEvent;
    private boolean fSurfaceDataStale = false;

    public PeerPaintEvent(ContainerModel containerModel, long l) {
        super((Object)containerModel, null, 1L, CocoaEvent.kPaintPriority);
        this.fPeer = containerModel;
        this.fView = l;
        this.fResizeEvent = null;
    }

    public PeerEvent coalesceEvents(PeerEvent peerEvent) {
        if (peerEvent == this) {
            return peerEvent;
        }
        return null;
    }

    void markSurfaceDataStale() {
        this.fSurfaceDataStale = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResizeEvent(ComponentEvent componentEvent) {
        Object object = this.fResizeEventLOCK;
        synchronized (object) {
            this.fResizeEvent = componentEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentEvent popResizeEvent() {
        Object object = this.fResizeEventLOCK;
        synchronized (object) {
            ComponentEvent componentEvent = this.fResizeEvent;
            this.fResizeEvent = null;
            return componentEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResizePending() {
        Object object = this.fResizeEventLOCK;
        synchronized (object) {
            return this.fResizeEvent != null;
        }
    }

    public void run() {
        this.dispatch();
    }

    protected Component getTarget() {
        return this.fPeer.fTarget;
    }

    protected Object getEventTarget() {
        return this.fPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void dispatch() {
        try {
            try {
                CocoaEvent.dispatchAlert(null);
                if (!this.fPeer.fTarget.isVisible()) {
                    this.fDispatched = true;
                    this.notifyAll();
                    return;
                }
                if (this.fNSGraphicsContext == 0L) {
                    this.fDispatched = true;
                    this.notifyAll();
                    return;
                }
                if (this.fView == 0L) {
                    this.fPeer.resetViewPtr();
                    this.fView = this.fPeer.getViewPtr();
                    if (this.fView == 0L) {
                        this.fDispatched = true;
                        this.notifyAll();
                        return;
                    }
                }
                try {
                    try {
                        Object object = this.fInPaintLOCK;
                        synchronized (object) {
                            Object object2;
                            ComponentEvent componentEvent = this.popResizeEvent();
                            if (componentEvent != null) {
                                object2 = null;
                                if (this.fFirstTimePaintedByCocoa) {
                                    this.fFirstTimePaintedByCocoa = false;
                                    object2 = this.fPeer.fTarget.getParent();
                                    if (object2 == null && this.fPeer.fTarget instanceof Container) {
                                        object2 = (Container)this.fPeer.fTarget;
                                    }
                                }
                                try {
                                    this.fPeer.fTarget.dispatchEvent(componentEvent);
                                    if (object2 != null) {
                                        ((Container)object2).invalidate();
                                        ((Container)object2).validate();
                                    }
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            }
                            this.fPeer.setCurrentContext(this.fNSGraphicsContext, true);
                            if (this.fSurfaceDataStale) {
                                this.fSurfaceDataStale = false;
                                this.fPeer.replaceSurfaceData();
                            }
                            object2 = this.fPeer.getGraphics();
                            try {
                                this.fPeer.paintDamagedArea();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.fPeer.completeContext();
                            this.fPeer.unsetCurrentContext(this.fNSGraphicsContext);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        Object var7_15 = null;
                        this.fDispatched = true;
                        this.notifyAll();
                        return;
                    }
                    Object var7_14 = null;
                    this.fDispatched = true;
                    this.notifyAll();
                    return;
                }
                catch (Throwable throwable) {
                    Object var7_16 = null;
                    this.fDispatched = true;
                    this.notifyAll();
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.fDispatched = true;
                this.notifyAll();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            throw throwable;
        }
    }

    private synchronized boolean waitForDispatch() {
        EventFactoryProxy.setCurrentEvent(this);
        int n = 0;
        try {
            while (this.fPeer.fTarget.isVisible() && !this.fDispatched) {
                this.wait(30L);
                if (!(EventFactoryProxy.getCurrentEvent() instanceof PeerPaintEvent)) {
                    ++n;
                }
                if (n <= 2) continue;
                EventFactoryProxy.setCurrentEvent(null);
                return false;
            }
            EventFactoryProxy.setCurrentEvent(null);
        }
        catch (InterruptedException interruptedException) {
            EventFactoryProxy.setCurrentEvent(null);
            interruptedException.printStackTrace();
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintFromCocoaDrawRect(int n, int n2, int n3, int n4, boolean bl, long l) {
        Object object = this.fInPaintLOCK;
        synchronized (object) {
            if (this.fInPaintLOCKABLE) {
                return;
            }
            this.fDispatched = false;
            this.fInPaintLOCKABLE = true;
            this.fNSGraphicsContext = l;
            this.fLiveResize = bl;
        }
        PeerPaintEvent peerPaintEvent = this;
        synchronized (peerPaintEvent) {
            this.fPeer.addDamagedArea(n, n2, n3, n4);
            if (this.postToQueue()) {
                if (!this.waitForDispatch()) {
                    // empty if block
                }
                Object object2 = this.fInPaintLOCK;
                synchronized (object2) {
                    this.fNSGraphicsContext = 0L;
                    this.fInPaintLOCKABLE = false;
                    this.fDispatched = true;
                    this.fLiveResize = false;
                }
            }
            Object object3 = this.fInPaintLOCK;
            synchronized (object3) {
                this.fNSGraphicsContext = 0L;
                this.fInPaintLOCKABLE = false;
                this.fDispatched = true;
                this.fLiveResize = false;
            }
        }
    }

    public Image printFromCocoaDrawRect(int n, int n2, int n3, int n4, float f, float f2) {
        BufferedImage bufferedImage = new BufferedImage(Math.abs((int)((float)n3 * f)), Math.abs((int)((float)n4 * f2)), 3);
        SunGraphics2D sunGraphics2D = (SunGraphics2D)bufferedImage.createGraphics();
        sunGraphics2D.scale(f, f2);
        this.fPeer.fTarget.paint(sunGraphics2D);
        this.fPeer.fTarget.getGraphics().drawImage(bufferedImage, 0, 0, null);
        this.fPeer.fTarget.repaint();
        return bufferedImage;
    }

    private boolean isDispatchThread() {
        try {
            return EventQueue.isDispatchThread();
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

