/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CGraphicsDevice;
import apple.awt.IntegerNIORaster;
import apple.awt.OSXOffScreenImage;
import apple.awt.OSXVolatileImage;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.security.AccessController;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SurfaceData;
import sun.java2d.loops.SurfaceType;
import sun.security.action.GetPropertyAction;

public class OSXOffScreenSurfaceData
extends BufImgSurfaceData {
    public static final String DESC_INT_ARGB_DDA = "Integer ARGB";
    public static final SurfaceType sIntArgbDDA;
    private int fTransparency;
    private Image fImage;
    private static boolean sForceVRAMhwaccel;

    private static void initIDs() {
    }

    private static void initHwaccel() {
    }

    public static OSXOffScreenSurfaceData createData(int n, int n2, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Image image, boolean bl) {
        if (!((CGraphicsDevice)graphicsConfiguration.getDevice()).isOffscreenAccelerationEnabled()) {
            return null;
        }
        int n3 = bl ? 2 : 1;
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, n3);
        OSXOffScreenSurfaceData oSXOffScreenSurfaceData = OSXOffScreenSurfaceData.createDataINIO(bufferedImage, image, OSXOffScreenSurfaceData.getSurfaceType(colorModel, n3), n3);
        oSXOffScreenSurfaceData.initSolidLoops();
        return oSXOffScreenSurfaceData;
    }

    protected OSXOffScreenSurfaceData(BufferedImage bufferedImage, Image image, SurfaceType surfaceType, int n) {
        super(bufferedImage, surfaceType);
        this.fImage = image;
        this.fTransparency = n;
    }

    static OSXOffScreenSurfaceData createDataINIO(BufferedImage bufferedImage, Image image, SurfaceType surfaceType, int n) {
        OSXOffScreenSurfaceData oSXOffScreenSurfaceData = new OSXOffScreenSurfaceData(bufferedImage, image, surfaceType, n);
        IntegerNIORaster integerNIORaster = (IntegerNIORaster)bufferedImage.getRaster();
        oSXOffScreenSurfaceData.initNIORaster(integerNIORaster.getBuffer(), integerNIORaster.getWidth(), integerNIORaster.getHeight());
        return oSXOffScreenSurfaceData;
    }

    public static SurfaceType getSurfaceType(ColorModel colorModel, int n) {
        return sIntArgbDDA;
    }

    public void initSurface(int n, int n2, int n3, int n4, int n5, boolean bl) {
    }

    public SurfaceData getReplacement() {
        if (this.fImage instanceof OSXOffScreenImage) {
            return ((OSXOffScreenImage)((Object)this.fImage)).restoreContents();
        }
        if (this.fImage instanceof OSXVolatileImage) {
            return ((OSXVolatileImage)this.fImage).restoreContents();
        }
        return null;
    }

    public void restoreSurface() {
    }

    public void flush() {
    }

    public Raster getRaster() {
        return super.getRaster(0, 0, this.getBounds().width, this.getBounds().height);
    }

    public int getTransparency() {
        return this.fTransparency;
    }

    static {
        String string;
        boolean bl;
        sIntArgbDDA = SurfaceType.IntRgb.deriveSubType(DESC_INT_ARGB_DDA);
        OSXOffScreenSurfaceData.initIDs();
        String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.nohwaccel"));
        String string3 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.hwacceloffscreen"));
        String string4 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.hwaccelforcevram"));
        String string5 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.hwaccelblit"));
        String string6 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.hwaccelscale"));
        boolean bl2 = string3 != null && (string3.equals("false") || string3.equals("f"));
        sForceVRAMhwaccel = string4 != null && (string4.equals("true") || string4.equals("t"));
        boolean bl3 = string5 != null && (string5.equals("false") || string5.equals("f"));
        boolean bl4 = bl = string6 == null || string6.equals("false") || string6.equals("f");
        if (!(string2 != null || bl2 || (string = AccessController.doPrivileged(new GetPropertyAction("javax.accessibility.screen_magnifier_present"))) != null && string.equals("true"))) {
            OSXOffScreenSurfaceData.initHwaccel();
            if (!bl3) {
                // empty if block
            }
            if (!bl) {
                // empty if block
            }
            if (sForceVRAMhwaccel) {
                // empty if block
            }
        }
    }
}

