/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CGraphicsConfig;
import apple.awt.CGraphicsEnvironment;
import apple.awt.CSurfaceData;
import apple.awt.OSXOffScreenSurfaceData;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import sun.awt.DisplayChangedListener;
import sun.awt.image.AcceleratedOffScreenImage;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;

public class OSXOffScreenImage
extends AcceleratedOffScreenImage
implements DisplayChangedListener {
    private Hashtable cachedHWSD = new Hashtable();

    public OSXOffScreenImage(Component component, ColorModel colorModel, WritableRaster writableRaster, boolean bl) {
        super(component, colorModel, writableRaster, bl);
        ((CGraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment()).addDisplayChangedListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayChanged() {
        if (!AcceleratedOffScreenImage.accelerationEnabled) {
            return;
        }
        OSXOffScreenImage oSXOffScreenImage = this;
        synchronized (oSXOffScreenImage) {
            if (this.surfaceDataHw != null) {
                Hashtable hashtable = this.cachedHWSD;
                this.surfaceDataHw = null;
                this.cachedHWSD = new Hashtable();
                Object[] objectArray = hashtable.values().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    ((SurfaceData)objectArray[n]).invalidate();
                    ++n;
                }
            }
        }
    }

    public void paletteChanged() {
        this.surfaceDataSw.setNeedsBackup(true);
    }

    protected boolean isValidHWSD(GraphicsConfiguration graphicsConfiguration) {
        return this.surfaceDataHw != null && this.surfaceDataHw == this.cachedHWSD.get(graphicsConfiguration.getDevice());
    }

    protected boolean operationSupported(CompositeType compositeType, Color color, boolean bl) {
        return CompositeType.SrcNoEa.equals(compositeType) || CompositeType.SrcOverNoEa.equals(compositeType);
    }

    protected boolean destSurfaceAccelerated(SurfaceData surfaceData) {
        return surfaceData instanceof OSXOffScreenSurfaceData || surfaceData instanceof CSurfaceData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAcceleratedBackground(GraphicsConfiguration graphicsConfiguration, int n, int n2) {
        OSXOffScreenImage oSXOffScreenImage = this;
        synchronized (oSXOffScreenImage) {
            try {
                this.surfaceDataHw = (SurfaceData)this.cachedHWSD.get(graphicsConfiguration.getDevice());
                if (this.surfaceDataHw == null) {
                    this.surfaceDataHw = OSXOffScreenSurfaceData.createData(this.getWidth(), this.getHeight(), ((CGraphicsConfig)graphicsConfiguration).getColorModel(), graphicsConfiguration, (Image)((Object)this), this.isTransparent());
                    if (this.surfaceDataHw != null) {
                        this.cachedHWSD.put(graphicsConfiguration.getDevice(), this.surfaceDataHw);
                    }
                }
            }
            catch (InvalidPipeException invalidPipeException) {
                this.surfaceDataHw = null;
            }
        }
    }

    protected boolean isTransparent() {
        return false;
    }

    public void flush() {
        this.surfaceLossHw = true;
        this.surfaceDataHw = null;
        Hashtable hashtable = this.cachedHWSD;
        this.cachedHWSD = new Hashtable();
        Object[] objectArray = hashtable.values().toArray();
        int n = 0;
        while (n < objectArray.length) {
            ((OSXOffScreenSurfaceData)objectArray[n]).flush();
            ++n;
        }
    }
}

