/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.DataBufferNIOInt;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.IntBuffer;
import sun.awt.image.SunWritableRaster;

public class IntegerNIORaster
extends SunWritableRaster {
    protected IntBuffer data;

    public static WritableRaster createNIORaster(int n, int n2, int[] nArray, Point point) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Width (" + n + ") and height (" + n2 + ") cannot be <= 0");
        }
        DataBufferNIOInt dataBufferNIOInt = new DataBufferNIOInt(n * n2);
        if (point == null) {
            point = new Point(0, 0);
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(3, n, n2, n, nArray);
        return new IntegerNIORaster(singlePixelPackedSampleModel, dataBufferNIOInt, point);
    }

    public IntegerNIORaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        super(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
        if (!(dataBuffer instanceof DataBufferNIOInt)) {
            throw new RasterFormatException("IntegerNIORasters must have DataBufferNIOInt DataBuffers");
        }
        this.data = ((DataBufferNIOInt)dataBuffer).getBuffer();
    }

    public IntBuffer getBuffer() {
        this.notifyRead();
        return this.data;
    }

    public String toString() {
        return new String("IntegerNIORaster: width = " + this.width + " height = " + this.height + " #Bands = " + this.numBands + " xOff = " + this.sampleModelTranslateX + " yOff = " + this.sampleModelTranslateY);
    }
}

