/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

class HTMLDecodingInputStream
extends InputStream {
    private final BufferedInputStream bufferedStream;
    private boolean descriptionParsed = false;
    private boolean closed = false;
    private int index;
    private int end;
    public static final int BYTE_BUFFER_LEN = 8192;
    public static final int CHAR_BUFFER_LEN = 2730;
    private static final String FAILURE_MSG = "Unable to parse HTML description: ";
    private static final String INVALID_MSG = " invalid";

    public HTMLDecodingInputStream(InputStream inputStream) throws IOException {
        this.bufferedStream = new BufferedInputStream(inputStream, 8192);
    }

    private void parseDescription() throws IOException {
        int n;
        this.bufferedStream.mark(8192);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)this.bufferedStream, "UTF-8"), 2730);
        String string = bufferedReader.readLine().trim();
        if (string == null || !string.startsWith("Version:")) {
            this.index = 0;
            this.end = -1;
            this.bufferedStream.reset();
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            do {
                String string2;
                if ((string2 = bufferedReader.readLine().trim()) == null) {
                    this.close();
                    throw new IOException(FAILURE_MSG);
                }
                if (string2.startsWith("StartHTML:")) {
                    n = Integer.parseInt(string2.substring("StartHTML:".length(), string2.length()).trim());
                    if (n >= 0) {
                        this.index = n;
                        bl4 = true;
                        continue;
                    }
                    if (n == -1) continue;
                    this.close();
                    throw new IOException("Unable to parse HTML description: StartHTML: invalid");
                }
                if (string2.startsWith("EndHTML:")) {
                    n = Integer.parseInt(string2.substring("EndHTML:".length(), string2.length()).trim());
                    if (n >= 0) {
                        this.end = n;
                        bl3 = true;
                        continue;
                    }
                    if (n == -1) continue;
                    this.close();
                    throw new IOException("Unable to parse HTML description: EndHTML: invalid");
                }
                if (!bl4 && !bl3 && string2.startsWith("StartFragment:")) {
                    this.index = Integer.parseInt(string2.substring("StartFragment:".length(), string2.length()).trim());
                    if (this.index < 0) {
                        this.close();
                        throw new IOException("Unable to parse HTML description: StartFragment: invalid");
                    }
                    bl2 = true;
                    continue;
                }
                if (bl4 || bl3 || !string2.startsWith("EndFragment:")) continue;
                this.end = Integer.parseInt(string2.substring("EndFragment:".length(), string2.length()).trim());
                if (this.end < 0) {
                    this.close();
                    throw new IOException("Unable to parse HTML description: EndFragment: invalid");
                }
                bl = true;
            } while ((!bl4 || !bl3) && (!bl2 || !bl));
        }
        catch (NumberFormatException numberFormatException) {
            this.close();
            throw new IOException(FAILURE_MSG + numberFormatException);
        }
        this.bufferedStream.reset();
        n = 0;
        while (n < this.index) {
            if (this.bufferedStream.read() == -1) {
                this.close();
                throw new IOException("Unable to parse HTML description: Byte stream ends in description.");
            }
            ++n;
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (!this.descriptionParsed) {
            this.parseDescription();
            this.descriptionParsed = true;
        }
        if (this.end != -1 && this.index >= this.end) {
            return -1;
        }
        int n = this.bufferedStream.read();
        if (n == -1) {
            this.end = 0;
            this.index = 0;
            return -1;
        }
        ++this.index;
        System.out.print((char)n);
        return n;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.bufferedStream.close();
        }
    }
}

