/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CSurfaceData;
import apple.awt.ContainerModel;
import apple.awt.RuntimeOptions;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Timer;
import java.util.TimerTask;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;

class GraphicsQueue {
    static Timer sFlusherTimer = null;
    static int sTotalFlusherTasks = 0;
    static int sActiveFlusherTasks = 0;
    static long sLastFlusherWorkTime = 0L;
    CSurfaceData fSurfaceData;
    ByteBuffer fQueue;
    int fQueueIndex;
    IntBuffer fIntQueue;
    FloatBuffer fFloatQueue;
    ByteBuffer fByteParameters;
    IntBuffer fIntParameters = null;
    FloatBuffer fFloatParameters = null;
    Object[] fObjectParameters;
    ContainerModel fPeer;
    boolean fEnabled = false;
    boolean fShouldAutoFlush = false;
    TimerTask fFlusherTask = null;
    long fFlusherTaskStartTime = 0L;
    long fFlusherTaskLastWorkTime = 0L;
    int fFlusherTaskUpdates = 0;
    int fFlusherTaskFlushes = 0;
    static final long kFlusherThreadExpirationTimeout = 60000L;
    static final long kFlusherTaskExpirationTimeout = 200L;
    static final long kFlusherPeriod = 50L;
    static final boolean kFlusherPrintStats = false;

    public GraphicsQueue(CSurfaceData cSurfaceData) {
        this.fSurfaceData = cSurfaceData;
        this.fQueueIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean bl, boolean bl2, ContainerModel containerModel) {
        CSurfaceData cSurfaceData = this.fSurfaceData;
        synchronized (cSurfaceData) {
            this.fEnabled = bl;
            boolean bl3 = this.fShouldAutoFlush = bl && bl2;
            if (this.fFlusherTask != null && !this.fShouldAutoFlush) {
                this.autoFlush();
                this.cancelTimerTask();
            }
            this.fPeer = this.fShouldAutoFlush ? containerModel : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFlusher() {
        if (!this.fShouldAutoFlush) {
            return;
        }
        if (this.fFlusherTask == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (sFlusherTimer == null) {
                    sFlusherTimer = new Timer();
                    TimerTask timerTask = new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Timer timer = null;
                            long l = System.currentTimeMillis();
                            Class<?> clazz = GraphicsQueue.this.getClass();
                            synchronized (clazz) {
                                if (sActiveFlusherTasks == 0 && l - sLastFlusherWorkTime >= 60000L) {
                                    timer = sFlusherTimer;
                                    sFlusherTimer = null;
                                }
                            }
                            if (timer != null) {
                                timer.cancel();
                            }
                        }
                    };
                    sFlusherTimer.schedule(timerTask, 60000L, 60000L);
                }
                ++sTotalFlusherTasks;
                ++sActiveFlusherTasks;
                this.fFlusherTask = new TimerTask(){

                    public void run() {
                        GraphicsQueue.this.autoFlush();
                    }
                };
                this.fFlusherTaskStartTime = System.currentTimeMillis();
                sFlusherTimer.schedule(this.fFlusherTask, 50L, 50L);
            }
        }
        ++this.fFlusherTaskUpdates;
        this.fFlusherTaskLastWorkTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void autoFlush() {
        ContainerModel containerModel;
        long l = System.currentTimeMillis();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            sLastFlusherWorkTime = l;
        }
        CSurfaceData cSurfaceData = this.fSurfaceData;
        synchronized (cSurfaceData) {
            ++this.fFlusherTaskFlushes;
            containerModel = this.fPeer;
            if (l - this.fFlusherTaskLastWorkTime >= 200L) {
                this.cancelTimerTask();
                this.fPeer = null;
            }
        }
        try {
            if (containerModel == null) {
                return;
            }
            ContainerModel containerModel2 = containerModel;
            synchronized (containerModel2) {
                if (!containerModel.isDisposed()) {
                    CSurfaceData cSurfaceData2 = this.fSurfaceData;
                    synchronized (cSurfaceData2) {
                        this.flushIfNeeded();
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("*** CSurfaceData$GraphicsQueue.autoFlush(): exception caught: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelTimerTask() {
        CSurfaceData cSurfaceData = this.fSurfaceData;
        synchronized (cSurfaceData) {
            if (this.fFlusherTask == null) {
                return;
            }
            this.fFlusherTask.cancel();
            this.fFlusherTask = null;
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            --sActiveFlusherTasks;
            long l = System.currentTimeMillis();
        }
    }

    boolean addLine(float f, float f2, float f3, float f4) {
        if (!this.fSurfaceData.isGraphicsQueueEnabled()) {
            return false;
        }
        int n = 5;
        if (this.canThisRendererBeQueued(CSurfaceData.getRendererTypeForPrimitive(n))) {
            this.init(n);
            this.addComonInfo(n);
            this.fFloatQueue.put(this.fQueueIndex++, f);
            this.fFloatQueue.put(this.fQueueIndex++, f2);
            this.fFloatQueue.put(this.fQueueIndex++, f3);
            this.fFloatQueue.put(this.fQueueIndex++, f4);
            return true;
        }
        this.flushIfNeeded();
        return false;
    }

    boolean addRect(float f, float f2, float f3, float f4, boolean bl) {
        if (!this.fSurfaceData.isGraphicsQueueEnabled()) {
            return false;
        }
        int n = 6;
        if (this.canThisRendererBeQueued(CSurfaceData.getRendererTypeForPrimitive(n))) {
            this.init(n);
            this.addComonInfo(n);
            this.fFloatQueue.put(this.fQueueIndex++, f);
            this.fFloatQueue.put(this.fQueueIndex++, f2);
            this.fFloatQueue.put(this.fQueueIndex++, f3);
            this.fFloatQueue.put(this.fQueueIndex++, f4);
            this.fIntQueue.put(this.fQueueIndex++, bl ? 1 : 0);
            return true;
        }
        this.flushIfNeeded();
        return false;
    }

    boolean addRoundRect(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        if (!this.fSurfaceData.isGraphicsQueueEnabled()) {
            return false;
        }
        int n = 7;
        if (this.canThisRendererBeQueued(CSurfaceData.getRendererTypeForPrimitive(n))) {
            this.init(n);
            this.addComonInfo(n);
            this.fFloatQueue.put(this.fQueueIndex++, f);
            this.fFloatQueue.put(this.fQueueIndex++, f2);
            this.fFloatQueue.put(this.fQueueIndex++, f3);
            this.fFloatQueue.put(this.fQueueIndex++, f4);
            this.fFloatQueue.put(this.fQueueIndex++, f5);
            this.fFloatQueue.put(this.fQueueIndex++, f6);
            this.fIntQueue.put(this.fQueueIndex++, bl ? 1 : 0);
            return true;
        }
        this.flushIfNeeded();
        return false;
    }

    boolean addOval(float f, float f2, float f3, float f4, boolean bl) {
        if (!this.fSurfaceData.isGraphicsQueueEnabled()) {
            return false;
        }
        int n = 8;
        if (this.canThisRendererBeQueued(CSurfaceData.getRendererTypeForPrimitive(n))) {
            this.init(n);
            this.addComonInfo(n);
            this.fFloatQueue.put(this.fQueueIndex++, f);
            this.fFloatQueue.put(this.fQueueIndex++, f2);
            this.fFloatQueue.put(this.fQueueIndex++, f3);
            this.fFloatQueue.put(this.fQueueIndex++, f4);
            this.fIntQueue.put(this.fQueueIndex++, bl ? 1 : 0);
            return true;
        }
        this.flushIfNeeded();
        return false;
    }

    boolean addArc(float f, float f2, float f3, float f4, float f5, float f6, int n, boolean bl) {
        if (!this.fSurfaceData.isGraphicsQueueEnabled()) {
            return false;
        }
        int n2 = 9;
        if (this.canThisRendererBeQueued(CSurfaceData.getRendererTypeForPrimitive(n2))) {
            this.init(n2);
            this.addComonInfo(n2);
            this.fFloatQueue.put(this.fQueueIndex++, f);
            this.fFloatQueue.put(this.fQueueIndex++, f2);
            this.fFloatQueue.put(this.fQueueIndex++, f3);
            this.fFloatQueue.put(this.fQueueIndex++, f4);
            this.fFloatQueue.put(this.fQueueIndex++, f5);
            this.fFloatQueue.put(this.fQueueIndex++, f6);
            this.fIntQueue.put(this.fQueueIndex++, n);
            this.fIntQueue.put(this.fQueueIndex++, bl ? 1 : 0);
            return true;
        }
        this.flushIfNeeded();
        return false;
    }

    void addComonInfo(int n) {
        this.fSurfaceData.markDirty(true);
        IntBuffer intBuffer = this.fSurfaceData.fIntParameters;
        boolean bl = this.fQueueIndex == 0;
        boolean bl2 = (this.fSurfaceData.fChangeFlag & 8) != 0;
        boolean bl3 = bl2 || bl;
        this.fIntQueue.put(this.fQueueIndex++, n);
        if (bl3) {
            this.fIntQueue.put(this.fQueueIndex++, 1);
            this.fIntQueue.put(this.fQueueIndex++, intBuffer.get(19));
            this.fIntQueue.put(this.fQueueIndex++, intBuffer.get(20));
        } else {
            this.fIntQueue.put(this.fQueueIndex++, 0);
        }
        this.updateFlusher();
    }

    boolean canThisRendererBeQueued(int n) {
        boolean bl = false;
        IntBuffer intBuffer = this.fSurfaceData.fIntParameters;
        switch (n) {
            case 0: {
                int n2 = -10;
                if ((this.fSurfaceData.fChangeFlag & n2) != 0 || intBuffer.get(19) != 0 && intBuffer.get(19) != 2) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    void init(int n) {
        boolean bl;
        boolean bl2 = bl = this.fQueueIndex == 0;
        if (bl) {
            if (this.fByteParameters == null) {
                this.fByteParameters = CSurfaceData.getBufferOfSize(48);
                this.fIntParameters = this.fByteParameters.asIntBuffer();
                this.fFloatParameters = this.fByteParameters.asFloatBuffer();
                this.fObjectParameters = new Object[6];
            }
            IntBuffer intBuffer = this.fSurfaceData.fIntParameters;
            Object[] objectArray = this.fSurfaceData.fObjectParameters;
            int n2 = 0;
            while (n2 < intBuffer.capacity()) {
                this.fIntParameters.put(n2, intBuffer.get(n2));
                ++n2;
            }
            System.arraycopy(objectArray, 0, this.fObjectParameters, 0, objectArray.length);
        }
        if (this.fQueue == null) {
            this.fQueue = CSurfaceData.getBufferOfSize(24);
            this.fIntQueue = this.fQueue.asIntBuffer();
            this.fFloatQueue = this.fQueue.asFloatBuffer();
        } else {
            this.assureQueueHasEnoughRoom(n);
        }
    }

    void assureQueueHasEnoughRoom(int n) {
        if (!this.canThisPrimitiveFitInQueue(n)) {
            if (this.fIntQueue.capacity() < CSurfaceData.kMaxQueueSize) {
                ByteBuffer byteBuffer = CSurfaceData.getBufferOfSize(this.fQueue.capacity() / 4 * 5);
                IntBuffer intBuffer = byteBuffer.asIntBuffer();
                FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                if (this.fIntQueue.capacity() >= RuntimeOptions.EnableLazyDrawingQueueSizeGrowFlush) {
                    this.flushIfNeeded();
                } else {
                    int n2 = 0;
                    while (n2 < this.fQueueIndex) {
                        intBuffer.put(n2, this.fIntQueue.get(n2));
                        ++n2;
                    }
                }
                this.fQueue = byteBuffer;
                this.fIntQueue = intBuffer;
                this.fFloatQueue = floatBuffer;
            } else {
                this.flushIfNeeded();
            }
        }
    }

    boolean canThisPrimitiveFitInQueue(int n) {
        boolean bl = false;
        switch (n) {
            case 5: {
                bl = this.fIntQueue.capacity() - this.fQueueIndex >= 8;
                break;
            }
            case 6: {
                bl = this.fIntQueue.capacity() - this.fQueueIndex >= 9;
                break;
            }
            case 7: {
                bl = this.fIntQueue.capacity() - this.fQueueIndex >= 11;
                break;
            }
            case 8: {
                bl = this.fIntQueue.capacity() - this.fQueueIndex >= 9;
                break;
            }
            case 9: {
                bl = this.fIntQueue.capacity() - this.fQueueIndex >= 12;
                break;
            }
        }
        return bl;
    }

    boolean needToFlush() {
        return this.fQueueIndex > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushIfNeeded() {
        if (this.fQueue != null) {
            block13: {
                if (this.fSurfaceData.isActive()) {
                    if (this.needToFlush()) {
                        this.fSurfaceData.markDirty(false);
                        try {
                            this.flush(this.fSurfaceData, this.fByteParameters, this.fObjectParameters, this.fQueue, this.fQueueIndex);
                        }
                        catch (InvalidPipeException invalidPipeException) {
                            CSurfaceData cSurfaceData = (CSurfaceData)this.fSurfaceData.sg2dCurrent.getSurfaceData();
                            if (cSurfaceData != null) {
                                this.fSurfaceData.sg2dCurrent.revalidateAll();
                                CSurfaceData cSurfaceData2 = cSurfaceData;
                                synchronized (cSurfaceData2) {
                                    try {
                                        cSurfaceData.fGraphicsQueue.flush(this.fSurfaceData, this.fByteParameters, this.fObjectParameters, this.fQueue, this.fQueueIndex);
                                    }
                                    catch (InvalidPipeException invalidPipeException2) {
                                        // empty catch block
                                    }
                                    break block13;
                                }
                            }
                            System.err.println("Skipping the flushing of a non-empty queue because sg2dCurrent.getSurfaceData()=" + this.fSurfaceData.sg2dCurrent.getSurfaceData());
                        }
                    }
                } else if (!this.fSurfaceData.isActive()) {
                    System.err.println("Skipping the flushing of a non-empty queue because isActive()=" + this.fSurfaceData.isActive());
                }
            }
            this.fQueueIndex = 0;
            this.fQueue.clear();
            this.fIntQueue.clear();
            this.fFloatQueue.clear();
        }
    }

    native void flush(SurfaceData var1, ByteBuffer var2, Object[] var3, ByteBuffer var4, int var5);
}

