/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CSurfaceData;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.TextPipe;

public class CompositeCRenderer
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe,
DrawImagePipe,
TextPipe {
    protected final boolean DEBUG = false;
    protected final boolean DEBUG_PASS_THROUGH = false;
    private final int kCompositingBoundsPadX = 1;
    private final int kCompositingBoundsPadY = 1;
    SunGraphics2D fSg2d;
    PixelDrawPipe fDrawpipe;
    PixelFillPipe fFillpipe;
    ShapeDrawPipe fShapepipe;
    DrawImagePipe fImagepipe;
    TextPipe fTextpipe;
    static final AffineTransform fIdentityTfm = new AffineTransform();

    public CompositeCRenderer() {
    }

    public CompositeCRenderer(SunGraphics2D sunGraphics2D) {
        this.link(sunGraphics2D);
    }

    public void link(SunGraphics2D sunGraphics2D) {
        this.fSg2d = sunGraphics2D;
        this.fDrawpipe = sunGraphics2D.drawpipe;
        sunGraphics2D.drawpipe = this;
        this.fFillpipe = sunGraphics2D.fillpipe;
        sunGraphics2D.fillpipe = this;
        this.fShapepipe = sunGraphics2D.shapepipe;
        sunGraphics2D.shapepipe = this;
        this.fImagepipe = sunGraphics2D.imagepipe;
        sunGraphics2D.imagepipe = this;
        this.fTextpipe = sunGraphics2D.textpipe;
        sunGraphics2D.textpipe = this;
    }

    public void unlink() {
        if (this.fSg2d == null) {
            InternalError internalError = new InternalError("CompositeCRenderer.unlink: not in use - this is likely an error:");
            internalError.printStackTrace();
        }
        if (this.fSg2d != null) {
            this.fSg2d.drawpipe = this.fDrawpipe;
            this.fDrawpipe = null;
            this.fSg2d.fillpipe = this.fFillpipe;
            this.fFillpipe = null;
            this.fSg2d.shapepipe = this.fShapepipe;
            this.fShapepipe = null;
            this.fSg2d.imagepipe = this.fImagepipe;
            this.fImagepipe = null;
            this.fSg2d.textpipe = this.fTextpipe;
            this.fTextpipe = null;
            this.fSg2d = null;
        }
    }

    public void dispose() {
        if (this.fSg2d != null) {
            this.unlink();
        }
    }

    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.beginCompositingOp();
        Rectangle rectangle = this.getCompositingBounds(sunGraphics2D, n, n2, n3, n4);
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForStroke(sunGraphics2D, graphics2D, rectangle);
            graphics2D.drawLine(n, n2, n3, n4);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle);
        }
        this.endCompositingOp();
    }

    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        if (n3 * n4 > 2048) {
            if (sunGraphics2D.transformState <= 2) {
                this.drawLine(sunGraphics2D, n, n2, n + n3, n2);
                this.drawLine(sunGraphics2D, n + n3, n2, n + n3, n2 + n4);
                this.drawLine(sunGraphics2D, n + n3, n2 + n4, n, n2 + n4);
                this.drawLine(sunGraphics2D, n, n2 + n4, n, n2);
                return;
            }
        }
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, true);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForStroke(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.drawRect(n, n2, n3, n4);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
    }

    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, true);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForStroke(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.drawRoundRect(n, n2, n3, n4, n5, n6);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
    }

    public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, true);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForStroke(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.drawOval(n, n2, n3, n4);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
    }

    public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, true);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForStroke(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.drawArc(n, n2, n3, n4, n5, n6);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
    }

    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.beginCompositingOp();
        Rectangle rectangle = this.getCompositingBounds(sunGraphics2D, nArray, nArray2, n, true, false);
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForStroke(sunGraphics2D, graphics2D, rectangle);
            graphics2D.drawPolyline(nArray, nArray2, n);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle);
        }
        this.endCompositingOp();
    }

    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.beginCompositingOp();
        Rectangle rectangle = this.getCompositingBounds(sunGraphics2D, nArray, nArray2, n, true, true);
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForStroke(sunGraphics2D, graphics2D, rectangle);
            graphics2D.drawPolygon(nArray, nArray2, n);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle);
        }
        this.endCompositingOp();
    }

    public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, false);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForFill(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.fillRect(n, n2, n3, n4);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
    }

    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, false);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForFill(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.fillRoundRect(n, n2, n3, n4, n5, n6);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
    }

    public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, false);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForFill(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.fillOval(n, n2, n3, n4);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
    }

    public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, false);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForFill(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.fillArc(n, n2, n3, n4, n5, n6);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
    }

    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.beginCompositingOp();
        Rectangle rectangle = this.getCompositingBounds(sunGraphics2D, nArray, nArray2, n, false, true);
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForFill(sunGraphics2D, graphics2D, rectangle);
            graphics2D.fillPolygon(nArray, nArray2, n);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle);
        }
        this.endCompositingOp();
    }

    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        this.beginCompositingOp();
        Rectangle rectangle = this.getCompositingBounds(sunGraphics2D, shape, true);
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForStroke(sunGraphics2D, graphics2D, rectangle);
            graphics2D.draw(shape);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle);
        }
        this.endCompositingOp();
    }

    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        this.beginCompositingOp();
        Rectangle rectangle = this.getCompositingBounds(sunGraphics2D, shape, false);
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForFill(sunGraphics2D, graphics2D, rectangle);
            graphics2D.fill(shape);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle);
        }
        this.endCompositingOp();
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        boolean bl = true;
        this.beginCompositingOp();
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        if (n3 == -1 || n4 == -1) {
            bl = this.waitForValidImageDimensions(image);
            n3 = image.getWidth(null);
            n4 = image.getHeight(null);
        }
        if (bl) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, false);
            if (rectangle2.width > 0 && rectangle2.height > 0) {
                BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                this.syncUpGraphicsContextsForImage(sunGraphics2D, graphics2D, rectangle2);
                graphics2D.drawImage(image, n, n2, color, imageObserver);
                graphics2D.dispose();
                this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
            }
        }
        this.endCompositingOp();
        return bl;
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, Color color, ImageObserver imageObserver) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n, n2, n5, n6);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, false);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForImage(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.drawImage(image, n, n2, n + n5, n2 + n6, n3, n4, n3 + n5, n3 + n6, color, imageObserver);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
        return true;
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, false);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForImage(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.drawImage(image, n, n2, n3, n4, color, imageObserver);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
        return true;
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(Math.min(n, n3), Math.min(n2, n4), Math.abs(n3 - n), Math.abs(n4 - n2));
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, false);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForImage(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
        return true;
    }

    public boolean transformImage(SunGraphics2D sunGraphics2D, Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        boolean bl = this.doTransformImage(sunGraphics2D, image, affineTransform, null, imageObserver);
        return bl;
    }

    public void transformImage(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(n, n2);
        this.doTransformImage(sunGraphics2D, bufferedImage, affineTransform, bufferedImageOp, null);
    }

    protected boolean doTransformImage(SunGraphics2D sunGraphics2D, Image image, AffineTransform affineTransform, BufferedImageOp bufferedImageOp, ImageObserver imageObserver) {
        boolean bl = true;
        this.beginCompositingOp();
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n == -1 || n2 == -1) {
            bl = this.waitForValidImageDimensions(image);
            n = image.getWidth(null);
            n2 = image.getHeight(null);
        }
        if (bl) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(n, 0.0f);
            generalPath.lineTo(n, n2);
            generalPath.lineTo(0.0f, n2);
            generalPath.closePath();
            AffineTransform affineTransform2 = sunGraphics2D.getTransform();
            generalPath.transform(affineTransform);
            generalPath.transform(affineTransform2);
            Rectangle rectangle = generalPath.getBounds();
            SurfaceData surfaceData = sunGraphics2D.getSurfaceData();
            Rectangle rectangle2 = sunGraphics2D.clipState == 0 ? surfaceData.getBounds() : sunGraphics2D.getClipBounds();
            Rectangle rectangle3 = rectangle.intersection(rectangle2);
            if (rectangle3.width > 0 && rectangle3.height > 0) {
                BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle3);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                this.syncUpGraphicsContextsForImage(sunGraphics2D, graphics2D, rectangle3);
                if (bufferedImageOp != null) {
                    graphics2D.drawImage((BufferedImage)image, bufferedImageOp, (int)affineTransform.getTranslateX(), (int)affineTransform.getTranslateY());
                    BufferedImage bufferedImage2 = this.createCompositingSourceImage(sunGraphics2D, rectangle3);
                    bufferedImageOp.filter(bufferedImage, bufferedImage2);
                    bufferedImage = bufferedImage2;
                } else {
                    graphics2D.drawImage(image, affineTransform, imageObserver);
                }
                graphics2D.dispose();
                this.compositeImage(sunGraphics2D, bufferedImage, rectangle3);
            }
        }
        this.endCompositingOp();
        return bl;
    }

    public void drawString(SunGraphics2D sunGraphics2D, String string, float f, float f2) {
        this.beginCompositingOp();
        FontRenderContext fontRenderContext = sunGraphics2D.getFontRenderContext();
        Font font = sunGraphics2D.getFont();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        rectangle2D.setRect((int)f, (int)((double)f2 - rectangle2D.getHeight()), Math.ceil((double)f + rectangle2D.getWidth()) - (double)((int)f), Math.ceil(f2) - (double)((int)((double)f2 - rectangle2D.getHeight())));
        Rectangle rectangle = this.getCompositingBounds(sunGraphics2D, rectangle2D, false);
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForFill(sunGraphics2D, graphics2D, rectangle);
            graphics2D.drawString(string, f, f2);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle);
        }
        this.endCompositingOp();
    }

    public void drawGlyphVector(SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f, float f2) {
        this.beginCompositingOp();
        Rectangle2D rectangle2D = glyphVector.getVisualBounds();
        rectangle2D.setRect(Math.floor(f), Math.floor(f2), Math.ceil((double)f + rectangle2D.getWidth()) - (double)((int)f), Math.ceil((double)f2 + rectangle2D.getHeight()) - (double)((int)f2));
        Rectangle rectangle = this.getCompositingBounds(sunGraphics2D, rectangle2D, false);
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForFill(sunGraphics2D, graphics2D, rectangle);
            graphics2D.drawGlyphVector(glyphVector, f, f2);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle);
        }
        this.endCompositingOp();
    }

    public void drawChars(SunGraphics2D sunGraphics2D, char[] cArray, int n, int n2, int n3, int n4) {
        String string = new String(cArray, n, n2);
        this.drawString(sunGraphics2D, string, n3, n4);
    }

    public void drawBytes(SunGraphics2D sunGraphics2D, byte[] byArray, int n, int n2, int n3, int n4) {
        String string = new String(byArray, n, n2);
        this.drawString(sunGraphics2D, string, n3, n4);
    }

    protected void beginCompositingOp() {
    }

    protected void endCompositingOp() {
    }

    private BufferedImage createCompatibleImage(SunGraphics2D sunGraphics2D, int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = sunGraphics2D.getDeviceConfiguration();
        Object object = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = ((GraphicsEnvironment)object).getDefaultScreenDevice();
        graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        object = graphicsConfiguration.createCompatibleImage(n, n2);
        return object;
    }

    protected BufferedImage createCompositingSourceImage(SunGraphics2D sunGraphics2D, Rectangle rectangle) {
        BufferedImage bufferedImage = this.createCompatibleImage(sunGraphics2D, rectangle.width, rectangle.height);
        return bufferedImage;
    }

    protected void compositeImage(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, Rectangle rectangle) {
        BufferedImage bufferedImage2 = this.createCompatibleImage(sunGraphics2D, rectangle.width, rectangle.height);
        BufImgSurfaceData.createData(bufferedImage2);
        BufferedImage bufferedImage3 = bufferedImage2;
        if (sunGraphics2D.compositeState >= 3) {
            bufferedImage3 = this.createCompatibleImage(sunGraphics2D, rectangle.width, rectangle.height);
            BufImgSurfaceData.createData(bufferedImage3);
        }
        CSurfaceData cSurfaceData = (CSurfaceData)sunGraphics2D.getSurfaceData();
        cSurfaceData.copyArea(sunGraphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bufferedImage2);
        Composite composite = sunGraphics2D.getComposite();
        CompositeContext compositeContext = composite.createContext(bufferedImage.getColorModel(), bufferedImage2.getColorModel(), sunGraphics2D.getRenderingHints());
        compositeContext.compose(bufferedImage.getRaster(), bufferedImage2.getRaster(), bufferedImage3.getRaster());
        compositeContext.dispose();
        AffineTransform affineTransform = sunGraphics2D.getTransform();
        Composite composite2 = sunGraphics2D.getComposite();
        sunGraphics2D.setTransform(fIdentityTfm);
        sunGraphics2D.setComposite(AlphaComposite.Src);
        int n = rectangle.x - sunGraphics2D.constrainX;
        int n2 = rectangle.y - sunGraphics2D.constrainY;
        sunGraphics2D.drawImage((Image)bufferedImage3, n, n2, null);
        sunGraphics2D.setComposite(composite2);
        sunGraphics2D.setTransform(affineTransform);
    }

    protected Rectangle getClipBounds(SunGraphics2D sunGraphics2D) {
        Object object;
        Rectangle rectangle;
        Rectangle rectangle2 = sunGraphics2D.getCompBounds();
        if (sunGraphics2D.clipState == 0) {
            rectangle = null;
        } else if (sunGraphics2D.transformState == 0) {
            rectangle = sunGraphics2D.getClipBounds();
        } else {
            object = sunGraphics2D.getTransform();
            int n = sunGraphics2D.constrainX;
            int n2 = sunGraphics2D.constrainY;
            sunGraphics2D.constrainY = 0;
            sunGraphics2D.constrainX = 0;
            sunGraphics2D.setTransform(fIdentityTfm);
            rectangle = sunGraphics2D.getClipBounds();
            sunGraphics2D.constrainX = n;
            sunGraphics2D.constrainY = n2;
            sunGraphics2D.setTransform((AffineTransform)object);
        }
        rectangle = rectangle == null ? rectangle2 : rectangle2.intersection(rectangle);
        object = sunGraphics2D.getSurfaceData();
        Rectangle rectangle3 = ((SurfaceData)object).getBounds();
        rectangle = rectangle3.intersection(rectangle);
        return rectangle;
    }

    protected Rectangle getCompositingBounds(SunGraphics2D sunGraphics2D, Shape shape, boolean bl) {
        Rectangle rectangle;
        Object object;
        Object object2;
        if (bl) {
            object2 = sunGraphics2D.getStroke();
            object = object2.createStrokedShape(shape);
            rectangle = object.getBounds();
        } else {
            rectangle = shape.getBounds();
        }
        if (sunGraphics2D.transformState != 0) {
            if (sunGraphics2D.transformState == 1) {
                rectangle.translate(sunGraphics2D.transX, sunGraphics2D.transY);
            } else if (sunGraphics2D.transformState == 2) {
                object2 = sunGraphics2D.getTransform();
                rectangle.x = (int)((double)rectangle.x * ((AffineTransform)object2).getScaleX() + ((AffineTransform)object2).getTranslateX());
                rectangle.y = (int)((double)rectangle.y * ((AffineTransform)object2).getScaleY() + ((AffineTransform)object2).getTranslateY());
                rectangle.width = (int)Math.ceil((double)rectangle.width * ((AffineTransform)object2).getScaleX());
                rectangle.height = (int)Math.ceil((double)rectangle.height * ((AffineTransform)object2).getScaleY());
            } else {
                object2 = new Point(rectangle.x, rectangle.y);
                object = new Point(rectangle.x + rectangle.width, rectangle.y);
                Point point = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                Point point2 = new Point(rectangle.x, rectangle.y + rectangle.height);
                AffineTransform affineTransform = sunGraphics2D.getTransform();
                affineTransform.transform((Point2D)object2, (Point2D)object2);
                affineTransform.transform((Point2D)object, (Point2D)object);
                affineTransform.transform(point, point);
                affineTransform.transform(point2, point2);
                rectangle.x = Math.min(((Point)object2).x, ((Point)object).x);
                rectangle.x = Math.min(rectangle.x, point.x);
                rectangle.x = Math.min(rectangle.x, point2.x);
                rectangle.y = Math.min(((Point)object2).y, ((Point)object).y);
                rectangle.y = Math.min(rectangle.y, point.y);
                rectangle.y = Math.min(rectangle.y, point2.y);
                rectangle.width = ((Point)object).x - rectangle.x;
                rectangle.width = Math.max(rectangle.width, point.x - rectangle.x);
                rectangle.width = Math.max(rectangle.width, point2.x - rectangle.x);
                rectangle.height = ((Point)object).y - rectangle.y;
                rectangle.height = Math.max(rectangle.height, point.y - rectangle.y);
                rectangle.height = Math.max(rectangle.height, point2.y - rectangle.y);
            }
        }
        --rectangle.x;
        --rectangle.y;
        rectangle.width += 2;
        rectangle.height += 2;
        object2 = this.getClipBounds(sunGraphics2D);
        object = rectangle.intersection((Rectangle)object2);
        return object;
    }

    protected Rectangle getCompositingBounds(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n, n2);
        generalPath.lineTo(n3, n4);
        if (sunGraphics2D.transformState <= 2) {
            rectangle = this.getCompositingBounds(sunGraphics2D, generalPath, true);
        } else {
            AffineTransform affineTransform = sunGraphics2D.getTransform();
            generalPath.transform(affineTransform);
            Stroke stroke = sunGraphics2D.getStroke();
            Shape shape = stroke.createStrokedShape(generalPath);
            Rectangle rectangle2 = shape.getBounds();
            --rectangle2.x;
            --rectangle2.y;
            rectangle2.width += 2;
            rectangle2.height += 2;
            Rectangle rectangle3 = this.getClipBounds(sunGraphics2D);
            rectangle = rectangle2.intersection(rectangle3);
        }
        return rectangle;
    }

    protected Rectangle getCompositingBounds(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        Shape shape;
        Shape shape2;
        if (bl) {
            shape2 = new GeneralPath();
            if (bl2) {
                ((Path2D.Float)shape2).moveTo(nArray[0], nArray2[0]);
                int n2 = 1;
                while (n2 < n) {
                    ((Path2D.Float)shape2).lineTo(nArray[n2], nArray2[n2]);
                    ++n2;
                }
                ((Path2D)shape2).closePath();
            } else {
                int n3 = 0;
                while (n3 < n) {
                    ((Path2D.Float)shape2).moveTo(nArray[n3], nArray2[n3]);
                    ((Path2D.Float)shape2).lineTo(nArray[n3 + 1], nArray2[n3 + 1]);
                    n3 += 2;
                }
            }
            shape = shape2;
        } else {
            int n4 = nArray[0];
            int n5 = nArray2[0];
            int n6 = n4;
            int n7 = n5;
            int n8 = 1;
            while (n8 < n) {
                int n9 = nArray[n8];
                int n10 = nArray2[n8];
                if (n9 < n4) {
                    n4 = n9;
                } else if (n9 > n6) {
                    n6 = n9;
                }
                if (n10 < n5) {
                    n5 = n10;
                } else if (n10 > n7) {
                    n7 = n10;
                }
                ++n8;
            }
            shape = new Rectangle(n4, n5, n6 - n4, n7 - n5);
        }
        shape2 = this.getCompositingBounds(sunGraphics2D, shape, bl);
        return shape2;
    }

    protected void syncUpGraphicsContexts(SunGraphics2D sunGraphics2D, Graphics2D graphics2D, Rectangle rectangle, boolean bl, boolean bl2) {
        Object object;
        block12: {
            block11: {
                if (sunGraphics2D.transformState == 0) {
                    graphics2D.translate(-rectangle.x, -rectangle.y);
                } else if (sunGraphics2D.transformState == 1) {
                    graphics2D.translate(-rectangle.x + sunGraphics2D.transX, -rectangle.y + sunGraphics2D.transY);
                } else if (sunGraphics2D.transformState == 2) {
                    object = sunGraphics2D.getTransform();
                    graphics2D.translate((double)(-rectangle.x) + ((AffineTransform)object).getTranslateX(), (double)(-rectangle.y) + ((AffineTransform)object).getTranslateY());
                    graphics2D.scale(((AffineTransform)object).getScaleX(), ((AffineTransform)object).getScaleY());
                } else {
                    object = sunGraphics2D.getTransform();
                    graphics2D.translate(-rectangle.x, -rectangle.y);
                    graphics2D.transform((AffineTransform)object);
                }
                if (sunGraphics2D.clipState == 2) break block11;
                if (sunGraphics2D.clipState != 1) break block12;
                if (sunGraphics2D.transformState != 3) break block12;
            }
            object = sunGraphics2D.getClip();
            graphics2D.setClip((Shape)object);
        }
        if (bl) {
            object = sunGraphics2D.getPaint();
            graphics2D.setPaint((Paint)object);
        }
        if (bl2) {
            object = sunGraphics2D.getStroke();
            graphics2D.setStroke((Stroke)object);
        }
    }

    protected void syncUpGraphicsContextsForStroke(SunGraphics2D sunGraphics2D, Graphics2D graphics2D, Rectangle rectangle) {
        this.syncUpGraphicsContexts(sunGraphics2D, graphics2D, rectangle, true, true);
    }

    protected void syncUpGraphicsContextsForFill(SunGraphics2D sunGraphics2D, Graphics2D graphics2D, Rectangle rectangle) {
        this.syncUpGraphicsContexts(sunGraphics2D, graphics2D, rectangle, true, false);
    }

    protected void syncUpGraphicsContextsForDrawText(SunGraphics2D sunGraphics2D, Graphics2D graphics2D, Rectangle rectangle) {
        this.syncUpGraphicsContexts(sunGraphics2D, graphics2D, rectangle, true, false);
    }

    protected void syncUpGraphicsContextsForImage(SunGraphics2D sunGraphics2D, Graphics2D graphics2D, Rectangle rectangle) {
        this.syncUpGraphicsContexts(sunGraphics2D, graphics2D, rectangle, false, false);
    }

    protected boolean waitForValidImageDimensions(Image image) {
        boolean bl;
        block3: {
            bl = true;
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            if (n != -1 && n2 != -1) break block3;
            Panel panel = new Panel();
            MediaTracker mediaTracker = new MediaTracker(panel);
            int n3 = 0;
            mediaTracker.addImage(image, n3);
            try {
                mediaTracker.waitForID(n3);
                if (mediaTracker.isErrorID(n3)) {
                    bl = false;
                }
            }
            catch (InterruptedException interruptedException) {
                bl = false;
            }
        }
        return bl;
    }
}

