/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CGraphicsConfig;
import apple.awt.CGraphicsDevice;
import apple.awt.CToolkit;
import apple.awt.ContainerModel;
import apple.awt.PeerPaintEvent;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.peer.DialogPeer;
import java.awt.peer.WindowPeer;

public class CWindow
extends ContainerModel
implements WindowPeer,
DialogPeer {
    public final int kNSBorderlessWindowMask = 0;
    public final int kNSTitledWindowMask = 1;
    public final int kNSClosableWindowMask = 2;
    public final int kNSMiniaturizableWindowMask = 4;
    public final int kNSResizableWindowMask = 8;
    public final int kNSTexturedBackgroundWindowMask = 256;
    public static final int kNSBackingStoreRetained = 0;
    public static final int kNSBackingStoreNonretained = 1;
    public static final int kNSBackingStoreBuffered = 2;
    private static final int kMinWindowWidth = 1;
    private static final int kMinWindowHeight = 1;
    private static final Dimension kMinSize = new Dimension(1, 1);
    Object fPeerPainterLOCK;
    int fNSWindow;
    boolean fIsDisplayed = false;
    boolean fIsTexturedType = false;
    Point fLocationOnScreen = null;
    Insets fInsets = this._getInsets(this.fNSWindow);
    private static ThreadLocal fInThreadResizeThreadLocalValue;
    private static Point alwaysZeroZero;

    private static native void initIDs();

    public CWindow(Component component) {
        super(component);
        this.fPeerPainterLOCK = new Object();
        this.fGraphicsConfiguration = this.getGraphicsConfiguration();
        ((CGraphicsDevice)this.fGraphicsConfiguration.getDevice()).addDisplayChangedListener(this);
    }

    protected void disposeImpl() {
        CGraphicsDevice cGraphicsDevice = (CGraphicsDevice)this.getGraphicsConfiguration().getDevice();
        cGraphicsDevice.removeDisplayChangedListener(this);
        this.fNSWindow = 0;
        super.disposeImpl();
    }

    public void syncTo(Component component) {
        super.syncTo(component);
    }

    public long getViewPtr() {
        if (this.fNSView == -1L) {
            this.fNSView = this._getViewPtr(this.fNSWindow);
        }
        return this.fNSView;
    }

    private native long _getViewPtr(long var1);

    public boolean handlesWheelScrolling() {
        return false;
    }

    public boolean flipIsDisplayed() {
        if (!this.fIsDisplayed) {
            this.fIsDisplayed = true;
            return false;
        }
        return true;
    }

    public int initPeer(int n) {
        long l = ((Window)this.fTarget).getOwner() != null ? ((CWindow)((Window)this.fTarget).getOwner().getPeer()).fNSWindow : 0;
        this.initContainer();
        Rectangle rectangle = this.fTarget.getBounds();
        CGraphicsDevice cGraphicsDevice = (CGraphicsDevice)this.getGraphicsConfiguration().getDevice();
        this.fNSWindow = this.createNativeWindow(this.fTarget, l, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.fTarget.isEnabled(), this.fTarget.isVisible(), this.fTarget.getFont(), this.fTarget.getBackground(), this.fTarget.isBackgroundSet(), this.fTarget.getForeground(), this.fTarget.isForegroundSet(), this.fTarget.getCursor(), this.getType(), this.getTitle(), 0, this.fTarget instanceof Frame ? ((Frame)this.fTarget).getState() : 0, 0, cGraphicsDevice.getNSScreen(), this.fTarget instanceof Dialog, this.fTarget instanceof Frame ? ((Frame)this.fTarget).isUndecorated() : false);
        this.fPeerPainterLOCKABLE = new PeerPaintEvent(this, this.getViewPtr());
        return this.fNSWindow;
    }

    protected native int createNativeWindow(Component var1, long var2, int var4, int var5, int var6, int var7, boolean var8, boolean var9, Font var10, Color var11, boolean var12, Color var13, boolean var14, Cursor var15, int var16, String var17, int var18, int var19, int var20, long var21, boolean var23, boolean var24);

    protected native int attachPaintingSurface(int var1);

    protected native void removePaintingSurface(int var1);

    protected int getType() {
        return 0;
    }

    protected Color getBackgroundColor() {
        return SystemColor.window;
    }

    protected String getTitle() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setWindowControllerView(int n, int n2, int n3) {
        this.fNSWindow = n;
        this.getViewPtr();
        Object object = this.fPeerPainterLOCK;
        synchronized (object) {
            this.fPeerPainterLOCKABLE = new PeerPaintEvent(this, (long)n3);
        }
    }

    void initContainer() {
        super.initContainer();
        if (!this.fTarget.isForegroundSet()) {
            this.fTarget.setForeground(Color.black);
        }
        if (!this.fTarget.isBackgroundSet()) {
            this.fTarget.setBackground(this.getBackgroundColor());
        }
        if (this.fTarget.getFont() == null) {
            this.fTarget.setFont(ContainerModel.sDefaultFont);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PeerPaintEvent getPeerPainter() {
        Object object = this.fPeerPainterLOCK;
        synchronized (object) {
            return this.fPeerPainterLOCKABLE;
        }
    }

    public void mouseWheel(int n) {
    }

    public void toFront() {
        this.toFront(this.fNSWindow);
    }

    private native void toFront(long var1);

    public void toBack() {
        this.toBack(this.fNSWindow);
    }

    private native void toBack(long var1);

    public void setTitle(String string) {
        this._setTitle(this.fNSWindow, string);
    }

    private native void _setTitle(long var1, String var3);

    public void setResizable(boolean bl) {
        this._setResizable(this.fNSWindow, bl);
    }

    private native void _setResizable(int var1, boolean var2);

    public void setState(int n) {
        this._setState(this.fNSWindow, n);
    }

    private native void _setState(int var1, int var2);

    public int getState() {
        return this._getState(this.fNSWindow);
    }

    private native int _getState(int var1);

    public void setMaximizedBounds(Rectangle rectangle) {
        if (rectangle == null) {
            this._resetMaxBounds(this.fNSWindow);
        } else {
            this._setMaximizeBounds(this.fNSWindow, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private native void _resetMaxBounds(int var1);

    private native void _setMaximizeBounds(int var1, int var2, int var3, int var4, int var5);

    private native Insets _getInsets(int var1);

    public Insets getInsets() {
        return this.fInsets;
    }

    public void setVisible(boolean bl) {
        this._setVisible(this.fNSWindow, this.fTarget.isEnabled(), bl);
    }

    private native void _setVisible(int var1, boolean var2, boolean var3);

    private boolean isInThreadResize() {
        return (Boolean)fInThreadResizeThreadLocalValue.get();
    }

    private void setInThreadResize(boolean bl) {
        fInThreadResizeThreadLocalValue.set(new Boolean(bl));
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.isInThreadResize()) {
            return;
        }
        this.setInThreadResize(true);
        Dimension dimension = this.fTarget.getMinimumSize();
        if (dimension == null) {
            dimension = new Dimension(n3, n4);
        }
        this.paintPending = n3 != this.oldWidth || n4 != this.oldHeight;
        this._setBounds(this.fNSWindow, n, n2, n3, n4, dimension.width + this.fInsets.left + this.fInsets.right, dimension.height + this.fInsets.top + this.fInsets.bottom);
        if (n3 != this.oldWidth || n4 != this.oldHeight) {
            this.markSurfaceDataStale();
            this.oldWidth = n3;
            this.oldHeight = n4;
        }
        this.setInThreadResize(false);
    }

    private native void _setBounds(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public Point getLocationInWindow() {
        return alwaysZeroZero;
    }

    public Point getLocationOnScreen() {
        if (this.fLocationOnScreen == null) {
            this.updateLocationOnScreen();
        }
        return (Point)this.fLocationOnScreen.clone();
    }

    void updateLocationOnScreen() {
        if (this.fNSWindow == 0) {
            this.fLocationOnScreen = null;
            return;
        }
        Point point = null;
        int[] nArray = new int[2];
        this._getLocationOnScreen(this.fNSWindow, nArray);
        this.fLocationOnScreen = point = new Point(nArray[0], nArray[1]);
    }

    private native void _getLocationOnScreen(long var1, int[] var3);

    public void requestFocus() {
        CToolkit.notImplemented();
    }

    public boolean isFocusTraversable() {
        CToolkit.notImplemented();
        return false;
    }

    public boolean isFocusable() {
        return false;
    }

    public Dimension getMinimumSize() {
        System.out.println("Returning win : " + kMinSize);
        return kMinSize;
    }

    CWindow getCWindowContainer() {
        return this;
    }

    CWindow getOwningWindow() {
        return this;
    }

    void windowUpdate() {
    }

    public void handleEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        switch (n) {
            case 101: {
                break;
            }
            default: {
                super.handleEvent(aWTEvent);
            }
        }
    }

    private boolean isModal() {
        try {
            if (this.fTarget instanceof Dialog) {
                return ((Dialog)this.fTarget).isModal();
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    private boolean isFullScreenWindow() {
        try {
            GraphicsDevice graphicsDevice = ((Graphics2D)this.fTarget.getGraphics()).getDeviceConfiguration().getDevice();
            return graphicsDevice.getFullScreenWindow() == this.fTarget;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    private native void resetGraphicsConfiguration(long var1);

    public void setDocumentEdited(boolean bl) {
        this._setDocumentEdited(this.fNSWindow, bl);
    }

    private native void _setDocumentEdited(int var1, boolean var2);

    public void displayChanged() {
        int n = CGraphicsDevice.getScreenIndexForCWindow(this.fNSWindow);
        if (n < 0) {
            return;
        }
        CGraphicsDevice cGraphicsDevice = (CGraphicsDevice)this.getGraphicsConfiguration().getDevice();
        CGraphicsDevice cGraphicsDevice2 = (CGraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[n];
        this.fGraphicsConfiguration = (CGraphicsConfig)cGraphicsDevice2.getDefaultConfiguration();
        this.resetGraphicsConfiguration(this.fNSWindow);
        if (cGraphicsDevice != cGraphicsDevice2) {
            cGraphicsDevice.removeDisplayChangedListener(this);
            cGraphicsDevice2.addDisplayChangedListener(this);
        }
        super.displayChanged();
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            CWindow.initIDs();
        }
        fInThreadResizeThreadLocalValue = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new Boolean(false);
            }
        };
        alwaysZeroZero = new Point(0, 0);
    }
}

